/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.SLEEException;
import javax.slee.SbbID;
import javax.slee.SbbLocalObject;
import javax.slee.TransactionRequiredLocalException;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbLocalObjectConcrete;
import org.mobicents.slee.runtime.SbbLocalObjectImpl;

public class ChildRelationImpl
implements ChildRelation {
    private static volatile Logger logger = Logger.getLogger((Class)ChildRelationImpl.class);
    private HashSet children;
    private SbbEntity parentEntity;
    private volatile SleeContainer container;
    private SbbID sbbid;
    private byte defaultPriority;

    private void checkTransaction() throws TransactionRequiredLocalException {
        SleeContainer.getTransactionManager().mandateTransaction();
    }

    private HashSet getLocalObjects() {
        HashSet<SbbLocalObject> localObjects = new HashSet<SbbLocalObject>();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            String sbbEntityId = (String)it.next();
            localObjects.add(this.createSbbLocalObject(sbbEntityId));
        }
        return localObjects;
    }

    public ChildRelationImpl(SbbID sbbid, byte defaultPriority, SbbEntity sbbe, HashSet children) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating child relation. children = " + children));
        }
        if (sbbid == null) {
            throw new NullPointerException(" null sbb id");
        }
        if (children == null) {
            throw new NullPointerException("Internal Error! null children passed in");
        }
        this.parentEntity = sbbe;
        this.container = SleeContainer.lookupFromJndi();
        this.sbbid = sbbid;
        this.defaultPriority = defaultPriority;
        this.children = children;
    }

    public Iterator iterator() {
        return new ChildRelationIterator(this.container, this.children);
    }

    public boolean contains(Object object) {
        if (!(object instanceof SbbLocalObject)) {
            return false;
        }
        SbbLocalObjectImpl sbblocal = (SbbLocalObjectImpl)object;
        String sbbEntityId = sbblocal.getSbbEntityId();
        return this.children.contains(sbbEntityId);
    }

    public SbbLocalObject create() throws CreateException, TransactionRequiredLocalException, SLEEException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ChildRelation.create() : Creating Sbb Entity: " + this.sbbid));
        }
        SbbEntity sbbEntity = this.container.getSbbEntityFactory().createSbbEntity(this.sbbid, this.parentEntity.getService().getServiceID(), this.parentEntity.getSbbEntityId(), this.parentEntity.getServiceConvergenceName());
        sbbEntity.setPriority(this.defaultPriority);
        try {
            if (sbbEntity.getSbbObject() == null) {
                sbbEntity.assignSbbObject(true);
            }
        }
        catch (CreateException e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Caught CreateException in creating child entity", (Throwable)e);
            }
            sbbEntity.trashObject();
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Caught RuntimeException in creating child entity", (Throwable)e);
            try {
                SleeContainer.getTransactionManager().setRollbackOnly();
            }
            catch (SystemException e1) {
                logger.error((Object)"Failed to set rollbackonly", (Throwable)e);
            }
            sbbEntity.trashObject();
        }
        this.children.add(sbbEntity.getSbbEntityId());
        logger.debug((Object)("Children is: " + this.children));
        logger.debug((Object)("sbbEntity is: " + sbbEntity));
        return sbbEntity.createSbbLocalObject();
    }

    private SbbLocalObject createSbbLocalObject(String sbbeId) {
        SbbEntity sbbEntity = this.container.getSbbEntityFactory().getSbbEntity(sbbeId);
        return sbbEntity.createSbbLocalObject();
    }

    public int size() {
        return this.children.size();
    }

    public void clear() {
        this.checkTransaction();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public boolean isEmpty() {
        this.checkTransaction();
        return this.children.isEmpty();
    }

    public Object[] toArray() {
        this.checkTransaction();
        return this.getLocalObjects().toArray();
    }

    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("null arg! ");
        }
        throw new UnsupportedOperationException("Operation not supported !");
    }

    public boolean remove(Object object) {
        this.checkTransaction();
        logger.debug((Object)("removing " + object));
        if (object == null) {
            throw new NullPointerException("Null arg for remove ");
        }
        if (!(object instanceof SbbLocalObject)) {
            return false;
        }
        String target = ((SbbLocalObjectImpl)object).getSbbEntityId();
        boolean retval = this.children.remove(target);
        if (retval) {
            logger.debug((Object)"removing entity tree !");
            ((SbbLocalObjectImpl)object).remove();
            retval = false;
        }
        return retval;
    }

    public boolean addAll(Collection c) {
        if (c == null) {
            throw new NullPointerException("Null arg!");
        }
        throw new UnsupportedOperationException("Operation not supported !");
    }

    public boolean containsAll(Collection c) {
        if (c == null) {
            throw new NullPointerException("null collection!");
        }
        HashSet localInterfaces = this.getLocalObjects();
        logger.debug((Object)("containsAll : collection = " + c + " sbbLocalObject = " + localInterfaces));
        boolean retval = true;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SbbLocalObjectConcrete sbbLocalInterface = (SbbLocalObjectConcrete)it.next();
            logger.debug((Object)("Checking membership for : " + sbbLocalInterface.getSbbEntityId()));
            if (this.children.contains(sbbLocalInterface.getSbbEntityId())) continue;
            retval = false;
            break;
        }
        return retval;
    }

    public boolean removeAll(Collection c) {
        boolean flag = true;
        if (c == null) {
            throw new NullPointerException(" null collection ! ");
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            flag &= this.remove(it.next());
        }
        return flag;
    }

    public boolean retainAll(Collection c) {
        boolean flag = false;
        if (c == null) {
            throw new NullPointerException(" null arg! ");
        }
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            flag = true;
            it.remove();
        }
        return flag;
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            throw new NullPointerException("null arg!");
        }
        HashSet localObjects = this.getLocalObjects();
        return localObjects.toArray(a);
    }

    public Iterator getChildEntities() {
        return this.children.iterator();
    }

    public void removeSbbEntity(String sbbeId) {
        this.children.remove(sbbeId);
    }

    public HashSet getSbbEntitySet() {
        return this.children;
    }

    class ChildRelationIterator
    implements Iterator {
        private HashSet sbbEntities;
        private Iterator myIterator;
        private String nextEntity;
        private SbbLocalObject nextSbbLocalObject;

        public ChildRelationIterator(SleeContainer container, HashSet entities) {
            this.sbbEntities = entities;
            this.myIterator = this.sbbEntities.iterator();
        }

        public void remove() {
            this.myIterator.remove();
            this.nextSbbLocalObject.remove();
        }

        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        public Object next() {
            this.nextEntity = (String)this.myIterator.next();
            this.nextSbbLocalObject = ChildRelationImpl.this.createSbbLocalObject(this.nextEntity);
            return this.nextSbbLocalObject;
        }
    }
}

