/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container;

import java.rmi.server.UID;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.cache.CacheableSet;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;

public class DeploymentCacheManager {
    private CacheableMap deployableUnitIDtoDescriptorMap;
    private CacheableMap urlToDeployableUnitIDMap;
    private CacheableMap referringComponents;
    private CacheableMap componentIDToDeployableUnitIDMap;
    private CacheableMap sbbComponents;
    private CacheableMap profileComponents;
    private CacheableMap serviceComponents;
    private CacheableMap serviceResourceAdaptorEntities;
    private CacheableSet activeServiceIDs;
    private static final String DU_ID_TO_DESCRIPTOR_MAP = "deployableUnitIDtoDescriptorMap";
    private static final String URL_TO_DEPLOYABLE_UNIT_ID_MAP = "urlToDeployableUnitIDMap";
    private static final String COMPONENT_ID_TO_DEPLOYABLE_UNIT_ID_MAP = "componentIDToDeployableUnitIDMap";
    private static final String REFERRING_COMPONENTS = "referringComponents";
    private static final String SBB_COMPONENTS = "sbbComponents";
    private static final String PROFILE_COMPONENTS = "profileComponents";
    private static final String SERVICE_COMPONENTS = "serviceComponents";
    private static final String SERVICE_RESOURCE_ADAPTOR_ENTITIES = "serviceResourceAdaptorEntities";
    private static final String ACTIVE_SERVICE_IDS = "activeServiceIDs";
    private Logger logger = Logger.getLogger((String)DeploymentCacheManager.class.getName());

    public void printNode() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"DeploymentCache { ");
            this.logger.debug((Object)("deployableUnitIDToDescriptorMap = " + this.deployableUnitIDtoDescriptorMap));
            this.logger.debug((Object)("urlToDeployableUnitIDMap = " + this.urlToDeployableUnitIDMap));
            this.logger.debug((Object)("referringComponents = " + this.referringComponents));
            this.logger.debug((Object)("componentIDToDeployableUnitIDMap = " + this.componentIDToDeployableUnitIDMap));
            this.logger.debug((Object)("sbbComponents = " + this.sbbComponents));
            this.logger.debug((Object)("profileComponents = " + this.profileComponents));
            this.logger.debug((Object)("serviceComponents = " + this.serviceComponents));
            this.logger.debug((Object)("serviceResourceAdaptorEntities = " + this.serviceResourceAdaptorEntities));
            this.logger.debug((Object)("activeServiceIDs = " + this.activeServiceIDs));
            this.logger.debug((Object)"}");
        }
    }

    public DeploymentCacheManager() {
        this.serviceComponents = new CacheableMap(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + SERVICE_COMPONENTS);
        this.serviceResourceAdaptorEntities = new CacheableMap(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + SERVICE_RESOURCE_ADAPTOR_ENTITIES);
        this.referringComponents = new CacheableMap(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + REFERRING_COMPONENTS);
        this.profileComponents = new CacheableMap(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + PROFILE_COMPONENTS);
        this.componentIDToDeployableUnitIDMap = new CacheableMap(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + COMPONENT_ID_TO_DEPLOYABLE_UNIT_ID_MAP);
        this.sbbComponents = new CacheableMap(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + SBB_COMPONENTS);
        this.urlToDeployableUnitIDMap = new CacheableMap(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + URL_TO_DEPLOYABLE_UNIT_ID_MAP);
        this.deployableUnitIDtoDescriptorMap = new CacheableMap(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + DU_ID_TO_DESCRIPTOR_MAP);
        this.activeServiceIDs = new CacheableSet(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + ACTIVE_SERVICE_IDS);
    }

    public String getNodeName() {
        return "deployment";
    }

    public Map getServiceComponents() throws SystemException {
        return this.serviceComponents;
    }

    public Map getServiceResourceAdaptorEntities() throws SystemException {
        return this.serviceResourceAdaptorEntities;
    }

    public Set getActiveServiceIDs() throws SystemException {
        return this.activeServiceIDs;
    }

    Map getReferringComponents() throws SystemException {
        return this.referringComponents;
    }

    Map getProfileComponents() throws SystemException {
        return this.profileComponents;
    }

    Map getComponentIDToDeployableUnitIDMap() throws SystemException {
        return this.componentIDToDeployableUnitIDMap;
    }

    Map getUrlToDeployableUnitIDMap() throws SystemException {
        return this.urlToDeployableUnitIDMap;
    }

    Map getSbbComponents() throws SystemException {
        return this.sbbComponents;
    }

    Map getDeployableUnitIDtoDescriptorMap() throws SystemException {
        return this.deployableUnitIDtoDescriptorMap;
    }

    Set newReferringDuSet() {
        CacheableSet refs = new CacheableSet(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + COMPONENT_ID_TO_DEPLOYABLE_UNIT_ID_MAP + ":" + "newReferringDuSet" + new UID());
        return refs;
    }

    Set newReferringCompSet() {
        CacheableSet refs = new CacheableSet(TransactionManagerImpl.DEPLOYMENT_CACHE + ":" + COMPONENT_ID_TO_DEPLOYABLE_UNIT_ID_MAP + ":" + "newReferringCompSet" + new UID());
        return refs;
    }
}

