/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.security.InvalidParameterException;
import java.util.StringTokenizer;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.slee.SLEEException;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.deployment.SbbDeployer;

public class ConcreteClassGeneratorUtils {
    public static Logger logger = null;
    public static final String SBB_CONCRETE_CLASS_NAME_PREFIX = "";
    public static final String SBB_CONCRETE_CLASS_NAME_SUFFIX = "Impl";
    public static final String CONCRETE_ACTIVITY_INTERFACE_CLASS_NAME_PREFIX = "";
    public static final String CONCRETE_ACTIVITY_INTERFACE_CLASS_NAME_SUFFIX = "Impl";
    public static final String SBB_LOCAL_OBJECT_CLASS_NAME_PREFIX = "";
    public static final String SBB_LOCAL_OBJECT_CLASS_NAME_SUFFIX = "Impl";
    public static final String PROFILE_CONCRETE_CLASS_NAME_PREFIX = "";
    public static final String PROFILE_CONCRETE_CLASS_NAME_SUFFIX = "Impl";
    public static final String PROFILE_MBEAN_CONCRETE_CLASS_NAME_PREFIX = "";
    public static final String PROFILE_MBEAN_CONCRETE_CLASS_NAME_SUFFIX = "MBeanImpl";
    public static final String PROFILE_TRANSIENT_CLASS_NAME_PREFIX = "";
    public static final String PROFILE_TRANSIENT_CLASS_NAME_SUFFIX = "TransientState";
    public static final String SBB_USAGE_PARAMETERS_INTERFACE_PREFIX = "";
    public static final String SBB_USAGE_PARAMETERS_INTERFACE_SUFFIX = "Impl";
    private static ClassPool pool;
    static /* synthetic */ Class class$org$mobicents$slee$container$SleeContainerUtils;

    public static ClassPool createClassPool() {
        return new ClassPool(pool);
    }

    public static String getSbbConcreteClassName(String sbbAbstractClassName) {
        return "" + sbbAbstractClassName + "Impl";
    }

    public static void createInterfaceLinks(CtClass concreteClass, CtClass[] interfaces) {
        if (interfaces == null) {
            return;
        }
        concreteClass.setInterfaces(interfaces);
        for (int i = 0; i < interfaces.length; ++i) {
            logger.debug((Object)(concreteClass.getName() + " Implements link with " + interfaces[i].getName() + " interface created"));
        }
    }

    public static void createInheritanceLink(CtClass concreteClass, CtClass superClass) {
        if (superClass == null) {
            return;
        }
        try {
            concreteClass.setSuperclass(superClass);
            logger.debug((Object)(concreteClass.getName() + " Inheritance link with " + superClass.getName() + " class created"));
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
    }

    public static void addInterceptedMethod(CtClass concreteClass, CtMethod method, String interceptorName, boolean callSuperMethod) {
        int argNumber;
        if (method == null) {
            throw new InvalidParameterException("Intercepted method should not be null");
        }
        if (interceptorName == null) {
            throw new InvalidParameterException("Interceptor class name should not be null");
        }
        String methodToAdd = "public ";
        boolean hasReturn = false;
        CtClass returnType = null;
        try {
            returnType = method.getReturnType();
            methodToAdd = methodToAdd.concat(returnType.getName() + " ");
            hasReturn = true;
        }
        catch (NotFoundException nfe) {
            logger.debug((Object)"No return type -- assuming return type is void ");
            methodToAdd = methodToAdd + "void ";
        }
        methodToAdd = methodToAdd.concat(method.getName() + "(");
        CtClass[] parameterTypes = null;
        String parametersInit = "Object[] args=null;";
        String argsInit = "Class[] classes=null;";
        try {
            parameterTypes = method.getParameterTypes();
            parametersInit = parametersInit + "args=new Object[" + parameterTypes.length + "];";
            argsInit = argsInit + "classes=new Class[" + parameterTypes.length + "];";
            for (argNumber = 0; argNumber < parameterTypes.length; ++argNumber) {
                methodToAdd = methodToAdd.concat(parameterTypes[argNumber].getName() + " arg_" + argNumber);
                parametersInit = !parameterTypes[argNumber].isPrimitive() ? parametersInit + " args[" + argNumber + "]=arg_" + argNumber + ";" : parametersInit + " args[" + argNumber + "]=" + ClassUtils.getObjectFromPrimitiveType(parameterTypes[argNumber].getName(), "arg_" + argNumber) + ";";
                String typeClass = parameterTypes[argNumber].getName();
                if (!parameterTypes[argNumber].isPrimitive()) {
                    if (parameterTypes[argNumber].isArray()) {
                        String arrayClassRepresentation = ConcreteClassGeneratorUtils.toArray(parameterTypes[argNumber]);
                        if (arrayClassRepresentation != null) {
                            argsInit = argsInit + "classes[" + argNumber + "]=" + (class$org$mobicents$slee$container$SleeContainerUtils == null ? ConcreteClassGeneratorUtils.class$("org.mobicents.slee.container.SleeContainerUtils") : class$org$mobicents$slee$container$SleeContainerUtils).getName() + ".getCurrentThreadClassLoader().loadClass(\"" + arrayClassRepresentation + "\");";
                        }
                    } else {
                        argsInit = argsInit + "classes[" + argNumber + "]=" + (class$org$mobicents$slee$container$SleeContainerUtils == null ? ConcreteClassGeneratorUtils.class$("org.mobicents.slee.container.SleeContainerUtils") : class$org$mobicents$slee$container$SleeContainerUtils).getName() + ".getCurrentThreadClassLoader().loadClass(\"" + typeClass + "\");";
                    }
                } else {
                    argsInit = argsInit + "classes[" + argNumber + "]=" + ClassUtils.getClassFromPrimitiveType(typeClass) + ".TYPE;";
                }
                if (argNumber + 1 >= parameterTypes.length) continue;
                methodToAdd = methodToAdd + ",";
            }
            methodToAdd = methodToAdd + ") ";
            if (method.getExceptionTypes().length > 0) {
                CtClass[] exceptions = method.getExceptionTypes();
                methodToAdd = methodToAdd + " throws ";
                for (int i = 0; i < exceptions.length - 1; ++i) {
                    String exName = exceptions[i].getName();
                    methodToAdd = methodToAdd + exName + ", ";
                }
                methodToAdd = methodToAdd + exceptions[exceptions.length - 1].getName();
            }
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            throw new SLEEException("Failed creating concrete Profile MBean implementation class", (Throwable)nfe);
        }
        methodToAdd = methodToAdd + " { ";
        methodToAdd = methodToAdd + "" + parametersInit;
        methodToAdd = methodToAdd + "" + argsInit;
        methodToAdd = methodToAdd + "Class clazz=this.getClass();";
        methodToAdd = methodToAdd + "Object result=null;";
        methodToAdd = methodToAdd + "try{";
        if (callSuperMethod && method.getName().equals("profileStore")) {
            methodToAdd = methodToAdd + "super." + method.getName() + "(";
            if (parameterTypes != null && parameterTypes.length > 0) {
                for (argNumber = 0; argNumber < parameterTypes.length; ++argNumber) {
                    methodToAdd = methodToAdd + "arg_" + argNumber;
                    if (argNumber + 1 >= parameterTypes.length) continue;
                    methodToAdd = methodToAdd + ",";
                }
            }
            methodToAdd = methodToAdd + ");";
        }
        methodToAdd = methodToAdd + "java.lang.reflect.Method method=clazz.getDeclaredMethod(\"" + method.getName() + "\",classes" + ");";
        methodToAdd = methodToAdd + "result=" + interceptorName + ".invoke(this,method,args); ";
        methodToAdd = methodToAdd + "}catch(RuntimeException t){t.printStackTrace(); throw (t); " + " } catch (Exception ex1) { ex1.printStackTrace(); throw (ex1); }";
        if (callSuperMethod && !method.getName().equals("profileStore")) {
            methodToAdd = methodToAdd + "super." + method.getName() + "(";
            if (parameterTypes != null && parameterTypes.length > 0) {
                for (argNumber = 0; argNumber < parameterTypes.length; ++argNumber) {
                    methodToAdd = methodToAdd + "arg_" + argNumber;
                    if (argNumber + 1 >= parameterTypes.length) continue;
                    methodToAdd = methodToAdd + ",";
                }
            }
            methodToAdd = methodToAdd + ");";
        }
        if (hasReturn && !returnType.getName().equalsIgnoreCase("void")) {
            methodToAdd = !returnType.isPrimitive() ? methodToAdd + "return (" + returnType.getName() + ")result;" : methodToAdd + "return " + ClassUtils.getPrimitiveTypeFromObject(returnType.getName(), "result") + ";";
        }
        methodToAdd = methodToAdd + "}";
        logger.debug((Object)("Method " + methodToAdd + " added"));
        try {
            CtMethod methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)concreteClass);
            concreteClass.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            throw new SLEEException("Cannot compile method " + method.getName(), (Throwable)cce);
        }
    }

    public static String toArray(CtClass typeClass) {
        StringTokenizer st = new StringTokenizer(typeClass.getName(), "[");
        String name = null;
        try {
            CtClass arrayClass = typeClass.getComponentType();
            name = !arrayClass.isPrimitive() ? "L" + arrayClass.getName().replace('/', '.') + ";" : ConcreteClassGeneratorUtils.toJvmRepresentation(arrayClass.getName());
            st.nextToken();
            while (st.hasMoreTokens()) {
                st.nextToken();
                name = "[" + name;
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String toJvmRepresentation(String primitiveTypeName) {
        if (primitiveTypeName.equals("int")) {
            return "I";
        }
        if (primitiveTypeName.equals("boolean")) {
            return "Z";
        }
        if (primitiveTypeName.equals("byte")) {
            return "B";
        }
        if (primitiveTypeName.equals("char")) {
            return "C";
        }
        if (primitiveTypeName.equals("double")) {
            return "D";
        }
        if (primitiveTypeName.equals("float")) {
            return "F";
        }
        if (primitiveTypeName.equals("long")) {
            return "J";
        }
        if (primitiveTypeName.equals("short")) {
            return "S";
        }
        if (primitiveTypeName.equals("void")) {
            return "V";
        }
        return primitiveTypeName;
    }

    public static void copyMethods(CtClass source, CtClass destination, CtClass[] exceptions) {
        CtMethod[] methods = source.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            CtMethod method = null;
            try {
                method = new CtMethod(methods[i], destination, null);
                if (exceptions != null) {
                    try {
                        method.setExceptionTypes(exceptions);
                    }
                    catch (NotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
                destination.addMethod(method);
                continue;
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    static {
        logger = Logger.getLogger((Class)ConcreteClassGeneratorUtils.class);
        pool = new ClassPool(ClassPool.getDefault());
        try {
            pool.appendClassPath(SbbDeployer.getLibPath());
            pool.insertClassPath(SbbDeployer.getLibPath() + "slee_1_1.jar");
            pool.insertClassPath(SbbDeployer.getLibPath() + "jboss-jmx.jar");
            pool.insertClassPath(SbbDeployer.getLibPath() + "sleetck-minimal.jar");
            pool.insertClassPath(SbbDeployer.getLibPath() + "tcktools.jar");
            pool.insertClassPath(SbbDeployer.getLibPath() + "sleetck-ra-common.jar");
            pool.insertClassPath(SbbDeployer.getLibPath() + "slee-tasks.jar");
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed initializing javassist", e);
        }
    }
}

