/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.io.File;
import java.util.HashSet;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.ManagementException;
import javax.slee.usage.SampleStatistics;
import javax.slee.usage.SbbUsageMBean;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;
import org.mobicents.slee.container.deployment.SbbDeployer;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.InstalledUsageParameterSet;
import org.mobicents.slee.container.management.SbbDescriptorImpl;
import org.mobicents.slee.container.management.jmx.SbbUsageMBeanImpl;

public class ConcreteUsageParameterMBeanInterfaceGenerator {
    private static Logger logger = Logger.getLogger((Class)ConcreteUsageParameterMBeanInterfaceGenerator.class);
    private ClassPool classPool;
    private HashSet generatedFields;
    private String usageParameterFieldName;
    private String mbeanInterfaceName;
    private SbbDescriptorImpl sbbDescriptor;

    public ConcreteUsageParameterMBeanInterfaceGenerator(SbbDescriptorImpl sbbDescriptor) {
        this.classPool = ((DeployableUnitIDImpl)sbbDescriptor.getDeployableUnit()).getDUDeployer().getClassPool();
        this.sbbDescriptor = sbbDescriptor;
        try {
            this.classPool.appendClassPath(SbbDeployer.getLibPath() + File.separatorChar + "jboss-jmx.jar");
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Could not find library!", e);
        }
    }

    private void createConstructor(CtClass concreteClass, CtClass[] parameters) throws Exception {
        CtConstructor ctCons = new CtConstructor(parameters, concreteClass);
        String constructorBody = "{";
        constructorBody = constructorBody + "super($1, $2, $3, $4);";
        for (int i = 0; i < parameters.length; ++i) {
            String parameterName = ConcreteUsageParameterMBeanInterfaceGenerator.paramNameFromClassName(parameters[i]);
            if (i == 4) {
                this.usageParameterFieldName = parameterName;
            }
            if (i == 3) continue;
            try {
                CtField ctField = new CtField(parameters[i], parameterName, concreteClass);
                ctField.setModifiers(2);
                concreteClass.addField(ctField);
            }
            catch (CannotCompileException cce) {
                cce.printStackTrace();
            }
            int paramNumber = i + 1;
            constructorBody = constructorBody + parameterName + "=$" + paramNumber + ";";
        }
        constructorBody = constructorBody + "}";
        ctCons.setBody(constructorBody);
        concreteClass.addConstructor(ctCons);
    }

    private static String paramNameFromClassName(CtClass parameter) {
        String parameterName = parameter.getName();
        if ((parameterName = parameterName.substring(parameterName.lastIndexOf(".") + 1)).indexOf(91) != -1) {
            parameterName = parameterName.substring(0, parameterName.indexOf(91));
        }
        String firstCharLowerCase = parameterName.substring(0, 1).toLowerCase();
        parameterName = firstCharLowerCase.concat(parameterName.substring(1));
        return parameterName;
    }

    public Class generateConcreteUsageParameterMBeanInterface() throws Exception {
        String usageParamInterfaceName = this.sbbDescriptor.getUsageParametersInterface();
        if (usageParamInterfaceName == null) {
            return null;
        }
        ClassPath classPath = this.classPool.appendClassPath(this.sbbDescriptor.getDeploymentPath());
        String concreteMBeanInterfaceName = usageParamInterfaceName + "MBean";
        String concreteMBeanClassName = usageParamInterfaceName + "MBeanImpl";
        CtClass usageParamInterface = this.classPool.get(usageParamInterfaceName);
        CtClass usageMBeanInterface = this.classPool.get(SbbUsageMBean.class.getName());
        CtClass usageParamConcreteClass = this.classPool.get(usageParamInterfaceName + "Impl");
        CtClass[] parameter = new CtClass[]{this.classPool.get(ServiceID.class.getName()), this.classPool.get(SbbID.class.getName()), this.classPool.get(String.class.getName()), this.classPool.get(String.class.getName()), this.classPool.get(this.sbbDescriptor.getUsageParameterClass().getName())};
        CtClass ctInterface = null;
        try {
            ctInterface = this.classPool.get(concreteMBeanInterfaceName).getClassPool().makeInterface(concreteMBeanInterfaceName);
        }
        catch (NotFoundException nfe) {
            ctInterface = this.classPool.makeInterface(concreteMBeanInterfaceName);
        }
        ctInterface.addInterface(usageMBeanInterface);
        CtClass ctClass = null;
        try {
            ctClass = this.classPool.get(concreteMBeanClassName).getClassPool().makeClass(concreteMBeanClassName);
        }
        catch (NotFoundException nfe) {
            ctClass = this.classPool.makeClass(concreteMBeanClassName);
        }
        ConcreteClassGeneratorUtils.createInheritanceLink(ctClass, this.classPool.get(SbbUsageMBeanImpl.class.getName()));
        ConcreteClassGeneratorUtils.createInterfaceLinks(ctClass, new CtClass[]{ctInterface});
        this.createConstructor(ctClass, parameter);
        CtClass implClassInterface = this.classPool.get(InstalledUsageParameterSet.class.getName());
        CtMethod[] methods = usageParamInterface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.generateAbstractMethod(ctInterface, methods[i]);
            this.generateConcreteMethod(ctClass, methods[i]);
        }
        String sbbDeploymentPathStr = this.sbbDescriptor.getDeploymentPath();
        this.classPool.get(concreteMBeanInterfaceName).writeFile(sbbDeploymentPathStr);
        this.classPool.get(concreteMBeanInterfaceName).detach();
        logger.debug((Object)("Writing file " + concreteMBeanInterfaceName));
        this.classPool.get(concreteMBeanClassName).writeFile(sbbDeploymentPathStr);
        this.classPool.get(concreteMBeanClassName).detach();
        logger.debug((Object)("Writing file " + concreteMBeanClassName));
        Class<?> retval = Thread.currentThread().getContextClassLoader().loadClass(concreteMBeanInterfaceName);
        ctInterface.defrost();
        ctClass.defrost();
        this.classPool.removeClassPath(classPath);
        return retval;
    }

    private void generateConcreteMethod(CtClass ctClass, CtMethod method) throws Exception {
        String methodName = method.getName();
        String body = "";
        if (methodName.startsWith("increment")) {
            body = body + "public long get" + methodName.substring("increment".length()) + "( boolean  reset ) throws " + ManagementException.class.getName() + " {" + "return this." + this.usageParameterFieldName + ".get" + methodName.substring("increment".length()) + "(reset);" + "}";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("METHOD BODY " + body));
            }
            CtMethod newmethod = CtNewMethod.make((String)body, (CtClass)ctClass);
            ctClass.addMethod(newmethod);
        } else if (methodName.startsWith("sample")) {
            body = body + "public " + SampleStatistics.class.getName() + " get" + methodName.substring("sample".length()) + "( boolean  reset ) throws " + ManagementException.class.getName() + " {" + "return this." + this.usageParameterFieldName + ".get" + methodName.substring("sample".length()) + "(reset);" + "}";
            logger.debug((Object)("METHOD BODY " + body));
            CtMethod newmethod = CtNewMethod.make((String)body, (CtClass)ctClass);
            ctClass.addMethod(newmethod);
        } else {
            return;
        }
    }

    private void generateAbstractMethod(CtClass ctClass, CtMethod method) throws Exception {
        String methodName = method.getName();
        String body = "";
        CtClass managementExceptionClass = this.classPool.get(ManagementException.class.getName());
        CtClass sampleStatisticsClass = this.classPool.get(SampleStatistics.class.getName());
        CtMethod newMethod = null;
        if (methodName.startsWith("increment")) {
            CtClass[] parameters = new CtClass[]{CtClass.booleanType};
            CtClass[] exceptions = new CtClass[]{managementExceptionClass};
            newMethod = CtNewMethod.abstractMethod((CtClass)CtClass.longType, (String)("get" + methodName.substring("increment".length())), (CtClass[])parameters, (CtClass[])exceptions, (CtClass)ctClass);
        } else if (methodName.startsWith("sample")) {
            CtClass[] parameters = new CtClass[]{CtClass.booleanType};
            CtClass[] exceptions = new CtClass[]{managementExceptionClass};
            newMethod = CtNewMethod.abstractMethod((CtClass)sampleStatisticsClass, (String)("get" + methodName.substring("sample".length())), (CtClass[])parameters, (CtClass[])exceptions, (CtClass)ctClass);
            body = body + "public " + SampleStatistics.class.getName() + " " + methodName.substring("sample".length()) + "( boolean  reset ) throws " + ManagementException.class + ";";
        } else {
            return;
        }
        ctClass.addMethod(newMethod);
    }
}

