/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javax.slee.SLEEException;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.SbbDescriptorImpl;

public class SbbAbstractDecorator {
    private SbbDescriptorImpl sbbDeploymentDescriptor = null;
    private CtClass sbbAbstractClass = null;
    private static Logger logger = null;
    private Map concreteMethods = null;
    private ClassPool pool = null;
    private String deployPath;
    private boolean isAbstractSbbClassDecorated = false;
    static /* synthetic */ Class class$javax$naming$Context;

    public SbbAbstractDecorator(SbbDescriptorImpl sbbDeploymentDescriptor) {
        this.sbbDeploymentDescriptor = sbbDeploymentDescriptor;
        this.deployPath = ((DeployableUnitIDImpl)sbbDeploymentDescriptor.getDeployableUnit()).getDUDeployer().getTempClassDeploymentDir().getAbsolutePath();
        this.pool = ((DeployableUnitIDImpl)sbbDeploymentDescriptor.getDeployableUnit()).getDUDeployer().getClassPool();
    }

    public void decorateAbstractSbb() throws DeploymentException {
        String sbbAbstractClassName = this.sbbDeploymentDescriptor.getSbbAbstractClassName();
        try {
            this.sbbAbstractClass = this.pool.get(sbbAbstractClassName);
        }
        catch (NotFoundException nfe) {
            throw new DeploymentException("Could not find Abstract Sbb Class: " + sbbAbstractClassName, (Throwable)nfe);
        }
        this.concreteMethods = ClassUtils.getConcreteMethodsFromClass(this.sbbAbstractClass);
        this.decorateENCBindCalls();
        this.decorateNewThreadCalls();
        if (this.isAbstractSbbClassDecorated) {
            this.writeDecoratedAbstractClassToDisc();
        }
        Class<?> clazz = null;
        try {
            clazz = this.sbbDeploymentDescriptor.getClassLoader().loadClass(sbbAbstractClassName);
        }
        catch (ClassNotFoundException e1) {
            String s = "What the heck?! Could not find decorated abstract sbb class. Is it under the chair?";
            logger.fatal((Object)s, (Throwable)e1);
            throw new RuntimeException(s, e1);
        }
    }

    private void writeDecoratedAbstractClassToDisc() throws DeploymentException {
        try {
            this.sbbAbstractClass.writeFile(this.deployPath);
            this.sbbAbstractClass.detach();
            this.isAbstractSbbClassDecorated = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Modified Abstract Class " + this.sbbAbstractClass.getName() + " generated in the following path " + this.deployPath));
            }
        }
        catch (CannotCompileException e) {
            String s = "Error Compiling  modified abstract sbb class";
            logger.fatal((Object)s, (Throwable)e);
            throw new RuntimeException(s, e);
        }
        catch (IOException e) {
            String s = "Error writing modified abstract sbb class";
            logger.fatal((Object)s, (Throwable)e);
            throw new RuntimeException(s, e);
        }
        finally {
            this.sbbAbstractClass.defrost();
        }
    }

    private void decorateNewThreadCalls() {
    }

    private void decorateENCBindCalls() {
        Iterator iter = this.concreteMethods.values().iterator();
        while (iter.hasNext()) {
            CtMethod method = (CtMethod)iter.next();
            try {
                this.trapMethodIfENCBindCall(method);
            }
            catch (CannotCompileException e) {
                throw new SLEEException("Could not decorate ENC bind calls for sbb abstract class: " + this.sbbAbstractClass, (Throwable)e);
            }
        }
    }

    private void trapMethodIfENCBindCall(CtMethod method) throws CannotCompileException {
        method.instrument(new ExprEditor(){

            public void edit(MethodCall m) throws CannotCompileException {
                boolean isJndiCtx;
                block6: {
                    isJndiCtx = false;
                    try {
                        if (m.getClassName().equals((class$javax$naming$Context == null ? (class$javax$naming$Context = SbbAbstractDecorator.class$("javax.naming.Context")) : class$javax$naming$Context).getName())) {
                            isJndiCtx = true;
                            break block6;
                        }
                        CtClass cl0 = SbbAbstractDecorator.this.pool.get(m.getClassName());
                        CtClass[] cl0Interfaces = cl0.getInterfaces();
                        for (int i = 0; i < cl0Interfaces.length; ++i) {
                            CtClass cl0If = cl0Interfaces[i];
                            if (!cl0If.getName().equals((class$javax$naming$Context == null ? SbbAbstractDecorator.class$("javax.naming.Context") : class$javax$naming$Context).getName())) continue;
                            isJndiCtx = true;
                            break;
                        }
                    }
                    catch (NotFoundException e) {
                        return;
                    }
                }
                if (!isJndiCtx) {
                    return;
                }
                if (m.getMethodName().endsWith("bind") || m.getMethodName().equals("createSubcontext")) {
                    m.replace("{ String fullJndiName = $0.composeName($1, $0.getNameInNamespace());System.err.println(\"TRAPPED SBB METHOD - JNDI BIND CALL; fullJndiName: \" + fullJndiName);if (fullJndiName.startsWith(\"java:comp/env\") || fullJndiName.startsWith(\"env\")) {\t   throw new javax.naming.OperationNotSupportedException(\"SBB is not allowed write access to java:comp/env. See SLEE 1.0 spec for details. \");\t} else {$_ = $proceed($$);}; }");
                    SbbAbstractDecorator.this.isAbstractSbbClassDecorated = true;
                }
            }
        });
    }

    static {
        logger = Logger.getLogger((Class)SbbAbstractDecorator.class);
    }
}

