/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.io.File;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.deployment.ConcreteSbbGenerator;
import org.mobicents.slee.container.deployment.ConcreteUsageParameterClassGenerator;
import org.mobicents.slee.container.deployment.SbbAbstractDecorator;
import org.mobicents.slee.container.deployment.SbbVerifier;
import org.mobicents.slee.container.management.SbbDescriptorImpl;

public class SbbDeployer {
    private static Logger logger = Logger.getLogger((Class)SbbDeployer.class);
    private SleeContainer serviceContainer;
    private ConcreteSbbGenerator concreteSbbGenerator = null;
    private SbbVerifier sbbVerifier = null;
    private String deployPath;
    private static String libPath = null;

    private SbbDeployer() {
    }

    public SbbDeployer(String rootPath) {
        logger.info((Object)("sbbDeployer:" + rootPath));
        File file = new File(rootPath);
        this.deployPath = file.getPath();
    }

    public boolean deploySbb(SbbDescriptorImpl sbbDeploymentDescriptor, SleeContainer serviceContainer) throws DeploymentException {
        String sbbAbstractClassName = sbbDeploymentDescriptor.getSbbAbstractClassName();
        this.sbbVerifier = new SbbVerifier(sbbDeploymentDescriptor);
        boolean classVerifiedSuccessfully = this.sbbVerifier.verifySbbAbstractClass(sbbAbstractClassName, serviceContainer);
        SbbDescriptorImpl descriptorImpl = sbbDeploymentDescriptor;
        logger.debug((Object)("usageParametersInterface = " + descriptorImpl.getUsageParametersInterface()));
        boolean usageParameterVerified = descriptorImpl.getUsageParametersInterface() == null || ConcreteUsageParameterClassGenerator.checkUsageParameterInterface(descriptorImpl);
        logger.debug((Object)("classVerifiedSuccessfully ? =>" + classVerifiedSuccessfully));
        logger.debug((Object)("usageParameterVerified ? =>" + usageParameterVerified));
        if (classVerifiedSuccessfully && usageParameterVerified) {
            if (descriptorImpl.getUsageParametersInterface() != null) {
                try {
                    Class usageParamClazz = new ConcreteUsageParameterClassGenerator(sbbDeploymentDescriptor).generateConcreteUsageParameterClass(descriptorImpl);
                    descriptorImpl.setUsageParameterClass(usageParamClazz);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            SbbAbstractDecorator abstractSbbDecorator = new SbbAbstractDecorator(sbbDeploymentDescriptor);
            abstractSbbDecorator.decorateAbstractSbb();
            this.concreteSbbGenerator = new ConcreteSbbGenerator(sbbDeploymentDescriptor);
            Class clazz = this.concreteSbbGenerator.generateConcreteSbb();
            if (clazz != null) {
                logger.debug((Object)"Generated all classes!");
                return true;
            }
            throw new DeploymentException(" Could not deploy Sbb " + sbbDeploymentDescriptor.getName());
        }
        throw new DeploymentException("Verification error in SBB " + sbbDeploymentDescriptor.getName());
    }

    public static String getLibPath() {
        return libPath;
    }

    static {
        libPath = SleeContainer.getDeployPath() + File.separator;
    }
}

