/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.Sbb;
import javax.slee.management.SbbDescriptor;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.management.CMPField;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.EventTypeDescriptorImpl;
import org.mobicents.slee.container.management.EventTypeIDImpl;
import org.mobicents.slee.container.management.GetChildRelationMethod;
import org.mobicents.slee.container.management.ProfileCMPMethod;
import org.mobicents.slee.container.management.SbbDescriptorImpl;
import org.mobicents.slee.container.management.SbbEventEntry;

public class SbbVerifier {
    private static String DEPLOYMENT_PATH = SleeContainer.getDeployPath();
    private SbbDescriptorImpl sbbDeploymentDescriptor = null;
    private static String deployPath = null;
    private ClassPool pool = null;
    private static Logger logger = null;
    private String errorString;
    private static boolean firstTime = true;
    private CtClass sbbAbstractClass;
    static /* synthetic */ Class class$javax$slee$InitialEventSelector;
    static /* synthetic */ Class class$java$lang$Object;

    public SbbVerifier(SbbDescriptor sbbDescriptor) {
        this.sbbDeploymentDescriptor = (SbbDescriptorImpl)sbbDescriptor;
        this.pool = ((DeployableUnitIDImpl)sbbDescriptor.getDeployableUnit()).getDUDeployer().getClassPool();
        try {
            this.sbbAbstractClass = this.pool.get(Sbb.class.getName());
        }
        catch (NotFoundException e) {
            String s = "Cannot find class ! while verifying ";
            logger.fatal((Object)e);
            throw new RuntimeException(s, e);
        }
    }

    public boolean verifySbbAbstractClass(String sbbAbstractClassName, SleeContainer serviceContainer) {
        try {
            logger.info((Object)("Verifying " + sbbAbstractClassName));
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String classRsrcName = sbbAbstractClassName.replace('.', '/') + ".class";
            InputStream sbbAbstractClassIS = cl.getResourceAsStream(classRsrcName);
            if (sbbAbstractClassIS == null) {
                logger.error((Object)("Cannot open input stream for " + classRsrcName));
                return false;
            }
            CtClass ctClass = null;
            try {
                ctClass = this.pool.get(sbbAbstractClassName).getClassPool().makeClass(sbbAbstractClassIS);
            }
            catch (NotFoundException e) {
                ctClass = this.pool.makeClass(sbbAbstractClassIS);
            }
            if (!this.checkSbbAbstractClassConstraints(ctClass)) {
                logger.error((Object)"SbbAbstractClass Constraints were not successfully verified");
                return false;
            }
            if (!this.checkSbbAgainstDeploymentDescriptor(ctClass, serviceContainer)) {
                logger.error((Object)"Sbb and deployment descriptor are not matching");
                return false;
            }
            if (!this.checkEventHandlerMethods(ctClass, serviceContainer)) {
                logger.error((Object)"EventHandler Methods were not successfully verified");
                return false;
            }
        }
        catch (IOException ioe) {
            logger.info((Object)("Sbb Abstract Class validation failed for: " + sbbAbstractClassName), (Throwable)ioe);
            return false;
        }
        logger.info((Object)(sbbAbstractClassName + " is safe"));
        return true;
    }

    public boolean verifySbbConcreteClass(String sbbConcreteClassName) {
        return false;
    }

    protected boolean checkSbbAbstractClassConstraints(CtClass sbbAbstractClass) {
        int modifiers = sbbAbstractClass.getModifiers();
        if (!Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers)) {
            logger.error((Object)"The class is nor abstract neither public");
            return false;
        }
        CtMethod[] methods = sbbAbstractClass.getDeclaredMethods();
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                CtMethod ctMethod;
                int k;
                CtMethod method = methods[i];
                if (method.getName().equalsIgnoreCase("finalize")) {
                    logger.error((Object)("finalize method is present in the sbb abstract class " + sbbAbstractClass.getName()));
                    return false;
                }
                if (methods[i].getName().startsWith("ejb")) {
                    logger.error((Object)("invalid method name detected " + methods[i].getName()));
                    return false;
                }
                if (!methods[i].getName().startsWith("sbb")) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("checking method " + methods[i].getName()));
                }
                CtMethod[] abstractClassMethods = this.sbbAbstractClass.getDeclaredMethods();
                for (k = 0; k < abstractClassMethods.length && !(ctMethod = abstractClassMethods[k]).getName().equals(methods[i].getName()); ++k) {
                }
                if (k != abstractClassMethods.length) continue;
                logger.error((Object)("invalid method name determined " + methods[i].getName()));
                return false;
            }
        } else {
            logger.error((Object)("there is no abstract methods inthis abstract Class : " + sbbAbstractClass.getName()));
            return false;
        }
        try {
            boolean implementSbbLinkFound = false;
            implementSbbLinkFound = this.checkInterfaces(sbbAbstractClass.getInterfaces(), "javax.slee.Sbb");
            CtClass superClass = sbbAbstractClass.getSuperclass();
            while (superClass != null && !implementSbbLinkFound) {
                if (superClass.getName().equalsIgnoreCase("javax.slee.Sbb")) {
                    implementSbbLinkFound = true;
                    continue;
                }
                implementSbbLinkFound = this.checkInterfaces(superClass.getInterfaces(), "javax.slee.Sbb");
                superClass = superClass.getSuperclass();
            }
            if (!implementSbbLinkFound) {
                logger.error((Object)("sbb abstract class " + sbbAbstractClass.getName() + " doesn't implements the javax.slee.Sbb class either directly or by inheritance"));
                return false;
            }
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return false;
        }
        CtField[] ctFields = sbbAbstractClass.getFields();
        for (int i = 0; i < ctFields.length; ++i) {
            if (!Modifier.isPublic((int)ctFields[i].getModifiers()) || !ctFields[i].getName().startsWith("sbb") && !ctFields[i].getName().startsWith("ejb")) continue;
            logger.error((Object)("the sbb abstract class " + sbbAbstractClass.getName() + " has a field starting with sbb or ejb[" + !Modifier.isPrivate((int)ctFields[i].getModifiers()) + "]: " + ctFields[i].getName()));
            return false;
        }
        return true;
    }

    private boolean checkInterfaces(CtClass[] interfaces, String interfaceSearched) {
        if (interfaces == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"no interfaces");
            }
            return false;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equalsIgnoreCase(interfaceSearched)) continue;
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"interfaces are zero length");
        }
        return false;
    }

    protected boolean checkSbbAgainstDeploymentDescriptor(CtClass sbbAbstractClass, SleeContainer serviceContainer) {
        CtClass[] params;
        CtMethod getDefaultSbbUsageParameterSetMethod;
        GetChildRelationMethod[] getChildRelationMethods;
        CtClass localSbbAbstractClass;
        int c;
        StringBuffer sb;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"checkSbbAgainstDeploymentDescriptor started");
        }
        Map abstractMethods = ClassUtils.getAbstractMethodsFromClass(sbbAbstractClass);
        Map superClassesAbstractMethods = ClassUtils.getSuperClassesAbstractMethodsFromClass(sbbAbstractClass);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"checkSbbAgainstDeploymentDescriptor abstract methods retrieved");
        }
        CMPField[] cmpFields = this.sbbDeploymentDescriptor.getCMPFields();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"checkSbbAgainstDeploymentDescriptor CMP Fields retrieved ");
        }
        CMPField[] tmpBackUpFields = new CMPField[cmpFields.length];
        for (int c2 = 0; c2 < cmpFields.length; ++c2) {
            tmpBackUpFields[c2] = cmpFields[c2];
        }
        cmpFields = tmpBackUpFields;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"checkSbbAgainstDeploymentDescriptor CMP Fields retrieved ");
            Iterator it = abstractMethods.keySet().iterator();
            sb = new StringBuffer(300);
            while (it.hasNext()) {
                sb.append("[ " + it.next() + " ]");
            }
            logger.debug((Object)("\n=============== ABSTRACT METHODS FOR: " + sbbAbstractClass.getName() + " ================\n" + sb + "\n============================================="));
            sb = new StringBuffer(300);
            for (c = 0; c < cmpFields.length; ++c) {
                if (cmpFields[c] != null) {
                    sb.append("[ " + cmpFields[c].getFieldName() + " ]");
                    continue;
                }
                sb.append("[ " + cmpFields[c] + " ]");
            }
            logger.debug((Object)("\n=============== CMPFIELDS FOR: " + sbbAbstractClass.getName() + " ================\n" + sb + "\n============================================="));
        }
        if (cmpFields != null && !this.checkCMPFieldsAgainstDeploymentDescripor(abstractMethods, cmpFields, localSbbAbstractClass = sbbAbstractClass) && !this.checkCMPFieldsAgainstDeploymentDescripor(superClassesAbstractMethods, cmpFields, localSbbAbstractClass)) {
            sb = new StringBuffer(300);
            for (c = 0; c < cmpFields.length; ++c) {
                if (cmpFields[c] != null) {
                    sb.append("[ " + cmpFields[c].getFieldName() + " ]");
                    continue;
                }
                sb.append("[ " + cmpFields[c] + " ]");
            }
            this.errorString = " CMP FIELDS(null if verified):\n" + sb;
            logger.error((Object)this.errorString);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"checkSbbAgainstDeploymentDescriptor CMP Fields ok");
        }
        if ((getChildRelationMethods = this.sbbDeploymentDescriptor.getChildRelationMethods()) != null) {
            for (int i = 0; i < getChildRelationMethods.length; ++i) {
                String methodName = getChildRelationMethods[i].getMethodName();
                CtMethod getChildRelationMethod = (CtMethod)abstractMethods.get(methodName);
                if (getChildRelationMethod == null && (getChildRelationMethod = (CtMethod)superClassesAbstractMethods.get(methodName)) == null) {
                    logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " GetChildRelationMethod " + methodName + " defined in the descriptor is missing"));
                    return false;
                }
                abstractMethods.remove(methodName);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get child relation methods ok");
        }
        if (!this.checkProfileCMPMethods(sbbAbstractClass, abstractMethods, superClassesAbstractMethods)) {
            return false;
        }
        Class activityContextInterface = this.sbbDeploymentDescriptor.getActivityContextInterface();
        if (activityContextInterface != null) {
            CtMethod narrowMethod;
            String activityContextInterfaceName = activityContextInterface.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)activityContextInterface.getName());
            }
            if ((narrowMethod = (CtMethod)abstractMethods.get("asSbbActivityContextInterface")) == null && (narrowMethod = (CtMethod)superClassesAbstractMethods.get("asSbbActivityContextInterface")) == null) {
                logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " narrow method asSbbActivityContextInterface with the return type" + activityContextInterfaceName + " defined in the descriptor is missing"));
                return false;
            }
            try {
                if (!narrowMethod.getReturnType().getName().equals(activityContextInterfaceName)) {
                    logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " narrow method asSbbActivityContextInterface with the return type" + activityContextInterfaceName + " has in the abstract method a return type different " + narrowMethod.getReturnType().getName()));
                    return false;
                }
            }
            catch (NotFoundException e) {
                logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " narrow method asSbbActivityContextInterface with the return type" + activityContextInterfaceName + " has a no return type"));
            }
            abstractMethods.remove("asSbbActivityContextInterface");
        }
        logger.debug((Object)"asSbbActivityContextInterface ok");
        HashSet sbbEventEntries = this.sbbDeploymentDescriptor.getSbbEventEntries();
        if (sbbEventEntries != null) {
            Iterator it = sbbEventEntries.iterator();
            while (it.hasNext()) {
                SbbEventEntry sbbEventEntry = (SbbEventEntry)it.next();
                if (!sbbEventEntry.isFired()) continue;
                String eventName = sbbEventEntry.getEventName();
                ComponentKey cKey = sbbEventEntry.getEventTypeRefKey();
                EventTypeIDImpl eventTypeID = serviceContainer.getEventType(cKey);
                if (eventTypeID == null) {
                    logger.error((Object)("event type id: " + eventName + " is unknown to the SLEE"));
                    return false;
                }
                String methodName = "fire" + sbbEventEntry.getEventName();
                CtMethod fireEventMethod = (CtMethod)abstractMethods.get(methodName);
                if (fireEventMethod == null) {
                    fireEventMethod = (CtMethod)superClassesAbstractMethods.get(methodName);
                }
                if (fireEventMethod != null) {
                    abstractMethods.put(methodName, fireEventMethod);
                    EventTypeDescriptorImpl eventTypeDescriptor = serviceContainer.getEventDescriptor(eventTypeID);
                    String eventClassName = eventTypeDescriptor.getEventClassName();
                    CtClass[] params2 = null;
                    CtClass retType = null;
                    try {
                        params2 = fireEventMethod.getParameterTypes();
                        retType = fireEventMethod.getReturnType();
                    }
                    catch (NotFoundException e) {
                        e.printStackTrace();
                    }
                    if (params2 == null || params2.length == 0) {
                        logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on fire event method: " + fireEventMethod + " => no params"));
                        return false;
                    }
                    if (params2.length != 3) {
                        this.errorString = "bad method signature ( wrong number of params!)";
                        logger.error((Object)this.errorString);
                        return false;
                    }
                    if (retType != CtClass.voidType) {
                        this.errorString = "fired methods must have void return type";
                        logger.error((Object)this.errorString);
                        return false;
                    }
                    if (!Modifier.isPublic((int)fireEventMethod.getModifiers())) {
                        this.errorString = "Fire event method: " + fireEventMethod.getName() + " for " + sbbEventEntry.getEventTypeRefKey() + " MUST BE PUBLIC";
                        logger.error((Object)this.errorString);
                        return false;
                    }
                    if (!Modifier.isAbstract((int)fireEventMethod.getModifiers())) {
                        this.errorString = "Fire event method: " + fireEventMethod.getName() + " for " + sbbEventEntry.getEventTypeRefKey() + " MUST BE ABSTRACT";
                        logger.error((Object)this.errorString);
                        return false;
                    }
                    CtClass param = params2[0];
                    if (!param.getName().equals(eventClassName)) {
                        this.errorString = "bad fire method signature expected parameter[0] " + eventClassName;
                        logger.error((Object)this.errorString);
                        return false;
                    }
                    param = params2[1];
                    String customACIName = this.sbbDeploymentDescriptor.getActivityContextInterfaceClassName();
                    if (customACIName != null) {
                        if (!customACIName.equals(param.getName()) && !param.getName().equals((class$javax$slee$ActivityContextInterface == null ? SbbVerifier.class$("javax.slee.ActivityContextInterface") : class$javax$slee$ActivityContextInterface).getName())) {
                            this.errorString = "bad fire method signature expected parameter[1] " + customACIName + " or " + ActivityContextInterface.class.getName();
                            logger.error((Object)this.errorString);
                            return false;
                        }
                    } else if (!param.getName().equals((class$javax$slee$ActivityContextInterface == null ? SbbVerifier.class$("javax.slee.ActivityContextInterface") : class$javax$slee$ActivityContextInterface).getName())) {
                        this.errorString = "bad fire method signature expected parameter[1] " + ActivityContextInterface.class.getName();
                        logger.error((Object)this.errorString);
                        return false;
                    }
                    if (!(param = params2[2]).getName().equals((class$javax$slee$Address == null ? SbbVerifier.class$("javax.slee.Address") : class$javax$slee$Address).getName())) {
                        this.errorString = "bad fire method signature expected parameter[2] " + Address.class.getName();
                        logger.error((Object)this.errorString);
                        return false;
                    }
                } else {
                    logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " fireEventMethod " + methodName + " defined in the descriptor is missing"));
                    return false;
                }
                abstractMethods.remove(methodName);
                abstractMethods.remove(methodName);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"sbbEventEntries ok");
        }
        if ((getDefaultSbbUsageParameterSetMethod = (CtMethod)abstractMethods.get("getDefaultSbbUsageParameterSet")) != null) {
            String usageParameterInterfaceName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getDefaultUsageParameterSet abstract method found in the SBB.");
            }
            if ((usageParameterInterfaceName = this.sbbDeploymentDescriptor.getUsageParametersInterface()) == null) {
                logger.error((Object)"No Usage parameter found in the descriptor corresponding to the getDefaultSbbUsageParameterSet defined in the SBB!");
                return false;
            }
            try {
                String returnType = getDefaultSbbUsageParameterSetMethod.getReturnType().getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RETURN TYPE: " + returnType + " INTERFACE NAME: " + usageParameterInterfaceName));
                }
                if (returnType.compareTo(usageParameterInterfaceName) != 0) {
                    logger.error((Object)"The return type of getDefaultSbbUsageParameterSet defined in the SBB does not match the interface name in the descriptor!");
                    return false;
                }
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            params = null;
            try {
                params = getDefaultSbbUsageParameterSetMethod.getParameterTypes();
            }
            catch (NotFoundException ex) {
                // empty catch block
            }
            if (params != null && params.length != 0) {
                logger.error((Object)("Unexpected parameter found" + params[0].getName()));
                return false;
            }
            abstractMethods.remove("getDefaultSbbUsageParameterSet");
        }
        logger.debug((Object)"getDefaultSbbUsageParameterSet ok");
        CtMethod getSbbUsageParameterSet = (CtMethod)abstractMethods.get("getSbbUsageParameterSet");
        if (getSbbUsageParameterSet != null) {
            params = null;
            try {
                params = getSbbUsageParameterSet.getParameterTypes();
                if (params.length != 1) {
                    logger.error((Object)"too many args!");
                    return false;
                }
                if (!params[0].getName().equals(String.class.getName())) {
                    logger.error((Object)"Arg type must be String!");
                    return false;
                }
            }
            catch (NotFoundException ex) {
                logger.error((Object)"Expected parameter not found");
                return false;
            }
            abstractMethods.remove("getSbbUsageParameterSet");
        }
        logger.debug((Object)"getSbbUsageParameterSet ok");
        if (abstractMethods.size() > 0) {
            logger.error((Object)"Some methods have not been verified against the sbb descriptor, maybe these methods have not been described in the descriptor and so are not allowed. \n The following method(s) were not matched against the descriptor:");
            Set abstracts = abstractMethods.keySet();
            if (logger.isDebugEnabled()) {
                StringBuffer sb2 = new StringBuffer(300);
                Iterator it = abstracts.iterator();
                while (it.hasNext()) {
                    sb2.append("[ " + it.next() + " ]");
                }
                logger.info((Object)("\n------------------------------------------------------\n| ABSTRACT METHODS THAT DID NOT MATCH ANY CMP OR... |\n------------------------------------------------------\n" + sb2));
            }
            return false;
        }
        abstractMethods = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SbbAbstractClass " + sbbAbstractClass.getName() + " follows the descriptor"));
        }
        return true;
    }

    private boolean checkProfileCMPMethods(CtClass sbbAbstractClass, Map abstractMethods, Map superClassesAbstractMethods) {
        ProfileCMPMethod[] profileCMPMethods = this.sbbDeploymentDescriptor.getProfileCMPMethods();
        if (profileCMPMethods != null) {
            for (int i = 0; i < profileCMPMethods.length; ++i) {
                String methodName = profileCMPMethods[i].getProfileCMPMethod();
                CtMethod profileCMPMethod = (CtMethod)abstractMethods.get(methodName);
                if (profileCMPMethod == null) {
                    profileCMPMethod = (CtMethod)superClassesAbstractMethods.get(methodName);
                    if (profileCMPMethod == null) {
                        logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " ProfileCMPMethod " + methodName + " defined in the descriptor is missing"));
                        return false;
                    }
                } else {
                    if (profileCMPMethod.getName().startsWith("sbb") || profileCMPMethod.getName().startsWith("ejb")) {
                        logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " ProfileCMPMethod " + methodName + " should not starts with sbb or ejb in its name"));
                        return false;
                    }
                    try {
                        CtClass[] parameters = profileCMPMethod.getParameterTypes();
                        if (parameters.length != 1) {
                            logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " ProfileCMPMethod " + methodName + " should have one and only argument " + "of type javax.slee.profile.ProfileID"));
                            return false;
                        }
                        if (!parameters[0].getName().equals("javax.slee.profile.ProfileID")) {
                            logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " ProfileCMPMethod " + methodName + " should have one and only argument " + "of type javax.slee.profile.ProfileID"));
                            return false;
                        }
                    }
                    catch (NotFoundException e) {
                        logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " ProfileCMPMethod " + methodName + " should have one argument of type javax.slee.profile.ProfileID"));
                        return false;
                    }
                    try {
                        CtClass[] exceptions = profileCMPMethod.getExceptionTypes();
                        if (exceptions.length < 2) {
                            logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " ProfileCMPMethod " + methodName + " should have both exceptions " + "of type javax.slee.profile.UnrecognizedProfileNameException and " + "javax.slee.profile.UnrecognizedProfileTableNameException declared thrown"));
                            return false;
                        }
                        boolean profileNameExceptionThrown = false;
                        boolean profileTableNameExceptionThrown = false;
                        for (int j = 0; !(j >= exceptions.length || profileNameExceptionThrown && profileTableNameExceptionThrown); ++j) {
                            if (exceptions[j].getName().equals("javax.slee.profile.UnrecognizedProfileNameException")) {
                                profileNameExceptionThrown = true;
                            }
                            if (!exceptions[j].getName().equals("javax.slee.profile.UnrecognizedProfileNameException")) continue;
                            profileTableNameExceptionThrown = true;
                        }
                        if (!profileNameExceptionThrown) {
                            logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " ProfileCMPMethod " + methodName + " should have this exception " + "of type javax.slee.profile.UnrecognizedProfileNameException " + "declared thrown"));
                            return false;
                        }
                        if (!profileTableNameExceptionThrown) {
                            logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " ProfileCMPMethod " + methodName + " should have this exception " + "of type javax.slee.profile.UnrecognizedProfileTableNameException " + "declared thrown"));
                            return false;
                        }
                    }
                    catch (NotFoundException e) {
                        logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " ProfileCMPMethod " + methodName + " should have both exceptions " + "of type javax.slee.profile.UnrecognizedProfileNameException and " + "javax.slee.profile.UnrecognizedProfileTableNameException declared thrown"));
                        return false;
                    }
                    ComponentKey componentKey = profileCMPMethods[i].getProfileSpecKey();
                }
                abstractMethods.remove(methodName);
            }
        }
        logger.debug((Object)"profiles CMP methods ok");
        return true;
    }

    private boolean checkCMPFieldsAgainstDeploymentDescripor(Map abstractMethods, CMPField[] cmpFields, CtClass sbbAbstractClass) {
        for (int i = 0; i < cmpFields.length; ++i) {
            CtClass[] parameterTypes;
            CtClass returnType;
            if (cmpFields[i] == null) continue;
            String fieldName = cmpFields[i].getFieldName();
            fieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            CtMethod setterAccessor = (CtMethod)abstractMethods.get("set" + fieldName);
            CtMethod getterAccessor = (CtMethod)abstractMethods.get("get" + fieldName);
            if (setterAccessor == null && getterAccessor == null) {
                logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => accessor missing"));
                return false;
            }
            if (getterAccessor != null) {
                try {
                    returnType = getterAccessor.getReturnType();
                    if (returnType.getName().equalsIgnoreCase("void")) {
                        logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => getter accessor has no return type"));
                        return false;
                    }
                }
                catch (NotFoundException nfe) {
                    logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => getter accessor has no return type"));
                    return false;
                }
                try {
                    parameterTypes = getterAccessor.getParameterTypes();
                    if (parameterTypes != null && parameterTypes.length > 0) {
                        logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => getter accessor has some parameters"));
                        return false;
                    }
                }
                catch (NotFoundException nfe) {
                    // empty catch block
                }
                abstractMethods.remove(getterAccessor.getName());
            }
            if (setterAccessor != null) {
                block23: {
                    try {
                        returnType = setterAccessor.getReturnType();
                        if (!returnType.getName().equalsIgnoreCase("void")) {
                            logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => setter accessor has a return type " + returnType.getName()));
                            return false;
                        }
                    }
                    catch (NotFoundException nfe) {
                        // empty catch block
                    }
                    try {
                        parameterTypes = setterAccessor.getParameterTypes();
                        if (parameterTypes.length != 1) {
                            logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => setter accessor has the wrong number of parameters"));
                            return false;
                        }
                    }
                    catch (NotFoundException nfe) {
                        logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => setter accessor has no parameters"));
                        return false;
                    }
                    try {
                        CtClass getterReturnType = getterAccessor.getReturnType();
                        CtClass[] setterParamTypes = setterAccessor.getParameterTypes();
                        CtClass setterParamType = setterParamTypes[0];
                        if (!getterReturnType.equals(setterParamType)) {
                            logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => getter return type is not same as setter parameter type"));
                            return false;
                        }
                        if (cmpFields[i].getSbbComponentKey() == null) break block23;
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Getter return type is: " + getterReturnType.getName()));
                            }
                            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(getterReturnType.getName());
                            Class<?> sbbLOClass = Thread.currentThread().getContextClassLoader().loadClass("javax.slee.SbbLocalObject");
                            if (!sbbLOClass.isAssignableFrom(cl)) {
                                logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => getter and setter types for an sbb ref must be SbbLocalObject"));
                                return false;
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"Failed check ref param", (Throwable)e);
                            return false;
                        }
                    }
                    catch (NotFoundException nfe) {
                        logger.error((Object)("integrity compromised on sbbAbstractClass " + sbbAbstractClass.getName() + " on CMP Field " + fieldName + " => getter/setter accessor has no parameters/return type"));
                        return false;
                    }
                }
                abstractMethods.remove(setterAccessor.getName());
            }
            cmpFields[i] = null;
        }
        return true;
    }

    private boolean checkEventHandlerMethods(CtClass sbbAbstractClass, SleeContainer serviceContainer) {
        HashSet sbbEventEntries = this.sbbDeploymentDescriptor.getSbbEventEntries();
        Iterator it = sbbEventEntries.iterator();
        while (it.hasNext()) {
            int i;
            SbbEventEntry sbbEventEntry = (SbbEventEntry)it.next();
            String eventName = sbbEventEntry.getEventName();
            if (sbbEventEntry.getEventDirection() == 2) continue;
            ComponentKey ckey = sbbEventEntry.getEventTypeRefKey();
            EventTypeIDImpl eventTypeID = serviceContainer.getEventType(ckey);
            if (eventTypeID == null) {
                logger.error((Object)("event type id " + eventName + " is unknown to the SLEE!"));
                return false;
            }
            String methodName = "on" + sbbEventEntry.getEventName();
            EventTypeDescriptorImpl eventTypeDesc = serviceContainer.getEventDescriptor(eventTypeID);
            String eventClass = eventTypeDesc.getEventClassName();
            Set methodSet = ClassUtils.getPublicMethods(sbbAbstractClass);
            CtMethod[] methods = new CtMethod[methodSet.size()];
            methodSet.toArray(methods);
            for (i = 0; i < methods.length && !methods[i].getName().equals(methodName); ++i) {
            }
            if (i == methods.length) {
                logger.error((Object)("no methods to check against " + methodName));
                return false;
            }
            try {
                if (methods[i].getReturnType() != CtClass.voidType) {
                    this.errorString = "event handler must have void return type";
                    logger.error((Object)this.errorString);
                    return false;
                }
                CtClass[] parameters = methods[i].getParameterTypes();
                if (parameters.length != 2) {
                    this.errorString = "bad method signature ( wrong number of params!)";
                    logger.error((Object)this.errorString);
                    return false;
                }
                CtClass param = parameters[0];
                if (!param.getName().equals(eventClass)) {
                    this.errorString = "bad event handler method signature expected " + eventClass;
                    logger.error((Object)this.errorString);
                    return false;
                }
                param = parameters[1];
                String customACIName = this.sbbDeploymentDescriptor.getActivityContextInterfaceClassName();
                if (customACIName != null) {
                    if (!customACIName.equals(param.getName()) && !param.getName().equals((class$javax$slee$ActivityContextInterface == null ? SbbVerifier.class$("javax.slee.ActivityContextInterface") : class$javax$slee$ActivityContextInterface).getName())) {
                        this.errorString = "bad event handler method signature expected " + customACIName + " or " + ActivityContextInterface.class.getName();
                        logger.error((Object)this.errorString);
                        return false;
                    }
                } else if (!param.getName().equals((class$javax$slee$ActivityContextInterface == null ? SbbVerifier.class$("javax.slee.ActivityContextInterface") : class$javax$slee$ActivityContextInterface).getName())) {
                    this.errorString = "bad event handler method signature expected " + ActivityContextInterface.class.getName();
                    logger.error((Object)this.errorString);
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (sbbEventEntry.isInitial() && sbbEventEntry.getInitialEventSelectorMethod() != null) {
                logger.debug((Object)"== CHECKING EVENT SELECTOR METHOD ==");
                String selectorMethodName = sbbEventEntry.getInitialEventSelectorMethod();
                String selectorNameAndSignature = selectorMethodName + "(L" + (class$javax$slee$InitialEventSelector == null ? SbbVerifier.class$("javax.slee.InitialEventSelector") : class$javax$slee$InitialEventSelector).getName().replace('.', '/') + ";)" + "L" + (class$javax$slee$InitialEventSelector == null ? SbbVerifier.class$("javax.slee.InitialEventSelector") : class$javax$slee$InitialEventSelector).getName().replace('.', '/') + ";";
                String selectorForPoeple = "public " + (class$javax$slee$InitialEventSelector == null ? SbbVerifier.class$("javax.slee.InitialEventSelector") : class$javax$slee$InitialEventSelector).getName() + " " + selectorMethodName + "(" + (class$javax$slee$InitialEventSelector == null ? SbbVerifier.class$("javax.slee.InitialEventSelector") : class$javax$slee$InitialEventSelector).getName() + ")";
                Map meths = ClassUtils.getConcreteMethodsFromClass(sbbAbstractClass);
                CtClass localSbbClass = sbbAbstractClass;
                CtMethod selectorMethod = (CtMethod)meths.get(selectorNameAndSignature);
                try {
                    while (selectorMethod == null && !localSbbClass.getSuperclass().equals(class$java$lang$Object == null ? SbbVerifier.class$("java.lang.Object") : class$java$lang$Object)) {
                        localSbbClass = localSbbClass.getSuperclass();
                        meths = ClassUtils.getConcreteMethodsFromClass(localSbbClass);
                        selectorMethod = (CtMethod)meths.get(selectorNameAndSignature);
                    }
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
                if (selectorMethod == null) {
                    this.errorString = "No initial event selector method: " + selectorMethodName + " for " + sbbEventEntry.getEventTypeRefKey() + " expected method signature: " + selectorForPoeple;
                    logger.error((Object)this.errorString);
                    return false;
                }
                if (!Modifier.isPublic((int)selectorMethod.getModifiers())) {
                    this.errorString = "Initial event selector method: " + selectorMethodName + " for " + sbbEventEntry.getEventTypeRefKey() + " MUST BE PUBLIC";
                    logger.error((Object)this.errorString);
                    return false;
                }
                if (Modifier.isStatic((int)selectorMethod.getModifiers())) {
                    this.errorString = "Initial event selector method: " + selectorMethodName + " for " + sbbEventEntry.getEventTypeRefKey() + " CAN NOT BE STATIC";
                    logger.error((Object)this.errorString);
                    return false;
                }
                if (Modifier.isFinal((int)selectorMethod.getModifiers())) {
                    this.errorString = "Initial event selector method: " + selectorMethodName + " for " + sbbEventEntry.getEventTypeRefKey() + " CAN NOT BE FINAL";
                    logger.error((Object)this.errorString);
                    return false;
                }
                logger.debug((Object)(" == event slector method:" + selectorForPoeple + " has been verified."));
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("found an event handler " + methods[i].getName()));
        }
        return true;
    }

    static {
        logger = Logger.getLogger((Class)SbbVerifier.class);
    }
}

