/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.slee.ActivityContextInterface;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.deployment.interceptors.ActivityContextInterfaceInterceptor;
import org.mobicents.slee.container.management.SbbDescriptorImpl;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextIDInterface;

public class DefaultActivityContextInterfaceInterceptor
implements ActivityContextInterfaceInterceptor {
    private SbbDescriptorImpl descriptor;
    private HashMap aliases;
    private ActivityContextInterface activityContextInterface = null;
    private static Logger logger = Logger.getLogger((Class)DefaultActivityContextInterfaceInterceptor.class);

    public DefaultActivityContextInterfaceInterceptor(SbbDescriptorImpl descriptor) {
        this.descriptor = descriptor;
        this.aliases = this.descriptor.getActivityContextInterfaceAttributeAliases();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String field;
        ActivityContext ac = ((ActivityContextIDInterface)this.activityContextInterface).retrieveActivityContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DefaultActivityContextInterceptor : " + method.getName()));
        }
        String className = proxy.getClass().getName();
        String accessorType = method.getName().substring(0, 3);
        String accessorName = method.getName().substring(3);
        String firstCharLowerCase = accessorName.substring(0, 1).toLowerCase();
        accessorName = field = firstCharLowerCase.concat(accessorName.substring(1));
        String alias = (String)this.aliases.get(accessorName);
        String key = className.substring("".length(), className.length() - "Impl".length()) + "." + accessorName;
        if (alias != null) {
            key = alias;
        }
        if (accessorType.equalsIgnoreCase("get")) {
            if (args.length != 0) {
                throw new Exception("wrong number of arguments");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("GET key:" + key));
            }
            Object value = ac.getDataAttribute(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("GET value: " + value));
            }
            Class<?> returnType = method.getReturnType();
            if (value == null && returnType.isPrimitive()) {
                if (returnType.equals(Integer.TYPE)) {
                    return new Integer(0);
                }
                if (returnType.equals(Boolean.TYPE)) {
                    return new Boolean("false");
                }
                if (returnType.equals(Long.TYPE)) {
                    return new Long(0L);
                }
                if (returnType.equals(Double.TYPE)) {
                    return new Double(0.0);
                }
                if (returnType.equals(Float.TYPE)) {
                    return new Float(0.0f);
                }
            }
            return value;
        }
        if (accessorType.equalsIgnoreCase("set")) {
            if (args.length != 1) {
                throw new Exception("wrong number of arguments");
            }
        } else {
            throw new Exception("wrong accessor method, it's neither a getter nor a setter");
        }
        ac.setDataAttribute(key, args[0]);
        return null;
    }

    public void setActivityContextInterface(ActivityContextInterface activityContextInterface) {
        this.activityContextInterface = activityContextInterface;
    }

    public ActivityContextInterface getActivityContextInterface() {
        return this.activityContextInterface;
    }
}

