/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.interceptors;

import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.deployment.interceptors.PersistenceInterceptor;
import org.mobicents.slee.container.management.CMPField;
import org.mobicents.slee.runtime.SbbEntity;

public class DefaultPersistenceInterceptor
implements PersistenceInterceptor {
    SbbEntity sbbEntity = null;
    Object persistentSbbStateObject = null;
    Class persistentClass = null;
    private static Logger logger = Logger.getLogger((Class)DefaultPersistenceInterceptor.class);

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int i;
        Object returnObject = null;
        Class<?> returnType = method.getReturnType();
        String accessorType = method.getName().substring(0, 3);
        String accessorName = method.getName().substring(3);
        char firstChar = accessorName.charAt(0);
        char newChar = Character.isLowerCase(firstChar) ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar);
        StringBuffer sbuf = new StringBuffer(accessorName);
        sbuf.setCharAt(0, newChar);
        accessorName = sbuf.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sbbEntity:" + this.sbbEntity));
            logger.debug((Object)("sbbEntity.getSbbDescriptor():" + this.sbbEntity.getSbbDescriptor()));
            logger.debug((Object)("sbbEntity.getSbbDescriptor()).getCMPFields():" + this.sbbEntity.getSbbDescriptor().getCMPFields()));
        }
        CMPField[] cmpFields = this.sbbEntity.getSbbDescriptor().getCMPFields();
        for (i = 0; i < cmpFields.length && !cmpFields[i].getFieldName().equals(accessorName); ++i) {
        }
        if (i == cmpFields.length) {
            throw new Exception("CMP Field not found");
        }
        if (accessorType.equalsIgnoreCase("get")) {
            try {
                returnObject = this.sbbEntity.getCMPField(cmpFields[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(" error accessing cmp field ", e);
            }
        } else if (accessorType.equalsIgnoreCase("set")) {
            this.sbbEntity.setCMPField(cmpFields[i], args[0]);
        } else {
            throw new Exception("wrong accessor method, it's neither a getter nor a setter");
        }
        if (returnObject == null && returnType.isPrimitive()) {
            if (returnType.equals(Integer.TYPE)) {
                return new Integer(0);
            }
            if (returnType.equals(Boolean.TYPE)) {
                return new Boolean("false");
            }
            if (returnType.equals(Long.TYPE)) {
                return new Long(0L);
            }
            if (returnType.equals(Double.TYPE)) {
                return new Double(0.0);
            }
            if (returnType.equals(Float.TYPE)) {
                return new Float(0.0f);
            }
        }
        return returnObject;
    }

    public SbbEntity getSbbEntity() {
        return this.sbbEntity;
    }

    public void setSbbEntity(SbbEntity sbbEntity) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("In setSbbEntity::" + sbbEntity));
        }
        this.sbbEntity = sbbEntity;
    }
}

