/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.interceptors;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.InvalidStateException;
import javax.slee.SLEEException;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileImplementationException;
import javax.slee.profile.ProfileManagement;
import javax.slee.profile.ProfileVerificationException;
import javax.transaction.SystemException;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.deployment.interceptors.ProfileManagementInterceptor;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.profile.SleeProfileManager;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;
import org.mobicents.slee.runtime.DeferredEvent;
import org.mobicents.slee.runtime.facilities.ProfileAddedEventImpl;
import org.mobicents.slee.runtime.facilities.ProfileTableActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.runtime.facilities.ProfileTableActivityImpl;
import org.mobicents.slee.runtime.facilities.ProfileUpdatedEventImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;

public class DefaultProfileManagementInterceptor
implements ProfileManagementInterceptor {
    private static String tcache = TransactionManagerImpl.PROFILE_CACHE;
    private boolean dirtyFlag = false;
    private boolean profileWriteable = true;
    private boolean isSbbProfile = false;
    private SleeProfileManager sleeProfileManager;
    private static Logger logger = Logger.getLogger((Class)DefaultProfileManagementInterceptor.class);
    private String profileKey;
    private Object profileTransientState = null;
    private Map fieldsMap = null;
    private Object profile;
    private boolean profileInitialized;
    private boolean profileInBackEndStorage;
    private String profileTableName;
    private String profileName;

    public DefaultProfileManagementInterceptor() {
    }

    public DefaultProfileManagementInterceptor(boolean isSbbProfile) {
        this.isSbbProfile = isSbbProfile;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SleeTransactionManager txManager = this.sleeProfileManager.getTransactionManager();
        boolean b = false;
        boolean rb = true;
        try {
            b = txManager.requireTransaction();
            Object result = this.processInvoke(proxy, method, args);
            rb = false;
            Object object = result;
            return object;
        }
        catch (Exception e) {
            txManager.setRollbackOnly();
            throw e;
        }
        finally {
            if (rb) {
                txManager.setRollbackOnly();
            }
            if (b) {
                txManager.commit();
            }
        }
    }

    private Object processInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.profileTransientState == null) {
            String name = proxy.getClass().getName();
            String profileCMPInterfaceName = name.substring("".length(), name.length() - "Impl".length());
            String profileTransientStateClassName = "" + profileCMPInterfaceName + "TransientState";
            ClassLoader cl = SleeContainerUtils.getCurrentThreadClassLoader();
            Class<?> profileTransientStateClass = cl.loadClass(profileTransientStateClassName);
            this.profileTransientState = profileTransientStateClass.newInstance();
            this.populateFieldsMap();
        }
        SleeTransactionManager txManager = this.sleeProfileManager.getTransactionManager();
        String methodName = method.getName();
        if (method.getName().equals("isProfileDirty")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("isProfileDirty called (profileKey=" + this.profileKey + ")"));
            }
            if (this.profileWriteable && this.dirtyFlag) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        if (method.getName().equals("isProfileWriteable")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("isProfileWriteable called (profileKey=" + this.profileKey + ")"));
            }
            return new Boolean(this.profileWriteable);
        }
        if (method.getName().equals("commitProfile")) {
            this.commitProfile();
            return null;
        }
        if (method.getName().equals("restoreProfile")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("restoreProfile called (profileKey=" + this.profileKey + ")"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            if (!this.profileWriteable) {
                throw new InvalidStateException();
            }
            txManager.setRollbackOnly();
            this.profileLoad();
            this.profileWriteable = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
                logger.debug((Object)"restoreProfile call ended");
            }
            return null;
        }
        if (method.getName().equals("closeProfile")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("closeProfile called (profileKey=" + this.profileKey + ")"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            if (this.profileWriteable) {
                throw new InvalidStateException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
                logger.debug((Object)"closeProfile call ended");
            }
            return null;
        }
        if (method.getName().equals("editProfile")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("editProfile called (profileKey=" + this.profileKey + ")"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            if (!this.profileWriteable) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"starting new Transaction and editing profile");
                }
                this.profileWriteable = true;
                ((ProfileManagement)this.profile).profileLoad();
            } else {
                logger.debug((Object)"profile already in the read/write state");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
                logger.debug((Object)"editProfile call ended");
            }
            return null;
        }
        if (method.getName().equals("markProfileDirty")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("markProfileDirty called (profileKey=" + this.profileKey + ")"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            this.dirtyFlag = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
                logger.debug((Object)"markProfileDirty call ended");
            }
            return null;
        }
        if (method.getName().equals("profileInitialize")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileInitialize called (profileKey=" + this.profileKey + ")"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            this.profileInitialize(proxy, method, args);
            this.dirtyFlag = true;
            this.profileInitialized = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
                logger.debug((Object)"profileInitialize call ended");
            }
            return null;
        }
        if (method.getName().equals("profileStore")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileStore called (profileKey=" + this.profileKey + ")"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            try {
                this.profileStore();
            }
            catch (Exception e) {
                txManager.setRollbackOnly();
                this.dirtyFlag = false;
                throw e;
            }
            this.dirtyFlag = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
                logger.debug((Object)"profileStore call ended");
            }
            return null;
        }
        if (method.getName().equals("profileLoad")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileLoad called (profileKey=" + this.profileKey + ")"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            this.profileLoad();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
                logger.debug((Object)"profileLoad call ended");
            }
            return null;
        }
        if (method.getName().equals("profileVerify")) {
            this.profileVerify();
            return null;
        }
        if (method.getName().equals("isProfileValid")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("isProfileValid called (profileKey=" + this.profileKey + ")"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            if (args[0] == null) {
                throw new NullPointerException();
            }
            ProfileID profileID = (ProfileID)args[0];
            try {
                boolean profileExist = this.sleeProfileManager.profileExist(profileID);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("profileWriteable " + this.profileWriteable));
                    logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
                    logger.debug((Object)"isProfileValid call ended");
                }
                return new Boolean(profileExist);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SLEEException("Profile cannot be found due to a system-level failure");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("before accessor " + method.getName().substring(3) + " called"));
        }
        if (this.isAccessor(proxy, method, args)) {
            Field field;
            String fieldName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("accessor " + method.getName().substring(3) + " called"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            if (method.getName().startsWith("get")) {
                if (this.isSbbProfile) {
                    String attributeName = Introspector.decapitalize(method.getName().substring(3));
                    return this.sleeProfileManager.getProfileAttributeValue(this.profileKey, attributeName);
                }
                fieldName = Introspector.decapitalize(method.getName().substring(3));
                field = SleeContainer.isSecurityEnabled() ? (Field)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return DefaultProfileManagementInterceptor.this.profileTransientState.getClass().getDeclaredField(fieldName);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }) : this.profileTransientState.getClass().getDeclaredField(fieldName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("accessor " + method.getName().substring(3) + " called, value=" + field.get(this.profileTransientState)));
                }
                return field.get(this.profileTransientState);
            }
            if (!this.profileWriteable) {
                throw new InvalidStateException();
            }
            if (this.isSbbProfile) {
                throw new UnsupportedOperationException();
            }
            logger.info((Object)(methodName + " value " + args[0]));
            fieldName = Introspector.decapitalize(method.getName().substring(3));
            field = SleeContainer.isSecurityEnabled() ? (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return DefaultProfileManagementInterceptor.this.profileTransientState.getClass().getDeclaredField(fieldName);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }) : this.profileTransientState.getClass().getDeclaredField(fieldName);
            logger.debug((Object)("setValue" + args[0]));
            field.set(this.profileTransientState, args[0]);
            this.dirtyFlag = true;
            return null;
        }
        Class[] parameters = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameters[i] = args[i].getClass();
        }
        if (method.getName().startsWith("set")) {
            if (!this.profileWriteable) {
                throw new InvalidStateException();
            }
            if (this.isSbbProfile) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return this.callSuperMethod(this.profile, methodName, args);
        }
        catch (Exception e) {
            throw new ProfileImplementationException((Throwable)e);
        }
    }

    protected void profileVerify() throws ProfileVerificationException, SystemException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("profileVerify called (profileKey=" + this.profileKey + ")"));
            logger.debug((Object)("profileWriteable " + this.profileWriteable));
            logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
        }
        Map indexes = this.sleeProfileManager.getProfileIndexesSpec(this.profileTableName);
        Iterator iter = indexes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Boolean isUnisuqAttribute = (Boolean)entry.getValue();
            if (!isUnisuqAttribute.booleanValue()) continue;
            String attributeName = (String)entry.getKey();
            this.verifyAttributeForUniqueness(attributeName);
        }
        if (this.profileInitialized) {
            this.profileWriteable = false;
            this.profileInitialized = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("profileWriteable " + this.profileWriteable));
            logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            logger.debug((Object)"profileVerify call ended");
        }
    }

    private void verifyAttributeForUniqueness(String attributeName) throws ProfileVerificationException {
        Field field = (Field)this.fieldsMap.get(attributeName);
        try {
            Object value = field.get(this.profileTransientState);
            if (value == null) {
                return;
            }
            if (field.getType().isArray()) {
                HashSet<Object> valueSet = new HashSet<Object>();
                Object[] values = (Object[])value;
                for (int i = 0; i < values.length; ++i) {
                    if (valueSet.add(values[i])) continue;
                    throw new ProfileVerificationException("Non-unique value (" + values[i] + ") for unique indexed profile attribute (" + attributeName + ")");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ProfileVerificationException) {
                throw (ProfileVerificationException)e;
            }
            String err = "Failed verifyAttributeForUniqueness(" + attributeName + ")";
            logger.warn((Object)err, (Throwable)e);
            throw new ProfileVerificationException(err, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitProfile() throws InvalidStateException, ProfileVerificationException, ManagementException {
        SleeTransactionManager txManager = this.sleeProfileManager.getTransactionManager();
        boolean b = false;
        b = txManager.requireTransaction();
        try {
            int eventID;
            ActivityContextInterfaceImpl activityContextInterface;
            ProfileTableActivityContextInterfaceFactoryImpl profileTableActivityContextInterfaceFactory;
            if (!this.profileWriteable) {
                throw new InvalidStateException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("commitProfile called (profileKey=" + this.profileKey + ")"));
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
            }
            if (this.profileName != null) {
                ProfileID profileID = new ProfileID(this.profileTableName, this.profileName);
                try {
                    txManager.putObject(tcache, this.getProfileKey(), "profileID", profileID);
                }
                catch (Exception e4) {
                    logger.error((Object)("Failed profile commit, createNode() exception. Profile key: " + this.getProfileKey()), (Throwable)e4);
                    throw new ManagementException(e4.getMessage());
                }
            }
            ProfileManagement profileBeforeUpdate = null;
            if (this.profileInBackEndStorage) {
                try {
                    profileBeforeUpdate = this.sleeProfileManager.instantiateLastCommittedProfile(this.profileTableName, this.profileName);
                }
                catch (Exception e1) {
                    throw new ManagementException("Failed instantiateLastCommittedProfile ", (Throwable)e1);
                }
            }
            try {
                ((ProfileManagement)this.profile).profileStore();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof ProfileVerificationException) {
                    throw (ProfileVerificationException)e;
                }
                throw new ManagementException(e.getMessage());
            }
            try {
                ((ProfileManagement)this.profile).profileVerify();
            }
            catch (Exception e) {
                throw new ProfileVerificationException(e.getMessage());
            }
            try {
                this.persistProfile();
            }
            catch (Exception e3) {
                logger.error((Object)"Failed commitProfile, profileStore()", (Throwable)e3);
                if (e3 instanceof ProfileVerificationException) {
                    throw (ProfileVerificationException)e3;
                }
                throw new ManagementException("Failed commitProfile, profileStore()", (Throwable)e3);
            }
            SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
            Address profileAddress = new Address(AddressPlan.SLEE_PROFILE, this.profileTableName + "/" + this.profileName);
            try {
                profileTableActivityContextInterfaceFactory = SleeContainer.getProfileTableActivityContextInterfaceFactory();
            }
            catch (NamingException ex) {
                logger.error((Object)"Error retrieving facility", (Throwable)ex);
                throw new ManagementException("Unexpected Naming Exception", (Throwable)ex);
            }
            ProfileTableActivityImpl profileTableActivity = new ProfileTableActivityImpl(this.profileTableName);
            try {
                activityContextInterface = (ActivityContextInterfaceImpl)profileTableActivityContextInterfaceFactory.getActivityContextInterface(profileTableActivity);
            }
            catch (Exception e1) {
                throw new ManagementException("Failed committing profile", (Throwable)e1);
            }
            if (!this.profileInBackEndStorage) {
                ProfileAddedEventImpl profileAddedEvent = new ProfileAddedEventImpl(profileAddress, new ProfileID(profileAddress), this.profile, activityContextInterface, profileTableActivityContextInterfaceFactory);
                eventID = serviceContainer.getEventLookupFacility().getEventID(new ComponentKey("javax.slee.profile.ProfileAddedEvent", "javax.slee", "1.0"));
                DeferredEvent deferredEvent = new DeferredEvent(serviceContainer, eventID, (Object)profileAddedEvent, serviceContainer.getActivityContextFactory().getActivityFromKey(activityContextInterface.retrieveActivityContextID()), profileAddress);
                try {
                    txManager.addAfterCommitAction(deferredEvent);
                }
                catch (SystemException e2) {
                    throw new ManagementException("Failed committing profile", (Throwable)e2);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Queued following profile added event:" + profileAddedEvent.getEventTypeID() + ",:" + activityContextInterface.retrieveActivityContextID() + ",eventId=" + eventID));
                }
                this.profileInBackEndStorage = true;
            } else {
                ProfileUpdatedEventImpl profileUpdatedEvent = new ProfileUpdatedEventImpl(profileAddress, new ProfileID(profileAddress), profileBeforeUpdate, this.profile, activityContextInterface, profileTableActivityContextInterfaceFactory);
                eventID = serviceContainer.getEventLookupFacility().getEventID(new ComponentKey("javax.slee.profile.ProfileUpdatedEvent", "javax.slee", "1.0"));
                DeferredEvent deferredEvent = new DeferredEvent(serviceContainer, eventID, (Object)profileUpdatedEvent, serviceContainer.getActivityContextFactory().getActivityFromKey(activityContextInterface.retrieveActivityContextID()), profileAddress);
                try {
                    txManager.addAfterCommitAction(deferredEvent);
                }
                catch (SystemException e2) {
                    throw new ManagementException("Failed committing profile", (Throwable)e2);
                }
                logger.debug((Object)("Queued following updated event: " + profileUpdatedEvent.getEventTypeID() + ",:" + activityContextInterface.retrieveActivityContextID() + ",eventId=" + eventID));
                this.profileInBackEndStorage = true;
            }
            try {
                if (b) {
                    txManager.commit();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed committing profile", (Throwable)e);
                try {
                    txManager.rollback();
                }
                catch (SystemException e2) {
                    logger.error((Object)("Failed rolling back profile: " + this.getProfileKey()), (Throwable)e2);
                    throw new ManagementException(e.getMessage());
                }
                throw new ManagementException(e.getMessage());
            }
            this.profileWriteable = false;
            this.dirtyFlag = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("profileWriteable " + this.profileWriteable));
                logger.debug((Object)("dirtyFlag " + this.dirtyFlag));
                logger.debug((Object)"commitProfile call ended");
            }
        }
        finally {
            try {
                if (b && txManager.isInTx()) {
                    txManager.rollback();
                }
            }
            catch (SystemException se) {
                logger.error((Object)("Failed completing profile commit due to TX access problem. Profile key: " + this.getProfileKey()), (Throwable)se);
                throw new ManagementException(se.getMessage());
            }
        }
    }

    protected Object callSuperMethod(Object object, String methodName, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ProfileImplementationException {
        Class[] parameters = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameters[i] = !args[i].getClass().isPrimitive() ? DefaultProfileManagementInterceptor.getPrimitiveTypeFromClass(args[i].getClass()) : DefaultProfileManagementInterceptor.getPrimitiveTypeFromClass(args[i].getClass());
        }
        Method superMethod = object.getClass().getSuperclass().getMethod(methodName, parameters);
        Object result = superMethod.invoke(object, args);
        return result;
    }

    public static Class getPrimitiveTypeFromClass(Class argumentType) {
        if (argumentType.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (argumentType.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (argumentType.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (argumentType.equals(Character.class)) {
            return Character.TYPE;
        }
        if (argumentType.equals(Double.class)) {
            return Double.TYPE;
        }
        if (argumentType.equals(Float.class)) {
            return Float.TYPE;
        }
        if (argumentType.equals(Long.class)) {
            return Long.TYPE;
        }
        if (argumentType.equals(Short.class)) {
            return Short.TYPE;
        }
        return argumentType;
    }

    private boolean isAccessor(Object proxy, Method method, Object[] args) {
        String accessorName = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        Field[] fields = SleeContainer.isSecurityEnabled() ? (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return DefaultProfileManagementInterceptor.this.profileTransientState.getClass().getDeclaredFields();
            }
        }) : this.profileTransientState.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(accessorName)) continue;
            return true;
        }
        return false;
    }

    private void profileLoad() throws IllegalArgumentException, IllegalAccessException, SystemException {
        Field[] fields = SleeContainer.isSecurityEnabled() ? (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return DefaultProfileManagementInterceptor.this.profileTransientState.getClass().getDeclaredFields();
            }
        }) : this.profileTransientState.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Object fieldValue = this.sleeProfileManager.getProfileAttributeValue(this.profileKey, fields[i].getName());
            String debugString = "set " + fields[i].getName() + " to value " + fieldValue;
            if (fieldValue != null) {
                debugString = debugString + "type:" + fieldValue.getClass().getName();
            }
            logger.info((Object)debugString);
            if (fieldValue == null && fields[i].getType().isPrimitive()) {
                fields[i].set(this.profileTransientState, this.getDefautValue(fields[i].getType()));
                continue;
            }
            fields[i].set(this.profileTransientState, fieldValue);
        }
    }

    private void profileStore() {
    }

    private void profileInitialize(Object proxy, Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = SleeContainer.isSecurityEnabled() ? (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return DefaultProfileManagementInterceptor.this.profileTransientState.getClass().getDeclaredFields();
            }
        }) : this.profileTransientState.getClass().getDeclaredFields();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                fields[i].set(this.profileTransientState, this.getDefautValue(fields[i].getType()));
            }
        }
    }

    private Object getDefautValue(Class fieldType) {
        if (fieldType.equals(Integer.TYPE)) {
            return new Integer(0);
        }
        if (fieldType.equals(Long.TYPE)) {
            return new Long(0L);
        }
        if (fieldType.equals(Double.TYPE)) {
            return new Double(0.0);
        }
        if (fieldType.equals(Short.TYPE)) {
            return new Short(new Integer(0).shortValue());
        }
        if (fieldType.equals(Float.TYPE)) {
            return new Float(0.0f);
        }
        if (fieldType.equals(Character.TYPE)) {
            return new Character(' ');
        }
        if (fieldType.equals(Boolean.TYPE)) {
            return new Boolean(false);
        }
        if (fieldType.equals(Byte.TYPE)) {
            return new Byte(new Integer(0).byteValue());
        }
        return null;
    }

    public void setProfileManager(SleeProfileManager sleeProfileManager) {
        this.sleeProfileManager = sleeProfileManager;
    }

    public SleeProfileManager getProfileManager() {
        return this.sleeProfileManager;
    }

    public void setProfileKey(String profileKey) {
        this.profileKey = profileKey;
    }

    public String getProfileKey() {
        return this.profileKey;
    }

    public void copyStateFromDefaultProfile(String profileCMPInterfaceName, String defaultProfileKey) throws ManagementException {
        if (this.profileTransientState == null) {
            String profileTransientStateClassName = profileCMPInterfaceName + "TransientState";
            try {
                ClassLoader cl = SleeContainerUtils.getCurrentThreadClassLoader();
                Class<?> profileTransientStateClass = cl.loadClass(profileTransientStateClassName);
                this.profileTransientState = profileTransientStateClass.newInstance();
                Field[] fields = SleeContainer.isSecurityEnabled() ? (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return DefaultProfileManagementInterceptor.this.profileTransientState.getClass().getDeclaredFields();
                    }
                }) : this.profileTransientState.getClass().getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Object fieldValue = this.sleeProfileManager.getProfileAttributeValue(defaultProfileKey, fields[i].getName());
                    fields[i].set(this.profileTransientState, fieldValue);
                }
                this.populateFieldsMap();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new ManagementException("State cannot be copied from the default Profile.");
            }
        }
    }

    public void setProfile(Object profile) {
        this.profile = profile;
    }

    public Object getProfile() {
        return this.profile;
    }

    public void loadStateFromBackendStorage(String profileCMPInterfaceName) throws Exception {
        logger.info((Object)"loading profile data from backend storage");
        if (this.profileTransientState == null) {
            String profileTransientStateClassName = "" + profileCMPInterfaceName + "TransientState";
            ClassLoader cl = SleeContainerUtils.getCurrentThreadClassLoader();
            Class<?> profileTransientStateClass = cl.loadClass(profileTransientStateClassName);
            this.profileTransientState = profileTransientStateClass.newInstance();
            this.populateFieldsMap();
        }
        this.profileLoad();
        this.profileWriteable = false;
        this.profileInBackEndStorage = true;
    }

    private void populateFieldsMap() {
        this.fieldsMap = new HashMap();
        Field[] fields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return DefaultProfileManagementInterceptor.this.profileTransientState.getClass().getDeclaredFields();
            }
        });
        for (int i = 0; i < fields.length; ++i) {
            this.fieldsMap.put(fields[i].getName(), fields[i]);
        }
    }

    public void setProfileTableName(String newProfileTableName) {
        this.profileTableName = newProfileTableName;
    }

    public String getProfileTableName() {
        return this.profileTableName;
    }

    public void setProfileName(String newProfileName) {
        this.profileName = newProfileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void persistProfile() throws Exception {
        Field[] fields = SleeContainer.isSecurityEnabled() ? (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return DefaultProfileManagementInterceptor.this.profileTransientState.getClass().getDeclaredFields();
            }
        }) : this.profileTransientState.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Object fieldValue = fields[i].get(this.profileTransientState);
            this.sleeProfileManager.setProfileAttributeValue(this.profileKey, fields[i].getName(), fieldValue);
        }
    }
}

