/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.Map;
import javax.slee.SLEEException;
import javax.slee.profile.ProfileID;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.deployment.interceptors.SBBProfileCMPInterceptor;
import org.mobicents.slee.container.management.ProfileCMPMethod;
import org.mobicents.slee.container.profile.SleeProfileManager;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbObject;
import org.mobicents.slee.runtime.SbbObjectState;

public class DefaultSBBProfileCMPInterceptor
implements SBBProfileCMPInterceptor {
    SbbEntity sbbEntity = null;
    private static Logger logger = Logger.getLogger((Class)DefaultSBBProfileCMPInterceptor.class);
    Map profileTypeProxies = new ConcurrentHashMap();

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int i;
        ProfileCMPMethod[] profileCMPMethods = this.sbbEntity.getSbbDescriptor().getProfileCMPMethods();
        for (i = 0; i < profileCMPMethods.length && !profileCMPMethods[i].getProfileCMPMethod().equals(method.getName()); ++i) {
        }
        if (i == profileCMPMethods.length) {
            throw new AbstractMethodError("Profile CMP Method not found");
        }
        SbbObject sbbObject = this.sbbEntity.getSbbObject();
        if (!sbbObject.getState().equals(SbbObjectState.READY)) {
            logger.error((Object)("InvalidState ! " + sbbObject.getState()));
            throw new IllegalStateException("InvalidState! " + sbbObject.getState());
        }
        return this.callGetProfileMethod(profileCMPMethods[i], (ProfileID)args[0]);
    }

    public SbbEntity getSbbEntity() {
        return this.sbbEntity;
    }

    public void setSbbEntity(SbbEntity sbbEntity) {
        this.sbbEntity = sbbEntity;
    }

    private Object callGetProfileMethod(ProfileCMPMethod method, ProfileID profileID) throws UnrecognizedProfileTableNameException, UnrecognizedProfileNameException, SystemException {
        SleeProfileManager sleeProfileManager = SleeProfileManager.getInstance();
        try {
            if (sleeProfileManager.findProfileSpecId(profileID.getProfileTableName()) == null) {
                throw new UnrecognizedProfileTableNameException();
            }
        }
        catch (SystemException e) {
            throw new SLEEException("low-level failure");
        }
        if (sleeProfileManager.findProfileMBean(profileID.getProfileTableName(), profileID.getProfileName()) == null) {
            throw new UnrecognizedProfileNameException();
        }
        return sleeProfileManager.getSbbCMPProfile(profileID);
    }
}

