/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.slee.TransactionRolledbackLocalException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.runtime.SbbConcrete;
import org.mobicents.slee.runtime.SbbLocalObjectConcrete;

public class SbbLocalObjectInterceptor {
    private static Logger logger = Logger.getLogger((Class)SbbLocalObjectInterceptor.class);
    private ClassLoader myClassLoader;
    private boolean setRollbackOnly;

    public SbbLocalObjectInterceptor(SbbLocalObjectConcrete sbbLocalObject) {
        this.myClassLoader = sbbLocalObject.getContextClassLoader();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("myClassLoader " + this.myClassLoader));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invokeAndReturnObject(Object proxy, String methodName, Object[] args, Class[] types) throws Exception {
        Object object;
        if (this.setRollbackOnly) {
            throw new TransactionRolledbackLocalException("Previous invocation caused rollback");
        }
        ClassLoader oldClassLoader = SleeContainerUtils.getCurrentThreadClassLoader();
        if (SleeContainer.isSecurityEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(SbbLocalObjectInterceptor.this.myClassLoader);
                    return null;
                }
            });
        } else {
            Thread.currentThread().setContextClassLoader(this.myClassLoader);
        }
        SbbConcrete sbbConcrete = (SbbConcrete)proxy;
        try {
            Method meth = proxy.getClass().getMethod(methodName, types);
            object = meth.invoke(proxy, args);
        }
        catch (InvocationTargetException ex) {
            try {
                SleeContainer.getTransactionManager().setRollbackOnly();
                this.setRollbackOnly = true;
                throw new TransactionRolledbackLocalException("Invocation resulted in exception ! ", ex.getCause());
                catch (Exception ex2) {
                    if (!logger.isDebugEnabled()) throw ex2;
                    ex2.printStackTrace();
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                if (SleeContainer.isSecurityEnabled()) {
                    AccessController.doPrivileged(new PrivilegedAction(oldClassLoader){
                        private final /* synthetic */ ClassLoader val$oldClassLoader;
                        {
                            this.val$oldClassLoader = classLoader;
                        }

                        public Object run() {
                            Thread.currentThread().setContextClassLoader(this.val$oldClassLoader);
                            return null;
                        }
                    });
                    throw throwable;
                }
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                throw throwable;
            }
        }
        if (SleeContainer.isSecurityEnabled()) {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            return object;
        }
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        return object;
    }

    public void invokeAndReturnvoid(Object proxy, String methodName, Object[] args, Class[] argTypes) throws Exception {
        this.invokeAndReturnObject(proxy, methodName, args, argTypes);
    }

    public boolean invokeAndReturnboolean(Object proxy, String methodName, Object[] args, Class[] argTypes) throws Exception {
        Object retval = this.invokeAndReturnObject(proxy, methodName, args, argTypes);
        logger.debug((Object)("invokeAndReturnboolean : returned = " + retval));
        return (Boolean)retval;
    }

    public int invokeAndReturnint(Object proxy, String methodName, Object[] args, Class[] types) throws Exception {
        Object retval = this.invokeAndReturnObject(proxy, methodName, args, types);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("invokeAndReturnint : returned = " + retval));
        }
        return (Integer)retval;
    }

    public long invokeAndReturnlong(Object proxy, String methodName, Object[] args, Class[] types) throws Exception {
        Object retval = this.invokeAndReturnObject(proxy, methodName, args, types);
        logger.debug((Object)("invokeAndReturnlong : returned = " + retval));
        return (Long)retval;
    }

    public double invokeAndReturndouble(Object proxy, String methodName, Object[] args, Class[] types) throws Exception {
        Object retval = this.invokeAndReturnObject(proxy, methodName, args, types);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("invokeAndReturndouble : returned = " + retval));
        }
        return (Double)retval;
    }

    public char invokeAndReturnchar(Object proxy, String methodName, Object[] args, Class[] types) throws Exception {
        Object retval = this.invokeAndReturnObject(proxy, methodName, args, types);
        logger.debug((Object)("invokeAndReturnchar : returned = " + retval));
        return ((Character)retval).charValue();
    }

    public float invokeAndReturnfloat(Object proxy, String methodName, Object[] args, Class[] types) throws Exception {
        Object retval = this.invokeAndReturnObject(proxy, methodName, args, types);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("invokeAndReturnchar : returned = " + retval));
        }
        return ((Float)retval).floatValue();
    }

    public float invokeAndReturnshort(Object proxy, String methodName, Object[] args, Class[] types) throws Exception {
        Object retval = this.invokeAndReturnObject(proxy, methodName, args, types);
        logger.debug((Object)("invokeAndReturnchar : returned = " + retval));
        return ((Short)retval).shortValue();
    }
}

