/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentMBean;
import javax.slee.management.ResourceManagementMBean;
import javax.slee.management.ServiceManagementMBean;
import javax.slee.resource.ResourceAdaptorDescriptor;
import javax.slee.resource.ResourceAdaptorID;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceControllerMBean;
import org.mobicents.slee.container.deployment.jboss.SleeDeployerMBean;
import org.mobicents.slee.container.management.jmx.ResourceAdaptorMBean;
import org.mobicents.slee.container.management.jmx.SleeManagementMBeanImplMBean;

public class SleeDeployer
extends SubDeployerSupport
implements SleeDeployerMBean {
    private ServiceControllerMBean serviceController;
    private DeploymentMBean sleeDeploymentMBean;
    private ResourceAdaptorMBean resourceAdaptorMBean;
    private ResourceManagementMBean resourceManagementMBean;
    private boolean validateDTDs;
    private HashMap deployments = new HashMap();
    private ObjectName sleeManagementMBeanName;
    private SleeManagementMBeanImplMBean sleeManagementMBean;
    private ServiceManagementMBean serviceManagementMBean;

    public Iterator getDeployedApplications() {
        return this.deployments.values().iterator();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? new ObjectName("slee:service=SleeDeployer,platform=jboss") : name;
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create((Class)ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.sleeManagementMBean = (SleeManagementMBeanImplMBean)MBeanProxyExt.create((Class)SleeManagementMBeanImplMBean.class, (ObjectName)this.sleeManagementMBeanName, (MBeanServer)this.server);
        this.sleeDeploymentMBean = (DeploymentMBean)MBeanProxyExt.create((Class)DeploymentMBean.class, (ObjectName)this.sleeManagementMBean.getDeploymentMBean(), (MBeanServer)this.server);
        this.resourceAdaptorMBean = (ResourceAdaptorMBean)MBeanProxyExt.create((Class)ResourceAdaptorMBean.class, (ObjectName)this.sleeManagementMBean.getResourceAdaptorMBean(), (MBeanServer)this.server);
        this.resourceManagementMBean = (ResourceManagementMBean)MBeanProxyExt.create((Class)ResourceManagementMBean.class, (ObjectName)this.sleeManagementMBean.getResourceManagementMBean(), (MBeanServer)this.server);
        this.serviceManagementMBean = (ServiceManagementMBean)MBeanProxyExt.create((Class)ServiceManagementMBean.class, (ObjectName)this.sleeManagementMBean.getServiceManagementMBean(), (MBeanServer)this.server);
        super.startService();
    }

    protected void stopService() throws Exception {
        DeploymentInfo di;
        Iterator modules = this.deployments.values().iterator();
        while (modules.hasNext()) {
            di = (DeploymentInfo)modules.next();
            this.stop(di);
        }
        modules = new ArrayList(this.deployments.values()).iterator();
        while (modules.hasNext()) {
            di = (DeploymentInfo)modules.next();
            this.destroy(di);
        }
        this.deployments.clear();
        super.stopService();
        this.serviceController = null;
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.getFile();
        if (!urlStr.endsWith("jar") && !urlStr.endsWith("jar/")) {
            return false;
        }
        boolean accepts = false;
        try {
            String ddStr;
            URL dd = di.localCl.findResource("META-INF/deployable-unit.xml");
            if (dd == null) {
                return false;
            }
            if (di.localUrl != null) {
                urlStr = di.localUrl.toString();
            }
            if ((ddStr = dd.toString()).indexOf(urlStr) >= 0) {
                accepts = true;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return accepts;
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("init, " + di.shortName));
        try {
            File file;
            di.watch = di.url.getProtocol().equalsIgnoreCase("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/deployable-unit.xml")) : di.url;
        }
        catch (Exception e) {
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException("failed to initialize", (Throwable)e);
        }
        super.init(di);
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        try {
            this.log.debug((Object)("start application, deploymentInfo: " + di + ", short name: " + di.shortName + ", parent short name: " + (di.parent == null ? "null" : di.parent.shortName)));
            DeployableUnitID did = this.sleeDeploymentMBean.install(di.localUrl.toExternalForm());
            di.metaData = did;
            DeployableUnitDescriptor dud = this.sleeDeploymentMBean.getDescriptor(did);
            this.activateComponents(dud.getComponents());
            this.deployments.put(di.url, di);
            this.log.info((Object)("Deployed: " + di.url));
        }
        catch (Exception e) {
            this.stop(di);
            this.destroy(di);
            throw new DeploymentException("Could not deploy " + di.url, (Throwable)e);
        }
        super.start(di);
    }

    private void activateComponents(ComponentID[] components) throws Exception {
        for (int i = 0; i < components.length; ++i) {
            ComponentID cid = components[i];
            if (cid instanceof ResourceAdaptorID) {
                this.activateResourceAdaptor((ResourceAdaptorID)cid);
                continue;
            }
            if (!(cid instanceof ServiceID)) continue;
            this.activateService((ServiceID)cid);
        }
    }

    private void activateService(ServiceID serviceID) throws Exception {
        this.serviceManagementMBean.activate(serviceID);
    }

    private void deactivateService(ServiceID serviceID) throws Exception {
        this.serviceManagementMBean.deactivate(serviceID);
    }

    private void deactivateComponents(ComponentID[] components) throws Exception {
        for (int i = components.length - 1; i >= 0; --i) {
            ComponentID cid = components[i];
            if (cid instanceof ResourceAdaptorID) {
                this.deactivateResourceAdaptor((ResourceAdaptorID)cid);
                continue;
            }
            if (!(cid instanceof ServiceID)) continue;
            this.deactivateService((ServiceID)cid);
        }
    }

    private String getRADefaultEntityName(ResourceAdaptorID raid) throws Exception {
        ResourceAdaptorDescriptor rad = (ResourceAdaptorDescriptor)this.sleeDeploymentMBean.getDescriptor((ComponentID)raid);
        String raEntityName = rad.getName() + "-ra";
        return raEntityName;
    }

    private void activateResourceAdaptor(ResourceAdaptorID raid) throws Exception {
        String raEntityName = this.getRADefaultEntityName(raid);
        this.resourceAdaptorMBean.createResourceAdaptorEntity(raid, raEntityName, new Properties());
        this.resourceAdaptorMBean.activateResourceAdaptorEntity(raEntityName);
        this.resourceAdaptorMBean.createEntityLink(raEntityName, raEntityName);
    }

    private void deactivateResourceAdaptor(ResourceAdaptorID raid) throws Exception {
        String raEntityName = this.getRADefaultEntityName(raid);
        this.resourceAdaptorMBean.removeEntityLink(raEntityName);
        this.resourceAdaptorMBean.deactivateResourceAdaptorEntity(raEntityName);
        this.resourceAdaptorMBean.removeResourceAdaptorEntity(raEntityName);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        this.log.info((Object)("Undeploying: " + di.url));
        try {
            DeployableUnitID did = (DeployableUnitID)di.metaData;
            if (did == null) {
                return;
            }
            DeployableUnitDescriptor dud = this.sleeDeploymentMBean.getDescriptor(did);
            this.deactivateComponents(dud.getComponents());
            this.sleeDeploymentMBean.uninstall(did);
        }
        catch (Exception e) {
            throw new DeploymentException("problem stopping SLEE module: " + di.url, (Throwable)e);
        }
        super.stop(di);
    }

    public boolean getValidateDTDs() {
        return this.validateDTDs;
    }

    public void setValidateDTDs(boolean validate) {
        this.validateDTDs = validate;
    }

    public ObjectName getSleeManagementMBean() {
        return this.sleeManagementMBeanName;
    }

    public void setSleeManagementMBean(ObjectName newSM) {
        this.sleeManagementMBeanName = newSM;
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        this.deployments.remove(di.url);
        super.destroy(di);
    }
}

