/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.DeploymentException;
import javax.slee.management.SbbDescriptor;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.mobicents.slee.container.management.ComponentContainer;
import org.mobicents.slee.container.management.DeployableUnitDeployer;
import org.mobicents.slee.container.management.DeployableUnitDescriptorImpl;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.DeployedComponent;
import org.mobicents.slee.container.management.DeploymentManager;
import org.mobicents.slee.container.management.SbbDescriptorImpl;

abstract class AbstractComponentDeployer {
    private Logger logger = Logger.getLogger((Class)AbstractComponentDeployer.class);
    private JarFile componentJar = null;
    protected List componentDescriptors = null;
    protected ComponentContainer componentContainer = null;
    protected File classpathDirectory = null;
    protected DeployableUnitDeployer duDeployer;
    private boolean preparedToDeploy;

    AbstractComponentDeployer() {
    }

    JarFile getJar() {
        return this.componentJar;
    }

    protected void initDeployer(JarFile componentJar, ComponentContainer container, File classpathDirectory, DeployableUnitDeployer duDeployer) throws DeploymentException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("componentJar " + componentJar + " container = " + container + " classpathDir " + classpathDirectory));
        }
        if (componentJar == null || container == null || classpathDirectory == null) {
            throw new NullPointerException("null arg!");
        }
        this.componentJar = componentJar;
        this.componentContainer = container;
        this.classpathDirectory = classpathDirectory;
        this.duDeployer = duDeployer;
        try {
            this.componentDescriptors = this.parseComponentDescriptors();
        }
        catch (Exception ex) {
            throw new DeploymentException("Failed to parse deployment descriptor of " + componentJar.getName(), (Throwable)ex);
        }
    }

    protected abstract List parseComponentDescriptors() throws Exception;

    protected void deployAndInstall(DeployableUnitIDImpl deployableUnitID) throws Exception {
        if (!this.preparedToDeploy) {
            throw new IllegalStateException("Failed, because the component has not been prepared to deploy.");
        }
        if (this.componentDescriptors == null || this.componentDescriptors.size() == 0) {
            return;
        }
        this.logger.info((Object)("Deploying and installing " + this.componentJar.getName()));
        this.logger.info((Object)("ClassPathDirectory " + this.classpathDirectory));
        Iterator descriptors = this.componentDescriptors.iterator();
        while (descriptors.hasNext()) {
            ComponentDescriptor cd = (ComponentDescriptor)descriptors.next();
            DeployedComponent deployedComponent = (DeployedComponent)cd;
            deployedComponent.setDeployableUnit(deployableUnitID);
            DeployableUnitDescriptorImpl duD = deployableUnitID.getDescriptor();
            if (cd instanceof SbbDescriptor) {
                SbbDescriptorImpl sbbD = (SbbDescriptorImpl)cd;
                UnifiedClassLoader cl = this.duDeployer.createDUClassLoader();
                sbbD.setClassLoader((ClassLoader)cl);
            }
            deployedComponent.checkDeployment();
            this.componentContainer.install(cd, duD);
            duD.addComponent(cd.getID());
        }
    }

    protected void prepareDeploy(DeployableUnitIDImpl deployableUnitID) throws Exception {
        this.preparedToDeploy = false;
        JarInputStream jarIs = new JarInputStream(new BufferedInputStream(new FileInputStream(this.componentJar.getName())));
        JarEntry entry = jarIs.getNextJarEntry();
        while (jarIs.available() > 0 && entry != null) {
            this.logger.debug((Object)("zipEntry = " + entry.getName()));
            if (entry.getName().indexOf("META-INF") == -1) {
                File dir;
                if (entry.isDirectory()) {
                    dir = new File(this.classpathDirectory, entry.getName());
                    if (!dir.exists()) {
                        if (!dir.mkdirs()) {
                            this.logger.debug((Object)("Failed to create directory " + dir.getAbsolutePath()));
                            throw new DeploymentException("Failed to create directory " + dir.getAbsolutePath());
                        }
                    } else {
                        this.logger.debug((Object)("Created directory" + dir.getAbsolutePath()));
                    }
                } else {
                    dir = new File(this.classpathDirectory, entry.getName()).getParentFile();
                    if (!dir.exists()) {
                        if (!dir.mkdirs()) {
                            this.logger.debug((Object)("Failed to create directory " + dir.getAbsolutePath()));
                            throw new DeploymentException("Failed to create directory " + dir.getAbsolutePath());
                        }
                        this.logger.debug((Object)("Created directory" + dir.getAbsolutePath()));
                    }
                    deployableUnitID.addEntry(entry.getName());
                    DeploymentManager.pipeStream(this.componentJar.getInputStream(entry), new FileOutputStream(new File(this.classpathDirectory, entry.getName())));
                }
            }
            entry = jarIs.getNextJarEntry();
        }
        jarIs.close();
        this.componentJar.close();
        this.preparedToDeploy = true;
    }

    protected static void undeploy(DeployableUnitIDImpl deployableUnitID) {
    }
}

