/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPath;
import javassist.ClassPool;
import javax.slee.SLEEException;
import javax.slee.management.AlreadyDeployedException;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;
import org.mobicents.slee.container.management.AbstractComponentDeployer;
import org.mobicents.slee.container.management.ComponentContainer;
import org.mobicents.slee.container.management.DeployableUnitDescriptorImpl;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.DeploymentManager;
import org.mobicents.slee.container.management.EventTypeComponentDeployer;
import org.mobicents.slee.container.management.ProfileSpecComponentDeployer;
import org.mobicents.slee.container.management.ResourceAdaptorComponentDeployer;
import org.mobicents.slee.container.management.ResourceAdaptorTypeComponentDeployer;
import org.mobicents.slee.container.management.SbbComponentDeployer;
import org.mobicents.slee.container.management.ServiceDeployer;
import org.mobicents.slee.container.management.xml.XMLException;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeployableUnitDeployer {
    private JarFile unitJarFile = null;
    private File tempDUJarsDeploymentDirectory = null;
    private File classpathDirectory = null;
    private ComponentContainer componentContainer = null;
    private DeployableUnitIDImpl deployableUnitID;
    private static int deployableUnitCounter;
    private File tempClassDeploymentDir;
    private URL sourceUrl;
    private static Logger logger;
    private ClassPath classPath = null;
    private UnifiedClassLoader classLoader;
    private static ClassPool classPool;
    private File tempDeploymentFile;
    private Collection simpleComponentsJarFiles;
    private Collection complexComponentsJarFiles;
    private HashSet extractedJars = new HashSet();

    DeployableUnitDeployer() {
        logger.debug((Object)("Creating DeployableUnitDeployer()" + this));
    }

    private void setDescriptor(DeployableUnitDescriptorImpl descriptor) {
        this.deployableUnitID = new DeployableUnitIDImpl(deployableUnitCounter++);
        this.deployableUnitID.setDescriptor(descriptor);
        descriptor.setDeployableUnit(this.deployableUnitID);
        descriptor.setTmpDUJarsDirectory(this.tempDUJarsDeploymentDirectory);
        descriptor.setTmpDeploymentDirectory(this.tempDeploymentFile);
    }

    public static synchronized DeployableUnitIDImpl deploy(URL sourceUrl, File deployableUnitJarFile, File deploymentDirectory, ComponentContainer container) throws DeploymentException {
        JarFile deployableUnitJar;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("jarFile = " + deployableUnitJarFile));
        }
        try {
            deployableUnitJar = new JarFile(deployableUnitJarFile);
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to open DU file as JAR file: " + deployableUnitJarFile, (Throwable)e);
        }
        DeployableUnitDeployer deployer = new DeployableUnitDeployer();
        if (sourceUrl == null || deployableUnitJar == null || deploymentDirectory == null || container == null) {
            throw new NullPointerException("null arg!");
        }
        deployer.setUnitJarFile(deployableUnitJar);
        deployer.setTempDUJarsDeploymentDirectory(deploymentDirectory);
        deployer.setComponentContainer(container);
        deployer.setSourceURL(sourceUrl);
        deployer.init();
        deployer.setDescriptor(new DeployableUnitDescriptorImpl(sourceUrl.toString(), new Date()));
        deployer.deployableUnitID.setSourceURL(sourceUrl);
        deployer.deployableUnitID.setSourceURI(deployableUnitJarFile.toURI());
        deployer.deployableUnitID.setDUDeployer(deployer);
        deployer.deployUnitContent();
        container.addDeployableUnit(deployer.deployableUnitID.getDescriptor());
        return deployer.deployableUnitID;
    }

    private void setSourceURL(URL sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public URL getSourceURL() {
        return this.sourceUrl;
    }

    void setUnitJarFile(JarFile duJar) {
        this.unitJarFile = duJar;
    }

    private void setTempDUJarsDeploymentDirectory(File deploymentDirectory) {
        this.tempDUJarsDeploymentDirectory = deploymentDirectory;
    }

    public void setComponentContainer(ComponentContainer componentContainer) {
        this.componentContainer = componentContainer;
    }

    JarFile getUnitJarFile() {
        return this.unitJarFile;
    }

    public File getTempDUJarsDeploymentDirectory() {
        return this.tempDUJarsDeploymentDirectory;
    }

    public ComponentContainer getComponentContainer() {
        return this.componentContainer;
    }

    public File getClasspathDirectory() {
        return this.tempClassDeploymentDir;
    }

    private void deployUnitContent() throws DeploymentException {
        boolean b = false;
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        try {
            b = transactionManager.requireTransaction();
            this.exploreDULib();
            this.parseDUDescriptor();
            this.prepareDUJars();
            this.prepareDeploy(this.simpleComponentsJarFiles);
            this.prepareDeploy(this.complexComponentsJarFiles);
            this.deferDeployForUnresolvedDependancies();
            this.loadDeployment(this.simpleComponentsJarFiles, this.complexComponentsJarFiles, this.extractedJars);
            this.retryDeployForResolvedDependancies();
        }
        catch (DeploymentException ex) {
            try {
                transactionManager.setRollbackOnly();
            }
            catch (Exception e) {
                throw new RuntimeException("Pb with Slee Transaction Manager", e);
            }
            throw ex;
        }
        finally {
            try {
                if (b) {
                    transactionManager.commit();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Pb with Slee Transaction Manager", e);
            }
        }
    }

    private void deferDeployForUnresolvedDependancies() {
    }

    private void retryDeployForResolvedDependancies() {
    }

    private void prepareDUJars() throws DeploymentException {
        ArrayList<String> jarNames = new ArrayList<String>();
        Iterator iter = this.getDescriptor().getJarNodes().iterator();
        this.complexComponentsJarFiles = new LinkedList();
        this.simpleComponentsJarFiles = new LinkedList();
        while (iter.hasNext()) {
            try {
                String jarName = XMLUtils.getElementTextValue((Element)iter.next());
                if (jarName.length() == 0 || !jarName.toLowerCase().endsWith("jar")) {
                    throw new DeploymentException(jarName + " is not a valid jar file name.");
                }
                if (jarNames.contains(jarName)) {
                    throw new DeploymentException("Encountered " + jarName + " more than once.");
                }
                File extractedJarFile = DeploymentManager.extractFile(jarName, this.unitJarFile, this.getTempDUJarsDeploymentDirectory());
                if (extractedJarFile == null) {
                    throw new DeploymentException("Error Extracting jar file:  " + jarName + " " + this.unitJarFile);
                }
                JarFile extractedJar = new JarFile(extractedJarFile);
                this.extractedJars.add(extractedJarFile);
                this.getDescriptor().addJar(jarName);
                jarNames.add(jarName);
                AbstractComponentDeployer deployer = this.createComponentDeployer(extractedJar);
                deployer.initDeployer(extractedJar, this.getComponentContainer(), this.getTempClassDeploymentDir(), this);
                if (deployer instanceof EventTypeComponentDeployer || deployer instanceof ProfileSpecComponentDeployer) {
                    this.simpleComponentsJarFiles.add(deployer);
                    continue;
                }
                this.complexComponentsJarFiles.add(deployer);
            }
            catch (AlreadyDeployedException ex) {
                try {
                    this.getComponentContainer().removeDU(this.getDescriptor());
                }
                catch (Exception e) {
                    logger.error((Object)"Problem undeploying partial deployment", (Throwable)e);
                }
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                try {
                    this.getComponentContainer().removeDU(this.getDescriptor());
                }
                catch (Exception e) {
                    logger.error((Object)"Problem undeploying partial deployment", (Throwable)e);
                }
                String s = ex.getMessage();
                logger.error((Object)s, (Throwable)ex);
                throw new DeploymentException(s, (Throwable)ex);
            }
        }
    }

    private void parseDUDescriptor() throws DeploymentException {
        JarEntry duXmlEntry = this.unitJarFile.getJarEntry("META-INF/deployable-unit.xml");
        if (duXmlEntry == null) {
            throw new DeploymentException("No DeployableUniDeploymentDescriptor descriptor (META-INF/deployable-unit.xml) was found in deployable unit" + this.unitJarFile.getName());
        }
        Document doc = null;
        try {
            doc = XMLUtils.parseDocument(this.unitJarFile.getInputStream(duXmlEntry), false);
        }
        catch (IOException ex) {
            throw new DeploymentException("Failed to extract the DU depl descriptor from " + this.unitJarFile.getName());
        }
        Element duNode = doc.getDocumentElement();
        DeployableUnitDescriptorImpl deployableUnitDescriptor = this.getDescriptor();
        try {
            String description = XMLUtils.getElementTextValue(duNode, "description");
            if (description != null) {
                deployableUnitDescriptor.setDescription(description);
            }
        }
        catch (XMLException ex) {
            throw new DeploymentException(ex.getMessage());
        }
        List jarNodes = XMLUtils.getAllChildElements(duNode, "jar");
        deployableUnitDescriptor.setJarNodes(jarNodes);
        List serviceNodes = XMLUtils.getAllChildElements(duNode, "service-xml");
        deployableUnitDescriptor.setServiceNodes(serviceNodes);
        if (jarNodes.size() == 0 && serviceNodes.size() == 0) {
            throw new DeploymentException("The " + this.unitJarFile.getName() + " deployable unit contains no jars or services");
        }
    }

    private DeployableUnitDescriptorImpl getDescriptor() {
        return this.deployableUnitID.getDescriptor();
    }

    private void exploreDULib() throws DeploymentException {
        Enumeration<JarEntry> entries = this.unitJarFile.entries();
        try {
            JarEntry entry = entries.nextElement();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.getName().indexOf("library") == -1 || entry.getName().indexOf("jar") == -1 || entry.isDirectory()) continue;
                File f = DeploymentManager.extractFile(entry.getName(), this.unitJarFile, this.getClasspathDirectory());
                DeploymentManager.extractJar(new JarFile(f), this.getClasspathDirectory());
            }
        }
        catch (IOException ex) {
            throw new DeploymentException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void loadDeployment(Collection simpleCompJarFiles, Collection complexCompJarFiles, HashSet extractedJars) throws DeploymentException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        this.classLoader = this.createDUClassLoader();
        try {
            this.classPath = classPool.appendClassPath(this.getTempClassDeploymentDir().getAbsolutePath());
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            Iterator iter = simpleCompJarFiles.iterator();
            while (iter.hasNext()) {
                AbstractComponentDeployer deployer = (AbstractComponentDeployer)iter.next();
                deployer.deployAndInstall(this.deployableUnitID);
            }
            this.loadDeployedComponents(complexCompJarFiles, extractedJars);
        }
        catch (AlreadyDeployedException ex) {
            String s = "Could not deploy deploybableUnitID = " + this.deployableUnitID;
            try {
                this.componentContainer.removeDU(this.deployableUnitID.getDescriptor());
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            throw ex;
        }
        catch (DeploymentException ex) {
            String s = "Could not deploy deploybableUnitID = " + this.deployableUnitID;
            try {
                this.componentContainer.removeDU(this.deployableUnitID.getDescriptor());
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            throw ex;
        }
        catch (Exception ex) {
            String s = "Could not deploy deploybableUnitID = " + this.deployableUnitID;
            try {
                this.componentContainer.removeDU(this.deployableUnitID.getDescriptor());
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            classPool.removeClassPath(this.classPath);
            throw new DeploymentException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void loadDeployedComponents(Collection jarFiles, HashSet extractedJars) throws DeploymentException {
        Iterator iter = jarFiles.iterator();
        while (iter.hasNext()) {
            try {
                AbstractComponentDeployer deployer = (AbstractComponentDeployer)iter.next();
                deployer.deployAndInstall(this.deployableUnitID);
            }
            catch (AlreadyDeployedException ex) {
                ex.printStackTrace();
                try {
                    this.undeploy();
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
                throw ex;
            }
            catch (DeploymentException ex) {
                ex.printStackTrace();
                try {
                    this.componentContainer.removeDU(this.deployableUnitID.getDescriptor());
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    this.componentContainer.removeDU(this.deployableUnitID.getDescriptor());
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
                throw new DeploymentException(ex.getMessage(), (Throwable)ex);
            }
        }
        ArrayList serviceNames = new ArrayList();
        iter = this.getDescriptor().getServiceNodes().iterator();
        while (iter.hasNext()) {
            try {
                String serviceXmlName = XMLUtils.getElementTextValue((Element)iter.next());
                logger.info((Object)("serviceName = " + serviceXmlName));
                if (serviceXmlName.length() == 0 || !serviceXmlName.toLowerCase().endsWith("xml")) {
                    throw new DeploymentException(serviceXmlName + " is not a valid service-xml file name.");
                }
                if (serviceNames.contains(serviceXmlName)) {
                    throw new DeploymentException("Encountered " + serviceXmlName + " more than once.");
                }
                File serviceXmlFile = DeploymentManager.extractFile(serviceXmlName, this.unitJarFile, this.getTempDUJarsDeploymentDirectory());
                ServiceDeployer deployer = new ServiceDeployer();
                deployer.initDeployer(serviceXmlFile, this.getComponentContainer());
                deployer.deployAndInstall(this.deployableUnitID);
                serviceXmlFile.delete();
            }
            catch (Exception ex) {
                try {
                    this.getComponentContainer().removeDU(this.deployableUnitID.getDescriptor());
                }
                catch (Exception e) {
                    logger.error((Object)"Error unistalling partial deployment", (Throwable)e);
                }
                throw new DeploymentException(ex.getMessage(), (Throwable)ex);
            }
        }
        Iterator it = extractedJars.iterator();
        while (it.hasNext()) {
            File fname = (File)it.next();
            logger.debug((Object)("trying to delete file " + fname.getName()));
            fname.delete();
        }
    }

    private void prepareDeploy(Collection compJarFiles) throws DeploymentException {
        DeployableUnitDescriptorImpl deployableUnitDescriptor = this.deployableUnitID.getDescriptor();
        Iterator iter = compJarFiles.iterator();
        while (iter.hasNext()) {
            try {
                AbstractComponentDeployer deployer = (AbstractComponentDeployer)iter.next();
                deployer.prepareDeploy(this.deployableUnitID);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    this.componentContainer.removeDU(deployableUnitDescriptor);
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
                throw new DeploymentException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected UnifiedClassLoader createDUClassLoader() throws DeploymentException {
        try {
            UnifiedClassLoader ucl = (UnifiedClassLoader)Thread.currentThread().getContextClassLoader();
            UnifiedLoaderRepository3 lr = (UnifiedLoaderRepository3)ucl.getLoaderRepository();
            UnifiedClassLoader cl = lr.newClassLoader(this.getTempClassDeploymentDir().toURL(), new File(this.getUnitJarFile().getName()).toURL(), true);
            return cl;
        }
        catch (MalformedURLException e1) {
            throw new DeploymentException("Bad ULR for tempClassDeploymentDir: " + this.getTempClassDeploymentDir());
        }
        catch (Exception e) {
            throw new DeploymentException("Failed Creating ClassLoader for tempClassDeploymentDir: " + this.getTempClassDeploymentDir());
        }
    }

    private static JarFile extractJar(String fileName, JarFile containingJar, File dstDir) throws IOException {
        return new JarFile(DeploymentManager.extractFile(fileName, containingJar, dstDir));
    }

    private AbstractComponentDeployer createComponentDeployer(JarFile componentJarFile) throws DeploymentException {
        JarEntry descriptorXML = null;
        AbstractComponentDeployer deployer = null;
        descriptorXML = componentJarFile.getJarEntry("META-INF/sbb-jar.xml");
        if (descriptorXML != null) {
            deployer = new SbbComponentDeployer(this.deployableUnitID, descriptorXML);
        } else {
            descriptorXML = componentJarFile.getJarEntry("META-INF/profile-spec-jar.xml");
            if (descriptorXML != null) {
                deployer = new ProfileSpecComponentDeployer(this.deployableUnitID, descriptorXML);
            } else {
                descriptorXML = componentJarFile.getJarEntry("META-INF/event-jar.xml");
                if (descriptorXML != null) {
                    deployer = new EventTypeComponentDeployer(this.deployableUnitID, descriptorXML);
                } else {
                    descriptorXML = componentJarFile.getJarEntry("META-INF/resource-adaptor-type-jar.xml");
                    if (descriptorXML != null) {
                        deployer = new ResourceAdaptorTypeComponentDeployer(this.deployableUnitID, descriptorXML);
                    } else {
                        descriptorXML = componentJarFile.getJarEntry("META-INF/resource-adaptor-jar.xml");
                        if (descriptorXML != null) {
                            deployer = new ResourceAdaptorComponentDeployer(this.deployableUnitID, descriptorXML);
                        } else {
                            throw new DeploymentException("No Deployment Descriptor found in the " + componentJarFile.getName() + " entry of a deployable unit.");
                        }
                    }
                }
            }
        }
        return deployer;
    }

    private void createTempDeploymentDir() {
        boolean dirCreated;
        String jarName = new File(this.getUnitJarFile().getName()).getName();
        ServerConfig config = ServerConfigLocator.locate();
        File basedir = config.getServerTempDir();
        logger.debug((Object)("createTempDeploymentDir(): basedir = " + basedir));
        File tempDeploymentRootDir = new File(basedir, "deploy");
        if (!tempDeploymentRootDir.exists() && !(dirCreated = tempDeploymentRootDir.mkdirs())) {
            throw new SLEEException("failed to create temp deployment dir: " + tempDeploymentRootDir);
        }
        try {
            this.tempDeploymentFile = File.createTempFile("tmpDUJarsUnpackaged", "", tempDeploymentRootDir);
            this.tempClassDeploymentDir = new File(this.tempDeploymentFile.getAbsolutePath() + "-contents");
            if (!this.tempClassDeploymentDir.exists()) {
                this.tempClassDeploymentDir.mkdirs();
            }
        }
        catch (IOException e) {
            logger.error((Object)("Temp Deployment Directory could not be created for SLEE DU: " + jarName), (Throwable)e);
            throw new SLEEException("Failed to create temp deployment dir", (Throwable)e);
        }
    }

    public File getTempClassDeploymentDir() {
        return this.tempClassDeploymentDir;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassPool getClassPool() {
        return classPool;
    }

    private void init() {
        this.createTempDeploymentDir();
    }

    public void undeploy() {
        logger.debug((Object)("undeploy() " + this));
        if (this.classLoader != null) {
            this.classLoader.unregister();
        }
        if (classPool != null && this.classPath != null) {
            classPool.removeClassPath(this.classPath);
        }
    }

    static {
        classPool = ConcreteClassGeneratorUtils.createClassPool();
        logger = Logger.getLogger((Class)DeployableUnitDeployer.class);
    }
}

