/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.AbstractComponentDeployer;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.EventTypeDeploymentDescriptorParser;
import org.mobicents.slee.container.management.EventTypeDescriptorImpl;
import org.mobicents.slee.container.management.xml.XMLException;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class EventTypeComponentDeployer
extends AbstractComponentDeployer {
    private static Logger logger = Logger.getLogger((Class)EventTypeComponentDeployer.class);
    private EventTypeDeploymentDescriptorParser parser;
    private DeployableUnitIDImpl deployableUnitID;
    private JarEntry ddXmlEntry;

    public EventTypeComponentDeployer(DeployableUnitIDImpl deployableUnitID, JarEntry ddXmlEntry) {
        if (deployableUnitID == null) {
            throw new NullPointerException("null deployable unit!");
        }
        this.parser = new EventTypeDeploymentDescriptorParser();
        this.deployableUnitID = deployableUnitID;
        this.ddXmlEntry = ddXmlEntry;
    }

    protected List parseComponentDescriptors() throws DeploymentException {
        LinkedList<EventTypeDescriptorImpl> retval = new LinkedList<EventTypeDescriptorImpl>();
        logger.debug((Object)("parsing event-jar from " + this.getJar().getName()));
        JarFile jar = this.getJar();
        Document doc = null;
        try {
            doc = XMLUtils.parseDocument(jar.getInputStream(this.ddXmlEntry), true);
        }
        catch (IOException ex) {
            throw new DeploymentException("Failed to extract the SBB deployment descriptor from " + jar.getName());
        }
        Element docElement = doc.getDocumentElement();
        try {
            String description = XMLUtils.getElementTextValue(docElement, "description");
            this.deployableUnitID.setDescription(description);
        }
        catch (XMLException e) {
            e.printStackTrace();
        }
        List nodes = XMLUtils.getAllChildElements(docElement, "event-definition");
        for (int i = 0; i < nodes.size(); ++i) {
            EventTypeDescriptorImpl descriptorImpl = new EventTypeDescriptorImpl();
            Element eventDefinitionNode = (Element)nodes.get(i);
            try {
                this.parser.parse(eventDefinitionNode, descriptorImpl);
            }
            catch (XMLException e2) {
                throw new DeploymentException("Error Parsing Event file " + jar.getName(), (Throwable)e2);
            }
            descriptorImpl.setDeployableUnit(this.deployableUnitID);
            retval.add(descriptorImpl);
        }
        return retval;
    }

    protected void checkDeployment() throws Exception {
    }
}

