/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.AbstractDeploymentDescriptorParser;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.EJBReference;
import org.mobicents.slee.container.management.SbbDescriptorImpl;
import org.mobicents.slee.container.management.SbbIDImpl;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Element;

public class MCSbbDeploymentDescriptorParser
extends AbstractDeploymentDescriptorParser {
    private static Logger log = Logger.getLogger((Class)MCSbbDeploymentDescriptorParser.class);

    public void parseSbbComponent(Element sbbNode, Map descriptors) throws IOException, Exception {
        log.debug((Object)"Parsing mobicents-sbb-jar.xml");
        ComponentKey sbbKey = this.createKey(sbbNode);
        SbbIDImpl sbbId = new SbbIDImpl(sbbKey);
        SbbDescriptorImpl descriptor = (SbbDescriptorImpl)descriptors.get(sbbId);
        if (descriptor == null) {
            throw new DeploymentException("sbb with id:" + sbbId + " in mobicents-sbb-jar.xml but not in sbb-jar.xml");
        }
        List ejbRefNodeList = XMLUtils.getAllChildElements(sbbNode, "ejb-ref");
        HashSet ejbRefs = new HashSet();
        Iterator iter = ejbRefNodeList.iterator();
        while (iter.hasNext()) {
            Element ejbRefNode = (Element)iter.next();
            String ejbRefName = XMLUtils.getElementTextValue(ejbRefNode, "ejb-ref-name");
            String jndiName = XMLUtils.getElementTextValue(ejbRefNode, "jndi-name");
            log.debug((Object)("Number of ejb-refs:" + descriptor.getEjbRefs().size()));
            Iterator iter2 = descriptor.getEjbRefs().iterator();
            boolean found = false;
            while (iter2.hasNext()) {
                EJBReference ejbRef = (EJBReference)iter2.next();
                log.debug((Object)("ejbrefname is: " + ejbRef.getEjbRefName()));
                if (!ejbRef.getEjbRefName().equals(ejbRefName)) continue;
                ejbRef.setJndiName(jndiName);
                found = true;
                break;
            }
            if (found) continue;
            throw new DeploymentException("ejb-ref with name " + ejbRefName + " found in mobicents-sbb-jar.xml but not found in sbb-jar.xml");
        }
    }
}

