/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.slee.ComponentID;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Log4jLoggerPlugin;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.AbstractComponentDeployer;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.DeploymentManager;
import org.mobicents.slee.container.management.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.management.ProfileSpecificationDescriptorParser;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ProfileSpecComponentDeployer
extends AbstractComponentDeployer {
    private Logger logger;
    private String deploymentDirectory;
    private static byte[] buffer = new byte[8192];
    private ProfileSpecificationDescriptorParser parser;
    private DeployableUnitIDImpl deployableUnitID;
    private JarEntry ddXmlEntry;

    public ProfileSpecComponentDeployer(DeployableUnitIDImpl deployableUnitID, JarEntry ddXmlEntry) {
        Logger.setPluginClassName((String)Log4jLoggerPlugin.class.getName());
        this.logger = Logger.getLogger((Class)DeploymentManager.class);
        this.deployableUnitID = deployableUnitID;
        this.ddXmlEntry = ddXmlEntry;
        this.parser = new ProfileSpecificationDescriptorParser();
    }

    protected List parseComponentDescriptors() throws Exception {
        this.logger.debug((Object)("Parsing a Profile Spec from " + this.getJar().getName()));
        JarFile jar = this.getJar();
        if (this.ddXmlEntry == null) {
            throw new DeploymentException("No ProfileSpecificationDescriptor descriptor (META-INF/profile-spec-jar.xml) was found in " + jar.getName());
        }
        Document doc = null;
        try {
            doc = XMLUtils.parseDocument(jar.getInputStream(this.ddXmlEntry), true);
        }
        catch (IOException ex) {
            throw new DeploymentException("Failed to extract the Profile Specification descriptor from " + jar.getName());
        }
        Element profileJarNode = doc.getDocumentElement();
        List profileSpecNodes = XMLUtils.getAllChildElements(profileJarNode, "profile-spec");
        if (profileSpecNodes.size() == 0) {
            throw new DeploymentException("The " + jar.getName() + " deployment descriptor contains no profile-spec definitions");
        }
        HashMap<ComponentID, ProfileSpecificationDescriptorImpl> descriptors = new HashMap<ComponentID, ProfileSpecificationDescriptorImpl>();
        for (int i = profileSpecNodes.size() - 1; i >= 0; --i) {
            Element profileSpecNode = (Element)profileSpecNodes.get(i);
            ProfileSpecificationDescriptorImpl descriptor = this.parser.parseProfileComponent(profileSpecNode, new ProfileSpecificationDescriptorImpl());
            descriptor.setDeployableUnit(this.deployableUnitID);
            descriptors.put(descriptor.getID(), descriptor);
        }
        this.logger.debug((Object)"Done.");
        return new ArrayList(descriptors.values());
    }
}

