/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;
import org.jboss.logging.Log4jLoggerPlugin;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.management.ProfileSpecificationDescriptorParser;
import org.mobicents.slee.container.management.xml.XMLDescriptorStringsFixture;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ProfileSpecificationDescriptorParserTest
extends TestCase {
    private ProfileSpecificationDescriptorParser profileSpecificationDescriptorParser;
    private Document profileJarDocument;
    private Element profileNode;
    private ProfileSpecificationDescriptorImpl profileSpecificationDescriptorImpl;
    private static Logger logger = Logger.getLogger((Class)ProfileSpecificationDescriptorParserTest.class);

    protected void setUp() throws Exception {
        super.setUp();
        BasicConfigurator.configure();
        Logger.setPluginClassName((String)Log4jLoggerPlugin.class.getName());
        this.profileSpecificationDescriptorParser = new ProfileSpecificationDescriptorParser();
        InputSource profileJarSource = new InputSource(new StringReader(XMLDescriptorStringsFixture.PROFILE_SPECIFICATION_XML));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.profileJarDocument = builder.parse(profileJarSource);
        List profileNodes = XMLUtils.getAllChildElements(this.profileJarDocument.getDocumentElement(), "profile-spec");
        this.profileNode = (Element)profileNodes.get(0);
        this.profileSpecificationDescriptorImpl = new ProfileSpecificationDescriptorImpl();
    }

    protected void tearDown() throws Exception {
        this.profileSpecificationDescriptorParser = null;
        super.tearDown();
    }

    public ProfileSpecificationDescriptorParserTest(String arg0) {
        super(arg0);
    }

    public void testParseProfileComponent() throws IOException, Exception {
        this.profileSpecificationDescriptorImpl = this.profileSpecificationDescriptorParser.parseProfileComponent(this.profileNode, this.profileSpecificationDescriptorImpl);
        ProfileSpecificationDescriptorParserTest.assertEquals((String)"failed", (String)this.profileSpecificationDescriptorImpl.getName(), (String)"AddressProfileSpec");
        ProfileSpecificationDescriptorParserTest.assertEquals((String)"failed", (String)this.profileSpecificationDescriptorImpl.getVendor(), (String)"javax.slee");
        ProfileSpecificationDescriptorParserTest.assertEquals((String)"failed", (String)this.profileSpecificationDescriptorImpl.getVersion(), (String)"1.0");
        ProfileSpecificationDescriptorParserTest.assertEquals((String)"failed", (String)this.profileSpecificationDescriptorImpl.getCMPInterfaceName(), (String)"javax.slee.profile.AddressProfileCMP");
        Map profileIndexes = this.profileSpecificationDescriptorImpl.getProfileIndexes();
        Boolean isUnique = (Boolean)profileIndexes.get("addresses");
        ProfileSpecificationDescriptorParserTest.assertNotNull((String)"failed", (Object)isUnique);
        ProfileSpecificationDescriptorParserTest.assertTrue((boolean)isUnique);
        logger.info((Object)"testParseProfileComponent Passed");
    }
}

