/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.AbstractComponentDeployer;
import org.mobicents.slee.container.management.DeployableUnitDescriptorImpl;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.EventTypeComponentDeployer;
import org.mobicents.slee.container.management.ResourceAdaptorDescriptorParser;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.mobicents.slee.resource.ResourceAdaptorDescriptorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ResourceAdaptorComponentDeployer
extends AbstractComponentDeployer {
    private static Logger logger = Logger.getLogger((Class)EventTypeComponentDeployer.class);
    private ResourceAdaptorDescriptorParser parser = new ResourceAdaptorDescriptorParser();
    private DeployableUnitIDImpl deployableUnitID;
    private JarEntry ddXmlEntry;
    private DeployableUnitDescriptorImpl duDescriptor;

    public ResourceAdaptorComponentDeployer(DeployableUnitIDImpl deployableUnitID, JarEntry ddXmlEntry) {
        this.deployableUnitID = deployableUnitID;
        this.ddXmlEntry = ddXmlEntry;
        this.duDescriptor = deployableUnitID.getDescriptor();
    }

    protected List parseComponentDescriptors() throws Exception {
        logger.debug((Object)("Parsing an RA Jar from " + this.getJar().getName()));
        JarFile jar = this.getJar();
        if (this.ddXmlEntry == null) {
            throw new DeploymentException("No SbbDeploymentDescriptor descriptor (META-INF/resource-adaptor-jar.xml) was found in " + jar.getName());
        }
        Document doc = null;
        try {
            doc = XMLUtils.parseDocument(jar.getInputStream(this.ddXmlEntry), true);
        }
        catch (IOException ex) {
            throw new DeploymentException("Failed to extract the SBB deployment descriptor from " + jar.getName());
        }
        Element raJarNode = doc.getDocumentElement();
        ArrayList<ResourceAdaptorDescriptorImpl> retval = new ArrayList<ResourceAdaptorDescriptorImpl>();
        Iterator it = XMLUtils.getAllChildElements(doc.getDocumentElement(), "resource-adaptor").iterator();
        while (it.hasNext()) {
            Element raNode = (Element)it.next();
            ResourceAdaptorDescriptorImpl raDescriptor = new ResourceAdaptorDescriptorImpl();
            this.parser.parseResourceAdaptorDescriptor(raNode, raDescriptor);
            raDescriptor.setDeployableUnitID(this.deployableUnitID);
            retval.add(raDescriptor);
        }
        return retval;
    }
}

