/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.util.TypeUtils;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.AbstractDeploymentDescriptorParser;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.ResourceAdaptorIDImpl;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.mobicents.slee.resource.ConfigPropertyDescriptor;
import org.mobicents.slee.resource.RAClassesEntry;
import org.mobicents.slee.resource.ResourceAdaptorDescriptorImpl;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.w3c.dom.Element;

public class ResourceAdaptorDescriptorParser
extends AbstractDeploymentDescriptorParser {
    private static Logger logger = Logger.getLogger((Class)ResourceAdaptorDescriptorParser.class);

    public ResourceAdaptorDescriptorImpl parseResourceAdaptorDescriptor(Element topLevel, ResourceAdaptorDescriptorImpl raDescriptor) throws Exception {
        logger.debug((Object)"Enter parseResourceAdaptorDescriptor");
        String description = XMLUtils.getElementTextValue(topLevel, "description");
        raDescriptor.setDescription(description);
        String name = XMLUtils.getElementTextValue(topLevel, "resource-adaptor-name");
        String vendor = XMLUtils.getElementTextValue(topLevel, "resource-adaptor-vendor");
        String version = XMLUtils.getElementTextValue(topLevel, "resource-adaptor-version");
        ResourceAdaptorIDImpl resourceAdaptorID = new ResourceAdaptorIDImpl(new ComponentKey(name, vendor, version));
        raDescriptor.setID(resourceAdaptorID);
        Element typerefNd = XMLUtils.getChildElement(topLevel, "resource-adaptor-type-ref");
        String typeDesc = XMLUtils.getElementTextValue(typerefNd, "description");
        String typeVersion = XMLUtils.getElementTextValue(typerefNd, "resource-adaptor-type-version");
        String typeName = XMLUtils.getElementTextValue(typerefNd, "resource-adaptor-type-name");
        String typeVendor = XMLUtils.getElementTextValue(typerefNd, "resource-adaptor-type-vendor");
        ResourceAdaptorTypeIDImpl raTypeID = new ResourceAdaptorTypeIDImpl(new ComponentKey(typeName, typeVendor, typeVersion));
        raTypeID.setDescription(typeDesc);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("raTypeID = " + raTypeID));
        }
        raDescriptor.setResourceAdaptorType(raTypeID);
        Iterator it1 = XMLUtils.getAllChildElements(topLevel, "resource-adaptor-classes").iterator();
        while (it1.hasNext()) {
            Element raClassNode = (Element)it1.next();
            Element raClass = XMLUtils.getChildElement(raClassNode, "resource-adaptor-class");
            Element raClassName = XMLUtils.getChildElement(raClass, "resource-adaptor-class-name");
            String raClassNameStr = XMLUtils.getElementTextValue(raClassName);
            RAClassesEntry raClassEntry = new RAClassesEntry(raClassNameStr);
            raDescriptor.setResourceAdaptorClasses(raClassEntry);
        }
        logger.debug((Object)"Parsing configuration properties");
        List props = XMLUtils.getAllChildElements(topLevel, "config-property");
        Iterator list = props.iterator();
        while (list.hasNext()) {
            Element configPropertyElement = (Element)list.next();
            Element configPropertyNameElement = XMLUtils.getChildElement(configPropertyElement, "config-property-name");
            Element configPropertyTypeElement = XMLUtils.getChildElement(configPropertyElement, "config-property-type");
            Element configPropertyValueElement = XMLUtils.getChildElement(configPropertyElement, "config-property-value");
            String propName = XMLUtils.getElementTextValue(configPropertyNameElement);
            String propType = XMLUtils.getElementTextValue(configPropertyTypeElement);
            String lexicalValue = XMLUtils.getElementTextValue(configPropertyValueElement);
            this.getClass();
            Class<?> clazz = Class.forName(propType);
            Object value = TypeUtils.convert((Object)lexicalValue, clazz);
            ConfigPropertyDescriptor configProperty = new ConfigPropertyDescriptor(propName, propType, value);
            raDescriptor.add(configProperty);
            logger.debug((Object)("Append to descriptor: " + configProperty));
        }
        return raDescriptor;
    }
}

