/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.slee.ComponentID;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.AbstractComponentDeployer;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.MCSbbDeploymentDescriptorParser;
import org.mobicents.slee.container.management.SbbDeploymentDescriptorParser;
import org.mobicents.slee.container.management.SbbDescriptorImpl;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class SbbComponentDeployer
extends AbstractComponentDeployer {
    private static Logger logger = Logger.getLogger((Class)SbbComponentDeployer.class);
    private SbbDeploymentDescriptorParser parser;
    private MCSbbDeploymentDescriptorParser mobicentsParser;
    private DeployableUnitIDImpl deployableUnitID;
    private JarEntry ddXmlEntry;

    public SbbComponentDeployer(DeployableUnitIDImpl deployableUnitID, JarEntry ddXmlEntry) {
        this.deployableUnitID = deployableUnitID;
        this.ddXmlEntry = ddXmlEntry;
        this.parser = new SbbDeploymentDescriptorParser();
        this.mobicentsParser = new MCSbbDeploymentDescriptorParser();
    }

    protected List parseComponentDescriptors() throws Exception {
        Element sbbNode;
        int i;
        logger.debug((Object)("Parsing an SBB from " + this.getJar().getName()));
        JarFile jar = this.getJar();
        if (this.ddXmlEntry == null) {
            throw new DeploymentException("No SbbDeploymentDescriptor descriptor (META-INF/sbb-jar.xml) was found in " + jar.getName());
        }
        Document doc = null;
        try {
            doc = XMLUtils.parseDocument(jar.getInputStream(this.ddXmlEntry), true);
        }
        catch (IOException ex) {
            throw new DeploymentException("Failed to extract the SBB deployment descriptor from " + jar.getName());
        }
        Element sbbJarNode = doc.getDocumentElement();
        List sbbNodes = XMLUtils.getAllChildElements(sbbJarNode, "sbb");
        if (sbbNodes.size() == 0) {
            throw new DeploymentException("The " + jar.getName() + " deployment descriptor contains no sbb definitions");
        }
        JarEntry ddMobicentsXmlEntry = jar.getJarEntry("META-INF/mobicents-sbb-jar.xml");
        List sbbMobicentsNodes = null;
        if (ddMobicentsXmlEntry != null) {
            logger.debug((Object)"Parsing mobicents-sbb-jar.xml");
            Document docMobicents = null;
            try {
                docMobicents = XMLUtils.parseDocument(jar.getInputStream(ddMobicentsXmlEntry), true);
            }
            catch (IOException ex) {
                throw new DeploymentException("Failed to extract the Mobicents SBB deployment descriptor from " + jar.getName());
            }
            Element sbbMobicentsJarNode = docMobicents.getDocumentElement();
            sbbMobicentsNodes = XMLUtils.getAllChildElements(sbbMobicentsJarNode, "sbb");
            if (sbbMobicentsNodes.size() == 0) {
                throw new DeploymentException("The " + jar.getName() + " mobicents deployment descriptor contains no sbb definitions");
            }
        }
        HashMap<ComponentID, SbbDescriptorImpl> descriptors = new HashMap<ComponentID, SbbDescriptorImpl>();
        for (i = sbbNodes.size() - 1; i >= 0; --i) {
            sbbNode = (Element)sbbNodes.get(i);
            SbbDescriptorImpl descriptor = this.parser.parseSbbComponent(sbbNode, new SbbDescriptorImpl());
            descriptor.setSource(this.getJar().getName());
            descriptors.put(descriptor.getID(), descriptor);
        }
        if (sbbMobicentsNodes != null) {
            logger.debug((Object)"Parsing sbb elements from mobicents-sbb-jar.xml");
            for (i = sbbMobicentsNodes.size() - 1; i >= 0; --i) {
                sbbNode = (Element)sbbMobicentsNodes.get(i);
                this.mobicentsParser.parseSbbComponent(sbbNode, descriptors);
            }
        }
        logger.debug((Object)"Done.");
        return new ArrayList(descriptors.values());
    }
}

