/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.Serializable;
import org.mobicents.slee.container.management.ComponentKey;

public class SbbEventEntry
implements Serializable {
    public static final int RECEIVED = 1;
    public static final int FIRED = 2;
    public static final int FIRED_AND_RECEIVED = 3;
    public static final int INITIAL = 4;
    private int eventDirection;
    public static final int ACTIVITY_CONTEXT_INITIAL_EVENT_SELECT = 1;
    public static final int ADDRESS_PROFILE_INITIAL_EVENT_SELECT = 2;
    public static final int ADDRESS_INITIAL_EVENT_SELECT = 3;
    public static final int EVENT_TYPE_INITIAL_EVENT_SELECT = 4;
    public static final int EVENT_INITIAL_EVENT_SELECT = 5;
    private String typeName = null;
    private String initialEventSelectorMethod = null;
    private String eventName = null;
    private String resourceOption = null;
    private ComponentKey eventTypeRefKey = null;
    private boolean maskedEvent;
    private int[] initialEventSelectors;

    public SbbEventEntry(ComponentKey eventTypeRefKey, int direction) {
        this.setEventTypeRefKey(eventTypeRefKey);
        this.eventDirection = direction;
    }

    public static int eventSelectVarToInt(String eventSelectVar) {
        if (eventSelectVar == null) {
            throw new NullPointerException("<null> is not a legal event select variable.");
        }
        if (eventSelectVar.equals("ActivityContext")) {
            return 1;
        }
        if (eventSelectVar.equals("AddressProfile")) {
            return 2;
        }
        if (eventSelectVar.equals("Address")) {
            return 3;
        }
        if (eventSelectVar.equals("EventType")) {
            return 4;
        }
        if (eventSelectVar.equals("Event")) {
            return 5;
        }
        throw new IllegalArgumentException(eventSelectVar + " is not a legal event select variable.");
    }

    public String toString() {
        return this.eventName + " Event Direction = " + this.eventDirection;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isInitial() {
        return (this.eventDirection & 4) != 0;
    }

    public boolean isReceived() {
        return (this.eventDirection & 1) != 0;
    }

    public boolean isFired() {
        return (this.eventDirection & 2) != 0;
    }

    public boolean isFiredAndReceived() {
        return (this.eventDirection & 3) != 0;
    }

    public int getEventDirection() {
        return this.eventDirection;
    }

    public boolean isMasked() {
        return this.maskedEvent;
    }

    public void maskEvent() {
        this.maskedEvent = true;
    }

    protected void setInitial(boolean flag) {
        this.eventDirection = flag ? (this.eventDirection |= 4) : (this.eventDirection &= 0xFFFFFFFB);
    }

    protected void setReceived(boolean flag) {
        this.eventDirection = flag ? (this.eventDirection |= 1) : (this.eventDirection &= 0xFFFFFFFE);
    }

    protected void setFired(boolean flag) {
        this.eventDirection = flag ? (this.eventDirection |= 2) : (this.eventDirection &= 0xFFFFFFFD);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        SbbEventEntry that = (SbbEventEntry)other;
        return that.typeName.equals(this.typeName) && that.eventDirection == this.eventDirection;
    }

    public void setInitialEventSelectors(int[] initialEventSelectors) {
        this.initialEventSelectors = initialEventSelectors;
    }

    public int[] getInitialEventSelectors() {
        return this.initialEventSelectors;
    }

    protected void setResourceOption(String resourceOption) {
        this.resourceOption = resourceOption;
    }

    public String getResourceOption() {
        return this.resourceOption;
    }

    protected void setEventTypeRefKey(ComponentKey eventTypeRefKey) {
        this.eventTypeRefKey = eventTypeRefKey;
    }

    public ComponentKey getEventTypeRefKey() {
        return this.eventTypeRefKey;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getInitialEventSelectorMethod() {
        return this.initialEventSelectorMethod;
    }

    protected void setInitialEventSelectorMethod(String initialEventSelectorMethod) {
        this.initialEventSelectorMethod = initialEventSelectorMethod;
    }
}

