/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import org.mobicents.slee.container.management.AbstractDeploymentDescriptorParser;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.SbbIDImpl;
import org.mobicents.slee.container.management.ServiceDescriptorImpl;
import org.mobicents.slee.container.management.ServiceIDImpl;
import org.mobicents.slee.container.management.xml.XMLException;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Element;

public class ServiceDeploymentDescriptorParser
extends AbstractDeploymentDescriptorParser {
    public ServiceDescriptorImpl parseServiceComponent(Element serviceNode, ServiceDescriptorImpl descriptorImpl) throws XMLException {
        ComponentKey serviceKey = this.createKey(serviceNode);
        Element rootSbbNode = XMLUtils.getChildElement(serviceNode, "root-sbb");
        ComponentKey rootSbb = this.createKey(rootSbbNode, "sbb");
        String priority = XMLUtils.getElementTextValue(serviceNode, "default-priority");
        byte defaultPriority = 0;
        try {
            defaultPriority = Byte.parseByte(priority);
        }
        catch (NumberFormatException nfe) {
            throw new XMLException("Default priority value of service must be between -128 and 127 (inclusive): " + priority + " see section(8.5.7)", nfe);
        }
        String addressProfileTable = XMLUtils.getElementTextValue(serviceNode, "address-profile-table");
        this.assertNonZeroLength(addressProfileTable, "address-profile-table");
        String resourceInfoProfileTable = XMLUtils.getElementTextValue(serviceNode, "resource-info-profile-table");
        this.assertNonZeroLength(resourceInfoProfileTable, "resource-info-profile-table");
        ServiceIDImpl serviceId = new ServiceIDImpl(serviceKey);
        descriptorImpl.setServiceID(serviceId);
        descriptorImpl.setRootSbb(new SbbIDImpl(rootSbb));
        descriptorImpl.setDefaultPriority(defaultPriority);
        descriptorImpl.setAddressProfileTable(addressProfileTable);
        descriptorImpl.setResourceInfoProfileTable(resourceInfoProfileTable);
        return descriptorImpl;
    }
}

