/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;
import org.jboss.logging.Log4jLoggerPlugin;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.ServiceDeploymentDescriptorParser;
import org.mobicents.slee.container.management.ServiceDescriptorImpl;
import org.mobicents.slee.container.management.xml.XMLDescriptorStringsFixture;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ServiceDeploymentDescriptorParserTest
extends TestCase {
    private ServiceDeploymentDescriptorParser serviceDeploymentDescriptorParser = null;
    private Document serviceJarDocument = null;
    private Element rootNode = null;
    private Element serviceNode = null;
    private ServiceDescriptorImpl serviceDescriptorImpl = null;

    protected void setUp() throws Exception {
        super.setUp();
        BasicConfigurator.configure();
        Logger.setPluginClassName((String)Log4jLoggerPlugin.class.getName());
        this.serviceDeploymentDescriptorParser = new ServiceDeploymentDescriptorParser();
        InputSource sbbJarSource = new InputSource(new StringReader(XMLDescriptorStringsFixture.SERVICE_JAR_XML));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.serviceJarDocument = builder.parse(sbbJarSource);
        List serviceNodes = XMLUtils.getAllChildElements(this.serviceJarDocument.getDocumentElement(), "service");
        this.serviceNode = (Element)serviceNodes.get(0);
        this.serviceDescriptorImpl = new ServiceDescriptorImpl();
    }

    protected void tearDown() throws Exception {
        this.serviceDeploymentDescriptorParser = null;
        super.tearDown();
    }

    public void testParseServiceComponent() throws IOException, Exception {
        this.serviceDescriptorImpl = this.serviceDeploymentDescriptorParser.parseServiceComponent(this.serviceNode, this.serviceDescriptorImpl);
        ServiceDeploymentDescriptorParserTest.assertEquals((String)"Error - service name", (String)this.serviceDescriptorImpl.getName(), (String)"FooService");
        ServiceDeploymentDescriptorParserTest.assertEquals((String)"Error - service vendor", (String)this.serviceDescriptorImpl.getVendor(), (String)"com.foobar");
        ServiceDeploymentDescriptorParserTest.assertEquals((String)"Error - service version ", (String)this.serviceDescriptorImpl.getVersion(), (String)"1.0");
        ServiceDeploymentDescriptorParserTest.assertTrue((String)"Error - default priority", (this.serviceDescriptorImpl.getDefaultPriority() == 55 ? 1 : 0) != 0);
        ServiceDeploymentDescriptorParserTest.assertEquals((String)"Error - AddressProfileTable", (String)this.serviceDescriptorImpl.getAddressProfileTable(), (String)"MyAddressProfileTable");
        ServiceDeploymentDescriptorParserTest.assertEquals((String)"Error - ResourceInfoProfileTable", (String)this.serviceDescriptorImpl.getResourceInfoProfileTable(), (String)"MyResourceInfoProfileTable");
    }
}

