/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.StandardMBean;
import javax.slee.ComponentID;
import javax.slee.EventTypeID;
import javax.slee.InvalidStateException;
import javax.slee.SLEEException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedComponentException;
import javax.slee.UnrecognizedServiceException;
import javax.slee.management.AlreadyDeployedException;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.DependencyException;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentException;
import javax.slee.management.DeploymentMBean;
import javax.slee.management.LibraryID;
import javax.slee.management.ManagementException;
import javax.slee.management.UnrecognizedDeployableUnitException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.DeploymentManager;

public class DeploymentMBeanImpl
extends StandardMBean
implements DeploymentMBean {
    private File tempDUJarsDeploymentRoot;
    private File classPath;
    private Hashtable deployedUnits = new Hashtable();
    private static Logger logger = Logger.getLogger((Class)DeploymentMBeanImpl.class);
    private String concurrentAccess = null;

    public DeploymentMBeanImpl() throws Exception {
        super(DeploymentMBean.class);
        this.classPath = new File(SleeContainer.getDeployPath());
        this.tempDUJarsDeploymentRoot = this.createTempDUJarsDeploymentRoot();
    }

    private File createTempDUJarsDeploymentRoot() {
        boolean dirCreated;
        ServerConfig config = ServerConfigLocator.locate();
        File basedir = config.getServerTempDir();
        File tempDeploymentRootDir = new File(basedir, "deploy");
        if (!tempDeploymentRootDir.exists() && !(dirCreated = tempDeploymentRootDir.mkdirs())) {
            throw new SLEEException("failed to create temp deployment dir: " + tempDeploymentRootDir);
        }
        return tempDeploymentRootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DeployableUnitID install(String url) throws NullPointerException, MalformedURLException, AlreadyDeployedException, DeploymentException, ManagementException {
        boolean isInstalled = false;
        DeployableUnitID did = null;
        try {
            did = this.getDeployableUnit(url);
            isInstalled = true;
        }
        catch (UnrecognizedDeployableUnitException e) {
            logger.info((Object)("First time deploying " + url));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (isInstalled) {
            logger.warn((Object)(url + ": " + "Already deployed " + "(" + did + ")"));
        } else {
            if (this.concurrentAccess != null) {
                throw new RuntimeException("CONCURRENT ACCESS TO DEPLOYMENT MBEAN! Ongoing call to " + this.concurrentAccess);
            }
            this.concurrentAccess = "install(" + url + ")";
            try {
                DeploymentManager deploymentManager = new DeploymentManager();
                logger.info((Object)("Deploying " + url));
                URL deployUrl = new URL(url);
                SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
                did = deploymentManager.deployUnit(deployUrl, this.tempDUJarsDeploymentRoot, this.classPath, serviceContainer);
                this.deployedUnits.put(url, did);
            }
            finally {
                this.concurrentAccess = null;
            }
            logger.info((Object)("Deployable unit deployed " + did));
        }
        return did;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void uninstall(DeployableUnitID deployableUnitID) throws NullPointerException, UnrecognizedDeployableUnitException, DependencyException, InvalidStateException, ManagementException {
        block10: {
            if (this.concurrentAccess != null) {
                throw new RuntimeException("CONCURRENT ACCESS TO DEPLOYMENT MBEAN! Ongoing call to " + this.concurrentAccess);
            }
            this.concurrentAccess = "uninstall(" + deployableUnitID + ")";
            try {
                if (this.isInstalled(deployableUnitID)) {
                    try {
                        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
                        serviceContainer.removeDeployableUnit(deployableUnitID);
                        Iterator it = this.deployedUnits.values().iterator();
                        while (it.hasNext()) {
                            if (!it.next().equals(deployableUnitID)) continue;
                            it.remove();
                        }
                        logger.debug((Object)("uninstalled " + deployableUnitID));
                        break block10;
                    }
                    catch (InvalidStateException ex) {
                        throw ex;
                    }
                    catch (DependencyException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new ManagementException("Exception removing deployable Unit ", (Throwable)ex);
                    }
                }
                throw new UnrecognizedDeployableUnitException("deployable unit " + deployableUnitID);
            }
            finally {
                this.concurrentAccess = null;
            }
        }
    }

    public DeployableUnitID getDeployableUnit(String deploymentUrl) throws NullPointerException, UnrecognizedDeployableUnitException, ManagementException {
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.getDeployableUnitIDFromUrl(deploymentUrl);
    }

    public DeployableUnitID[] getDeployableUnits() throws ManagementException {
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.getDeployableUnits();
    }

    public SbbID[] getSbbs() throws ManagementException {
        try {
            logger.info((Object)"getSbbs()");
            SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
            return serviceContainer.getSbbIDs();
        }
        catch (Exception ex) {
            throw new ManagementException(ex.getMessage());
        }
    }

    public EventTypeID[] getEventTypes() throws ManagementException {
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.getEventTypes();
    }

    public ProfileSpecificationID[] getProfileSpecifications() throws ManagementException {
        logger.info((Object)"getProfileSpecifications");
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.getProfileSpecificationIDs();
    }

    public ServiceID[] getServices() throws ManagementException {
        logger.info((Object)"getServices()");
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.getServiceIDs();
    }

    public ResourceAdaptorTypeID[] getResourceAdaptorTypes() throws ManagementException {
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.getResourceAdaptorTypeIDs();
    }

    public ResourceAdaptorID[] getResourceAdaptors() throws ManagementException {
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.getResourceAdaptorIDs();
    }

    public ComponentID[] getReferringComponents(ComponentID componentId) throws NullPointerException, UnrecognizedComponentException, ManagementException {
        if (componentId == null) {
            throw new NullPointerException("ComponentID should not be null. See SLEE 1.0 TCK test 3776.");
        }
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.getReferringComponents(componentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployableUnitDescriptor getDescriptor(DeployableUnitID deployableUnitID) throws NullPointerException, UnrecognizedDeployableUnitException, ManagementException {
        DeployableUnitDescriptor dud = null;
        try {
            logger.info((Object)("getDescriptor " + deployableUnitID));
            if (deployableUnitID == null) {
                throw new NullPointerException("deployableUnitID should not be null");
            }
            SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
            dud = serviceContainer.getDeployableUnitDescriptor(deployableUnitID);
            if (dud == null) {
                throw new UnrecognizedDeployableUnitException("unrecognized deployable unit " + deployableUnitID);
            }
        }
        finally {
            this.concurrentAccess = null;
        }
        return dud;
    }

    public DeployableUnitDescriptor[] getDescriptors(DeployableUnitID[] duIds) throws NullPointerException, ManagementException {
        if (duIds == null) {
            throw new NullPointerException("Null arg!");
        }
        try {
            SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
            return serviceContainer.getDeployableUnitDescriptors();
        }
        catch (SystemException ex) {
            throw new ManagementException("Error in tx manager ");
        }
    }

    public ComponentDescriptor getDescriptor(ComponentID componentID) throws NullPointerException, UnrecognizedComponentException, ManagementException {
        if (componentID == null) {
            throw new NullPointerException("null component ID");
        }
        logger.info((Object)("componentID " + componentID));
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        try {
            ComponentDescriptor cd = serviceContainer.getComponentDescriptor(componentID);
            if (cd == null) {
                throw new UnrecognizedComponentException("unrecognized component " + componentID);
            }
            return cd;
        }
        catch (IllegalArgumentException ex) {
            throw new ManagementException(" Illegal Component Type " + componentID);
        }
    }

    public ComponentDescriptor[] getDescriptors(ComponentID[] componentIds) throws NullPointerException, ManagementException {
        if (componentIds == null) {
            throw new NullPointerException("null component ids");
        }
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        return sleeContainer.getDescriptors(componentIds);
    }

    public boolean isInstalled(DeployableUnitID deployableUnitID) throws NullPointerException, ManagementException {
        if (deployableUnitID == null) {
            throw new NullPointerException("null component ids");
        }
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.isInstalled(deployableUnitID);
    }

    public boolean isInstalled(ComponentID componentId) throws NullPointerException, ManagementException {
        if (componentId == null) {
            throw new NullPointerException("deployableUnitID should not be null");
        }
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        return serviceContainer.isInstalled(componentId);
    }

    public LibraryID[] getLibraries() throws ManagementException {
        return null;
    }

    public SbbID[] getSbbs(ServiceID arg0) throws NullPointerException, UnrecognizedServiceException, ManagementException {
        return null;
    }
}

