/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.slee.CreateException;
import javax.slee.InvalidArgumentException;
import javax.slee.InvalidStateException;
import javax.slee.management.DependencyException;
import javax.slee.management.ManagementException;
import javax.slee.management.ResourceAdaptorEntityAlreadyExistsException;
import javax.slee.management.UnrecognizedResourceAdaptorEntityException;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.resource.ResourceException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.NameAlreadyExistException;
import org.mobicents.slee.container.management.ResourceAdaptorIDImpl;
import org.mobicents.slee.container.management.UnrecognizedResourceAdaptorException;
import org.mobicents.slee.container.management.jmx.ResourceAdaptorMBean;

public class ResourceAdaptorMBeanImpl
extends StandardMBean
implements ResourceAdaptorMBean {
    public final String OBJECT_NAME = "slee:name=ResourceAdaptorManagement";
    private ObjectName objectName;
    private static final Logger logger = Logger.getLogger((Class)ResourceAdaptorMBeanImpl.class);

    public ResourceAdaptorMBeanImpl() throws NotCompliantMBeanException {
        super(ResourceAdaptorMBean.class);
        try {
            this.objectName = new ObjectName("slee:name=ResourceAdaptorManagement");
        }
        catch (Exception ex) {
            throw new NotCompliantMBeanException("Object name is malformed : slee:name=ResourceAdaptorManagement");
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void createResourceAdaptorEntity(ResourceAdaptorID id, String name, Properties properties) throws NullPointerException, UnrecognizedResourceAdaptorException, InvalidArgumentException, NameAlreadyExistException, ResourceException, ManagementException, CreateException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Creating Resource Adaptor Entity. RA ID: " + id + ", name: " + name + ", Properties: " + properties));
        try {
            container.createResourceAdaptorEntity((ResourceAdaptorIDImpl)id, name, properties);
        }
        catch (javax.slee.management.UnrecognizedResourceAdaptorException e) {
            e.printStackTrace();
            throw new UnrecognizedResourceAdaptorException(e.getMessage());
        }
        catch (ResourceAdaptorEntityAlreadyExistsException e) {
            e.printStackTrace();
            throw new NameAlreadyExistException(e.getMessage());
        }
    }

    public void createResourceAdaptorEntity(ResourceAdaptorID id, String name, String purl) throws Exception {
        logger.info((Object)("Loading properties: " + purl));
        URL propsURL = new URL(purl);
        InputStream is = propsURL.openStream();
        Properties props = new Properties();
        props.load(is);
        this.createResourceAdaptorEntity(id, name, props);
        is.close();
    }

    public void createResourceAdaptorEntity(String raIDString, String name, String purl) throws Exception {
        SleeContainer container = SleeContainer.lookupFromJndi();
        URL propsURL = new URL(purl);
        InputStream is = propsURL.openStream();
        Properties props = new Properties();
        props.load(is);
        ComponentKey ckey = new ComponentKey(raIDString);
        ResourceAdaptorIDImpl raID = new ResourceAdaptorIDImpl(ckey);
        container.createResourceAdaptorEntity(raID, name, props);
        is.close();
    }

    public void removeResourceAdaptorEntity(String name) throws NullPointerException, UnrecognizedResourceAdaptorException, InvalidArgumentException, DependencyException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Removing Resource Adaptor Entity. RA name: " + name));
        try {
            container.removeResourceAdaptorEntity(name);
        }
        catch (UnrecognizedResourceAdaptorEntityException e) {
            e.printStackTrace();
            throw new UnrecognizedResourceAdaptorException(e.getMessage());
        }
    }

    public void updateConfigurationProperties(String name, Properties properties) throws NullPointerException, UnrecognizedResourceAdaptorException, InvalidStateException, ResourceException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Updating Resource Adaptor Entity Config. Properties: " + properties));
        try {
            container.updateConfigurationProperties(name, properties);
        }
        catch (UnrecognizedResourceAdaptorEntityException e) {
            e.printStackTrace();
            throw new UnrecognizedResourceAdaptorException(e.getMessage());
        }
    }

    public void activateResourceAdaptorEntity(String name) throws NullPointerException, UnrecognizedResourceAdaptorException, InvalidStateException, ResourceException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Activating Resource Adaptor Entity. RA name: " + name));
        try {
            container.activateResourceAdaptorEntity(name);
        }
        catch (UnrecognizedResourceAdaptorEntityException e) {
            e.printStackTrace();
            throw new UnrecognizedResourceAdaptorException(e.getMessage());
        }
    }

    public void deactivateResourceAdaptorEntity(String name) throws NullPointerException, UnrecognizedResourceAdaptorException, InvalidStateException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Deactivating Resource Adaptor Entity. RA name: " + name));
        try {
            container.deactivateResourceAdaptorEntity(name);
        }
        catch (UnrecognizedResourceAdaptorEntityException e) {
            e.printStackTrace();
            throw new UnrecognizedResourceAdaptorException(e.getMessage());
        }
    }

    public void createEntityLink(String link, String entityName) throws ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Creating RA Entity Link. RA name: " + entityName + ", Link: " + link));
        container.createResourceAdaptorEntityLink(link, entityName);
    }

    public void removeEntityLink(String link) throws ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Removing RA Entity Link. RA link: " + link));
        container.removeResourceAdaptorEntityLink(link);
    }
}

