/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.net.InetAddress;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.mobicents.slee.container.management.jmx.SleeCommandInterface;

public class SleeBeanShellUtil {
    public Logger log = Logger.getLogger((String)SleeBeanShellUtil.class.getName());
    private SleeCommandInterface sci;

    public SleeBeanShellUtil() {
        try {
            InetAddress myIpAddress = InetAddress.getByName(System.getProperty("jboss.bind.address"));
            this.sci = new SleeCommandInterface("jnp://" + myIpAddress.getHostAddress() + ":1099");
        }
        catch (Exception e) {
            this.log.warn((Object)("Bad result: " + e.getCause().toString()));
        }
    }

    public void deployService(String url, String serviceId) {
        try {
            if (url != null) {
                this.sci.invokeOperation("-install", StringPropertyReplacer.replaceProperties((String)url), null, null);
            }
            if (serviceId != null) {
                this.sci.invokeOperation("-activateService", serviceId, null, null);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()));
        }
    }

    public void deployRa(String raTypeURL, String raURL, String raID, String raName, String linkName, String props) {
        try {
            if (raTypeURL != null) {
                this.sci.invokeOperation("-install", StringPropertyReplacer.replaceProperties((String)raTypeURL), null, null);
            }
            if (raURL != null) {
                this.sci.invokeOperation("-install", StringPropertyReplacer.replaceProperties((String)raURL), null, null);
            }
            if (raID != null & raName != null) {
                this.sci.invokeOperation("-createRaEntity", raID, raName, props);
            }
            if (raName != null) {
                this.sci.invokeOperation("-activateRaEntity", raName, null, null);
            }
            if (linkName != null & raName != null) {
                this.sci.invokeOperation("-createRaLink", linkName, raName, null);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()));
        }
    }

    public void undeployService(String url, String serviceId) {
        try {
            if (serviceId != null) {
                this.sci.invokeOperation("-deactivateService", serviceId, null, null);
            }
            if (url != null) {
                this.sci.invokeOperation("-uninstall", StringPropertyReplacer.replaceProperties((String)url), null, null);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()));
        }
    }

    public void undeployRa(String raTypeURL, String raURL, String raName, String linkName) {
        try {
            if (linkName != null & raName != null) {
                this.sci.invokeOperation("-removeRaLink", linkName, raName, null);
            }
            if (raName != null) {
                this.sci.invokeOperation("-deactivateRaEntity", raName, null, null);
                this.sci.invokeOperation("-removeRaEntity", raName, null, null);
            }
            if (raURL != null) {
                this.sci.invokeOperation("-uninstall", StringPropertyReplacer.replaceProperties((String)raURL), null, null);
            }
            if (raTypeURL != null) {
                this.sci.invokeOperation("-uninstall", StringPropertyReplacer.replaceProperties((String)raTypeURL), null, null);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()));
        }
    }

    public void createProfileTable(String profileSpecID, String profileTableName) {
        try {
            this.sci.invokeOperation("-createProfileTable", profileSpecID, profileTableName, null);
        }
        catch (Exception e) {
            this.log.warn((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()));
        }
    }

    public Object createProfile(String profileTableName, String profileName) {
        Object profileObject = null;
        try {
            profileObject = this.sci.invokeOperation("-createProfile", profileTableName, profileName, null);
        }
        catch (Exception e) {
            this.log.warn((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
        }
        return profileObject;
    }
}

