/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.slee.facilities.Level;
import javax.slee.management.DeployableUnitID;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.EventTypeIDImpl;
import org.mobicents.slee.container.management.ProfileSpecificationIDImpl;
import org.mobicents.slee.container.management.ResourceAdaptorIDImpl;
import org.mobicents.slee.container.management.SbbIDImpl;
import org.mobicents.slee.container.management.ServiceIDImpl;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;

public class SleeCommandInterface {
    private static Logger logger = Logger.getLogger(SleeCommandInterface.class.getName());
    private Object result = null;
    protected RMIAdaptor rmiserver = null;
    public String commandBean = null;
    public String commandString = null;

    public SleeCommandInterface() {
    }

    public SleeCommandInterface(String jndiurl) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", jndiurl);
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jnp.interfaces");
        InitialContext ctx = new InitialContext(env);
        this.rmiserver = (RMIAdaptor)ctx.lookup("jmx/rmi/RMIAdaptor");
        if (this.rmiserver == null) {
            logger.info("RMIAdaptor is null");
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName oname) throws Exception {
        MBeanInfo info = null;
        info = this.rmiserver.getMBeanInfo(oname);
        return info;
    }

    public Object invokeCommand(ObjectName oname, String methodname, Object[] pParams, String[] pSignature) throws Exception {
        this.result = this.rmiserver.invoke(oname, methodname, pParams, pSignature);
        return this.result;
    }

    public String getAttribute(ObjectName oname, String AttributeName) {
        Object result = null;
        try {
            result = this.rmiserver.getAttribute(oname, AttributeName);
            return result.toString();
        }
        catch (Exception ex) {
            return "Unknown";
        }
    }

    public Object invokeOperation(String command, String data1, String data2, String data3) throws Exception {
        Properties opArg3;
        String opArg2;
        Object opArg1;
        String sig3;
        String sig2;
        String sig1;
        ObjectName name;
        block113: {
            String componentType;
            StringTokenizer st;
            name = null;
            sig1 = null;
            sig2 = null;
            sig3 = null;
            opArg1 = null;
            opArg2 = null;
            opArg3 = null;
            if (command.equals("-startSlee")) {
                this.commandBean = "slee:service=SleeManagement";
                this.commandString = "start";
            } else if (command.equals("-stopSlee")) {
                this.commandBean = "slee:service=SleeManagement";
                this.commandString = "stop";
            } else if (command.equals("-getSleeState")) {
                this.commandBean = "slee:service=SleeManagement";
                try {
                    name = new ObjectName(this.commandBean);
                }
                catch (MalformedObjectNameException e) {
                    logger.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                }
                catch (NullPointerException e) {
                    logger.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                }
                logger.info("SLEE State = " + this.getAttribute(name, "State"));
                System.exit(0);
            } else if (command.equals("-install")) {
                this.commandBean = "slee:name=DeploymentMBean";
                this.commandString = "install";
                sig1 = "java.lang.String";
                opArg1 = new URL(data1).toString();
            } else if (command.equals("-uninstall")) {
                if (data1.startsWith("file:")) {
                    data1 = new URL(data1).toString();
                    DeployableUnitID deployableUnitID = (DeployableUnitID)this.invokeOperation("-getDeploymentId", data1, null, null);
                    opArg1 = deployableUnitID;
                } else {
                    int id = 0;
                    try {
                        st = new StringTokenizer(data1, "[", true);
                        String token = st.nextToken();
                        if (!token.equalsIgnoreCase("DeployableUnitID")) {
                            logger.warning("Bad result: DeployableUnitID[number] or URL File: file://...\n");
                            System.exit(-1);
                        }
                        st.nextToken();
                        String idStr = st.nextToken("]");
                        id = Integer.parseInt(idStr);
                    }
                    catch (NoSuchElementException ex) {
                        logger.log(java.util.logging.Level.WARNING, "Bad result: DeployableUnitID[number]\n", ex);
                        System.exit(-1);
                    }
                    catch (NumberFormatException ex) {
                        logger.log(java.util.logging.Level.WARNING, "Bad result: DeployableUnitID[number]\n", ex);
                        System.exit(-1);
                    }
                    opArg1 = new DeployableUnitIDImpl(id);
                }
                this.commandBean = "slee:name=DeploymentMBean";
                this.commandString = "uninstall";
                sig1 = "javax.slee.management.DeployableUnitID";
            } else if (command.equals("-getDeploymentId")) {
                this.commandBean = "slee:name=DeploymentMBean";
                this.commandString = "getDeployableUnit";
                sig1 = "java.lang.String";
                opArg1 = data1;
            } else if (command.equals("-getDescriptor")) {
                this.commandBean = "slee:name=DeploymentMBean";
                this.commandString = "getDescriptor";
                sig1 = "javax.slee.management.DeployableUnitID";
                int id = 0;
                try {
                    st = new StringTokenizer(data1, "[", true);
                    String token = st.nextToken();
                    if (!token.equalsIgnoreCase("DeployableUnitID")) {
                        logger.warning("Bad result: DeployableUnitID[number]\n");
                        System.exit(-1);
                    }
                    st.nextToken();
                    String idStr = st.nextToken("]");
                    id = Integer.parseInt(idStr);
                }
                catch (NoSuchElementException ex) {
                    logger.log(java.util.logging.Level.WARNING, "Bad result: DeployableUnitID[number]\n", ex);
                    System.exit(-1);
                }
                catch (NumberFormatException ex) {
                    logger.log(java.util.logging.Level.WARNING, "Bad result: DeployableUnitID[number]\n", ex);
                    System.exit(-1);
                }
                opArg1 = new DeployableUnitIDImpl(id);
            } else if (command.equals("-activateService")) {
                this.commandBean = "slee:name=ServiceManagementMBean";
                this.commandString = "activate";
                sig1 = "javax.slee.ServiceID";
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(data1, "[", true);
                    componentType = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String ckeyStr = stringTokenizer.nextToken("]");
                    if (componentType.equalsIgnoreCase("ServiceID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ServiceIDImpl(componentKey);
                        break block113;
                    }
                    logger.warning("Bad Result: ServiceID[service]\n");
                    System.exit(-1);
                }
                catch (NoSuchElementException ex) {
                    logger.log(java.util.logging.Level.WARNING, "Bad Result: ServiceID[service]\n", ex);
                    System.exit(-1);
                }
            } else if (command.equals("-deactivateService")) {
                this.commandBean = "slee:name=ServiceManagementMBean";
                this.commandString = "deactivate";
                sig1 = "javax.slee.ServiceID";
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(data1, "[", true);
                    componentType = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String ckeyStr = stringTokenizer.nextToken("]");
                    if (componentType.equalsIgnoreCase("ServiceID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ServiceIDImpl(componentKey);
                        break block113;
                    }
                    logger.warning("Bad Result: ServiceID[service]\n");
                    System.exit(-1);
                }
                catch (NoSuchElementException ex) {
                    logger.log(java.util.logging.Level.WARNING, "Bad Result: ServiceID[service]\n", ex);
                    System.exit(-1);
                }
            } else if (command.equals("-getServiceState")) {
                this.commandBean = "slee:name=ServiceManagementMBean";
                this.commandString = "getState";
                sig1 = "javax.slee.ServiceID";
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(data1, "[", true);
                    componentType = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String ckeyStr = stringTokenizer.nextToken("]");
                    if (componentType.equalsIgnoreCase("ServiceID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ServiceIDImpl(componentKey);
                        break block113;
                    }
                    logger.warning("Bad Result: ServiceID[service]\n");
                    System.exit(-1);
                }
                catch (NoSuchElementException ex) {
                    logger.log(java.util.logging.Level.WARNING, "Bad Result: ServiceID[service]\n", ex);
                    System.exit(-1);
                }
            } else if (command.equals("-setTraceLevel")) {
                String level = data2;
                this.commandBean = "slee:name=TraceMBean";
                this.commandString = "setTraceLevel";
                sig1 = "javax.slee.ComponentID";
                sig2 = "javax.slee.facilities.Level";
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(data1, "[", true);
                    String componentType2 = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String ckeyStr = stringTokenizer.nextToken("]");
                    if (componentType2.equalsIgnoreCase("ServiceID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ServiceIDImpl(componentKey);
                    } else if (componentType2.equalsIgnoreCase("SbbID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new SbbIDImpl(componentKey);
                    } else if (componentType2.equalsIgnoreCase("ProfileSpecificationID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ProfileSpecificationIDImpl(componentKey);
                    } else if (componentType2.equalsIgnoreCase("ResourceAdaptorID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ResourceAdaptorIDImpl(componentKey);
                    } else if (componentType2.equalsIgnoreCase("ResourceAdaptorTypeID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ResourceAdaptorTypeIDImpl(componentKey);
                    } else if (componentType2.equalsIgnoreCase("EventTypeID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new EventTypeIDImpl(componentKey);
                    } else {
                        logger.warning("Bad Result: Unknown Component ID Type\n");
                        logger.warning("It has to be: ServiceID, SbbID, ProfileSpecificationID, ResourceAdaptorID, ResourceAdaptorTypeID or EventTypeID\n");
                        System.exit(-1);
                    }
                    if (level.equalsIgnoreCase(Level.SEVERE.toString())) {
                        opArg2 = Level.SEVERE;
                        break block113;
                    }
                    if (level.equalsIgnoreCase(Level.WARNING.toString())) {
                        opArg2 = Level.WARNING;
                        break block113;
                    }
                    if (level.equalsIgnoreCase(Level.INFO.toString())) {
                        opArg2 = Level.INFO;
                        break block113;
                    }
                    if (level.equalsIgnoreCase(Level.CONFIG.toString())) {
                        opArg2 = Level.CONFIG;
                        break block113;
                    }
                    if (level.equalsIgnoreCase(Level.FINE.toString())) {
                        opArg2 = Level.FINE;
                        break block113;
                    }
                    if (level.equalsIgnoreCase(Level.FINER.toString())) {
                        opArg2 = Level.FINER;
                        break block113;
                    }
                    if (level.equalsIgnoreCase(Level.FINEST.toString())) {
                        opArg2 = Level.FINEST;
                        break block113;
                    }
                    if (level.equalsIgnoreCase(Level.OFF.toString())) {
                        opArg2 = Level.OFF;
                        break block113;
                    }
                    throw new IllegalArgumentException("Bad level " + level);
                }
                catch (NoSuchElementException ex) {
                    logger.log(java.util.logging.Level.WARNING, "Bad Result: Trace ComponentID[component]\n", ex);
                    System.exit(-1);
                }
            } else if (command.equals("-getTraceLevel")) {
                this.commandBean = "slee:name=TraceMBean";
                this.commandString = "getTraceLevel";
                sig1 = "javax.slee.ComponentID";
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(data1, "[", true);
                    componentType = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String ckeyStr = stringTokenizer.nextToken("]");
                    if (componentType.equalsIgnoreCase("ServiceID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ServiceIDImpl(componentKey);
                        break block113;
                    }
                    if (componentType.equalsIgnoreCase("SbbID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new SbbIDImpl(componentKey);
                        break block113;
                    }
                    if (componentType.equalsIgnoreCase("ProfileSpecificationID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ProfileSpecificationIDImpl(componentKey);
                        break block113;
                    }
                    if (componentType.equalsIgnoreCase("ResourceAdaptorID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ResourceAdaptorIDImpl(componentKey);
                        break block113;
                    }
                    if (componentType.equalsIgnoreCase("ResourceAdaptorTypeID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ResourceAdaptorTypeIDImpl(componentKey);
                        break block113;
                    }
                    logger.warning("Bad Result: Unknown Component ID Type\n");
                    logger.warning("It has to be: ServiceID, SbbID, ProfileSpecificationID, ResourceAdaptorID or ResourceAdaptorTypeID\n");
                    System.exit(-1);
                }
                catch (NoSuchElementException ex) {
                    logger.log(java.util.logging.Level.WARNING, "Bad Result: Trace ComponentID[component]\n", ex);
                    System.exit(-1);
                }
            } else if (command.equals("-createRaEntity")) {
                this.commandBean = "slee:name=ResourceAdaptorMBean";
                this.commandString = "createResourceAdaptorEntity";
                sig1 = "javax.slee.resource.ResourceAdaptorID";
                sig2 = "java.lang.String";
                opArg2 = data2;
                sig3 = "java.util.Properties";
                logger.info("Loading properties: " + data3);
                if (data3 != null) {
                    Properties props = new Properties();
                    URL url = new URI(data3).toURL();
                    props.load(url.openStream());
                    opArg3 = props;
                } else {
                    opArg3 = null;
                }
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(data1, "[", true);
                    componentType = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String ckeyStr = stringTokenizer.nextToken("]");
                    if (componentType.equalsIgnoreCase("ResourceAdaptorID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ResourceAdaptorIDImpl(componentKey);
                        break block113;
                    }
                    logger.warning("Bad Result: ResourceAdaptor[resourceID]\n");
                    System.exit(-1);
                }
                catch (NoSuchElementException ex) {
                    logger.log(java.util.logging.Level.WARNING, "Bad Result: ResourceAdaptor[resourceID]\n", ex);
                    System.exit(-1);
                }
            } else if (command.equals("-activateRaEntity")) {
                this.commandBean = "slee:name=ResourceAdaptorMBean";
                this.commandString = "activateResourceAdaptorEntity";
                sig1 = "java.lang.String";
                opArg1 = data1;
            } else if (command.equals("-deactivateRaEntity")) {
                this.commandBean = "slee:name=ResourceAdaptorMBean";
                this.commandString = "deactivateResourceAdaptorEntity";
                sig1 = "java.lang.String";
                opArg1 = data1;
            } else if (command.equals("-removeRaEntity")) {
                this.commandBean = "slee:name=ResourceAdaptorMBean";
                this.commandString = "removeResourceAdaptorEntity";
                sig1 = "java.lang.String";
                opArg1 = data1;
            } else if (command.equals("-createRaLink")) {
                this.commandBean = "slee:name=ResourceAdaptorMBean";
                this.commandString = "createEntityLink";
                sig1 = "java.lang.String";
                sig2 = "java.lang.String";
                opArg1 = data1;
                opArg2 = data2;
            } else if (command.equals("-removeRaLink")) {
                this.commandBean = "slee:name=ResourceAdaptorMBean";
                this.commandString = "removeEntityLink";
                sig1 = "java.lang.String";
                opArg1 = data1;
            } else if (command.equals("-createProfileTable")) {
                this.commandBean = "slee:name=ProfileProvisoningMBean";
                this.commandString = "createProfileTable";
                sig1 = "javax.slee.profile.ProfileSpecificationID";
                sig2 = "java.lang.String";
                opArg2 = data2;
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(data1, "[", true);
                    componentType = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    String ckeyStr = stringTokenizer.nextToken("]");
                    if (componentType.equalsIgnoreCase("ProfileSpecificationID")) {
                        ComponentKey componentKey = new ComponentKey(ckeyStr);
                        opArg1 = new ProfileSpecificationIDImpl(componentKey);
                        break block113;
                    }
                    logger.warning("Bad Result: ProfileSpecificationID[profile_specification]\n");
                    System.exit(-1);
                }
                catch (NoSuchElementException ex) {
                    logger.log(java.util.logging.Level.WARNING, "Bad Result: ProfileSpecificationID[profile_specification]\n", ex);
                    System.exit(-1);
                }
            } else if (command.equals("-removeProfileTable")) {
                this.commandBean = "slee:name=ProfileProvisoningMBean";
                this.commandString = "removeProfileTable";
                sig1 = "java.lang.String";
                opArg1 = data1;
            } else if (command.equals("-createProfile")) {
                this.commandBean = "slee:name=ProfileProvisoningMBean";
                this.commandString = "createProfile";
                sig1 = "java.lang.String";
                sig2 = "java.lang.String";
                opArg1 = data1;
                opArg2 = data2;
            } else if (command.equals("-removeProfile")) {
                this.commandBean = "slee:name=ProfileProvisoningMBean";
                this.commandString = "removeProfile";
                sig1 = "java.lang.String";
                sig2 = "java.lang.String";
                opArg1 = data1;
                opArg2 = data2;
            } else {
                logger.warning("Bad result: command not found!");
                System.exit(1);
            }
        }
        try {
            Object[] opArgs;
            name = new ObjectName(this.commandBean);
            if (sig3 != null) {
                String[] sigs = new String[]{sig1, sig2, sig3};
                opArgs = new Object[]{opArg1, opArg2, opArg3};
                this.invokeCommand(name, this.commandString, opArgs, sigs);
            } else if (sig2 != null) {
                String[] sigs = new String[]{sig1, sig2};
                opArgs = new Object[]{opArg1, opArg2};
                this.invokeCommand(name, this.commandString, opArgs, sigs);
            } else if (sig1 != null) {
                String[] sigs = new String[]{sig1};
                opArgs = new Object[]{opArg1};
                this.invokeCommand(name, this.commandString, opArgs, sigs);
            } else {
                this.invokeCommand(name, this.commandString, null, null);
            }
        }
        catch (MalformedObjectNameException e) {
            logger.log(java.util.logging.Level.WARNING, e.getMessage(), e);
        }
        catch (NullPointerException e) {
            logger.log(java.util.logging.Level.WARNING, e.getMessage(), e);
        }
        catch (Exception e) {
            throw e;
        }
        return this.result;
    }
}

