/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedComponentException;
import javax.slee.UnrecognizedSbbException;
import javax.slee.UnrecognizedServiceException;
import javax.slee.facilities.Level;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.ManagementException;
import javax.slee.management.UnrecognizedResourceAdaptorEntityException;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.jmx.TraceMBeanImplMBean;
import org.mobicents.slee.runtime.facilities.TraceFacilityImpl;

public class TraceMBeanImpl
extends ServiceMBeanSupport
implements TraceMBeanImplMBean {
    private TraceFacilityImpl traceFacility;
    private static Logger logger = Logger.getLogger((Class)TraceMBeanImpl.class);
    private NotificationBroadcasterSupport notifSupport = new NotificationBroadcasterSupport();
    public static final String JNDI_NAME = "trace";

    public TraceMBeanImpl() throws NotCompliantMBeanException {
        super(TraceMBeanImplMBean.class);
        this.traceFacility = new TraceFacilityImpl(this);
    }

    public void setTraceLevel(ComponentID componentId, Level level) throws NullPointerException, UnrecognizedComponentException, ManagementException {
        if (componentId == null) {
            throw new NullPointerException("null component Id");
        }
        this.traceFacility.setTraceLevel(componentId, level);
    }

    public Level getTraceLevel(ComponentID componentId) throws NullPointerException, UnrecognizedComponentException, ManagementException {
        if (componentId == null) {
            throw new NullPointerException(" null component Id ");
        }
        Level level = this.traceFacility.getTraceLevel(componentId);
        return level;
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object handbackObject) throws IllegalArgumentException {
        this.notifSupport.addNotificationListener(notificationListener, notificationFilter, handbackObject);
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.notifSupport.removeNotificationListener(notificationListener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.traceFacility == null) {
            return null;
        }
        String[] notificationTypes = this.traceFacility.getNotificationTypes();
        MBeanNotificationInfo[] mbeanNotificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notificationTypes, "javax.slee.management.trace", "SLEE Spec 1.0, #13.4. SBBs use the Trace Facility to generate trace messages intended for consumption by external management clients, such as a network management console or a management policy engine.")};
        return mbeanNotificationInfo;
    }

    public void sendNotification(Notification notification) {
        this.notifSupport.sendNotification(notification);
    }

    protected void startService() throws Exception {
        SleeContainer.registerFacilityWithJndi(JNDI_NAME, this.traceFacility);
        logger.info((Object)"TraceMBean started");
    }

    protected void stopService() throws Exception {
        SleeContainer.unregisterFacilityWithJndi(JNDI_NAME);
        logger.info((Object)"TraceMBean stopped");
    }

    public TraceLevel getResourceAdaptorEntityTraceLevel(String arg0, String arg1) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        return null;
    }

    public String[] getResourceAdaptorEntityTracerNames(String arg0) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        return null;
    }

    public String[] getResourceAdaptorEntityTracersSet(String arg0) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        return null;
    }

    public TraceLevel getSbbTraceLevel(ServiceID arg0, SbbID arg1, String arg2) throws NullPointerException, UnrecognizedServiceException, UnrecognizedSbbException, ManagementException {
        return null;
    }

    public String[] getSbbTracerNames(ServiceID arg0, SbbID arg1) throws NullPointerException, UnrecognizedServiceException, UnrecognizedSbbException, ManagementException {
        return null;
    }

    public String[] getSbbTracersSet(ServiceID arg0, SbbID arg1) throws NullPointerException, UnrecognizedServiceException, UnrecognizedSbbException, ManagementException {
        return null;
    }

    public void setResourceAdaptorEntityTraceLevel(String arg0, String arg1, TraceLevel arg2) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
    }

    public void setSbbTraceLevel(ServiceID arg0, String arg1, TraceLevel arg2) throws NullPointerException, UnrecognizedServiceException, ManagementException {
    }

    public void setSbbTraceLevel(ServiceID arg0, SbbID arg1, String arg2, TraceLevel arg3) throws NullPointerException, UnrecognizedServiceException, UnrecognizedSbbException, ManagementException {
    }

    public void unsetResourceAdaptorEntityTraceLevel(String arg0, String arg1) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, InvalidArgumentException, ManagementException {
    }

    public void unsetSbbTraceLevel(ServiceID arg0, SbbID arg1, String arg2) throws NullPointerException, UnrecognizedServiceException, UnrecognizedSbbException, InvalidArgumentException, ManagementException {
    }
}

