/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mobicents.slee.container.management.xml.DefaultSleeEntityResolver;
import org.mobicents.slee.container.management.xml.XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    public static Document parseDocument(String url, boolean validating) throws IOException, IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException("The url may not be null.");
        }
        return XMLUtils.parseDocument(new InputSource(url), validating, DefaultSleeEntityResolver.getInstance());
    }

    public static Document parseDocument(InputStream is, boolean validating) throws IOException, IllegalArgumentException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream may not be null");
        }
        return XMLUtils.parseDocument(new InputSource(is), validating, DefaultSleeEntityResolver.getInstance());
    }

    public static Document parseDocument(InputSource in, boolean validating) throws IOException {
        validating = false;
        return XMLUtils.parseDocument(in, validating, DefaultSleeEntityResolver.getInstance());
    }

    public static Document parseDocument(InputSource in, boolean validating, EntityResolver resolver) throws IOException {
        validating = false;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (resolver != null) {
                builder.setEntityResolver(resolver);
            }
            return builder.parse(in);
        }
        catch (SAXParseException e) {
            throw new XMLException("A parse error occurred at " + e.getSystemId() + ":" + e.getLineNumber(), e);
        }
        catch (SAXException e) {
            throw new XMLException("An Error occurred while reading document", e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException("Conguration error.", e);
        }
    }

    public static String getElementTextValue(Element element) throws IllegalArgumentException, XMLException {
        if (element == null) {
            throw new IllegalArgumentException("The specified element is null");
        }
        NodeList nodelist = element.getChildNodes();
        if (nodelist.getLength() == 0) {
            return "";
        }
        if (nodelist.getLength() != 1 || nodelist.item(0).getNodeType() != 3) {
            throw new XMLException("Not a text node: " + element);
        }
        return nodelist.item(0).getNodeValue().trim();
    }

    public static String getElementTextValue(Element parent, String name) throws XMLException {
        Element element = XMLUtils.getChildElement(parent, name, true);
        if (element == null) {
            return null;
        }
        return XMLUtils.getElementTextValue(element);
    }

    public static Element getChildElement(Element parent, String name, boolean assertUnique) throws IllegalArgumentException, XMLException {
        Iterator elements = XMLUtils.getAllChildElements(parent, name).iterator();
        if (elements.hasNext()) {
            Element element = (Element)elements.next();
            if (assertUnique && elements.hasNext()) {
                throw new XMLException("Multiple \"" + name + "\" occurrences of are not allowed");
            }
            return element;
        }
        return null;
    }

    public static Element getChildElement(Element parent, String name) throws IllegalArgumentException, XMLException {
        return XMLUtils.getChildElement(parent, name, false);
    }

    public static List getAllChildElements(Element parent, String name) throws IllegalArgumentException {
        if (parent == null) {
            throw new IllegalArgumentException("The specified parent is null.");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Null or empty element name!");
        }
        NodeList nodelist = parent.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(nodelist.getLength());
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            if (node.getNodeType() != 1 || !name.equals(((Element)node).getTagName())) continue;
            children.add((Element)node);
        }
        return children;
    }
}

