/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.profile;

import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javax.slee.profile.ProfileSpecificationDescriptor;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;
import org.mobicents.slee.container.management.DeployableUnitIDImpl;
import org.mobicents.slee.container.management.ProfileSpecificationDescriptorImpl;

public class ProfileVerifier {
    private static Logger logger = Logger.getLogger((Class)ProfileVerifier.class);
    private ClassPool pool = null;
    private CtClass cmpProfileInterface = null;
    private CtClass profileManagementInterface = null;
    private CtClass profileManagementAbstractClass = null;
    private CtClass sleeProfileManagementInterface = null;
    private String cmpProfileInterfaceName = null;
    private String profileManagementInterfaceName = null;
    private String managementAbstractClassName = null;
    private int combination = -1;

    public ProfileVerifier(ProfileSpecificationDescriptor profileSpecificationDescriptor) {
        this.pool = (DeployableUnitIDImpl)((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getDeployableUnit() != null ? ((DeployableUnitIDImpl)((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getDeployableUnit()).getDUDeployer().getClassPool() : ConcreteClassGeneratorUtils.createClassPool();
        this.cmpProfileInterfaceName = ((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getCMPInterfaceName();
        this.profileManagementInterfaceName = ((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getManagementInterfaceName();
        this.managementAbstractClassName = ((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getManagementAbstractClassName();
        this.combination = ProfileVerifier.checkCombination(this.cmpProfileInterfaceName, this.profileManagementInterfaceName, this.managementAbstractClassName);
    }

    public boolean verifyProfileSpecification() {
        boolean verified = this.verifyCMPProfileInterface();
        if (!verified) {
            return false;
        }
        if (this.profileManagementInterfaceName != null && !(verified = this.verifyManagementInterface())) {
            return false;
        }
        return this.managementAbstractClassName == null || (verified = this.verifyManagementAbstractClass());
    }

    private boolean verifyCMPProfileInterface() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("classPool = " + this.pool));
        }
        if (this.cmpProfileInterfaceName == null) {
            return false;
        }
        try {
            this.cmpProfileInterface = this.pool.get(this.cmpProfileInterfaceName);
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return false;
        }
        if (!this.cmpProfileInterface.isInterface()) {
            logger.error((Object)(this.cmpProfileInterfaceName + " is not an interface."));
            return false;
        }
        if (!Modifier.isPublic((int)this.cmpProfileInterface.getModifiers())) {
            logger.error((Object)(this.cmpProfileInterfaceName + " is not public."));
            return false;
        }
        Set properties = ClassUtils.getCMPFields(this.cmpProfileInterface);
        CtClass oClass = null;
        try {
            oClass = this.pool.get("java.lang.Object");
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return properties.size() * 2 == this.cmpProfileInterface.getMethods().length - oClass.getMethods().length;
    }

    private boolean verifyManagementInterface() {
        if (this.profileManagementInterfaceName == null) {
            logger.error((Object)"Profile Management Interface name is null");
            return false;
        }
        try {
            this.profileManagementInterface = this.pool.get(this.profileManagementInterfaceName);
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return false;
        }
        if (!this.profileManagementInterface.isInterface()) {
            logger.error((Object)(this.profileManagementInterfaceName + " is not an interface."));
            return false;
        }
        if (!Modifier.isPublic((int)this.profileManagementInterface.getModifiers())) {
            logger.error((Object)(this.profileManagementInterfaceName + " is not public."));
            return false;
        }
        CtMethod[] managementMethods = this.profileManagementInterface.getDeclaredMethods();
        CtMethod[] cmpProfileMethods = this.cmpProfileInterface.getDeclaredMethods();
        for (int i = 0; i < managementMethods.length; ++i) {
            String methodName = managementMethods[i].getName();
            if (methodName.startsWith("profile")) {
                logger.error((Object)("Method " + methodName + " starts with profile."));
                return false;
            }
            if (methodName.startsWith("get") || methodName.startsWith("set")) {
                for (int j = 0; j < cmpProfileMethods.length; ++j) {
                    String cmpProfileMethodName = cmpProfileMethods[j].getName();
                    if (!cmpProfileMethodName.equals(methodName)) continue;
                    if (!cmpProfileMethods[j].equals((Object)managementMethods[i])) {
                        logger.error((Object)("Method " + methodName + " " + "already present in the CMP Profile interface " + this.cmpProfileInterfaceName + " with a different signature."));
                        return false;
                    }
                    try {
                        CtClass[] exceptionTypes = managementMethods[i].getExceptionTypes();
                        for (int k = 0; k < exceptionTypes.length; ++k) {
                            logger.debug((Object)exceptionTypes[k].getName());
                        }
                        if (exceptionTypes.length > 0) {
                            logger.error((Object)("Method " + methodName + " has a throws clause."));
                            return false;
                        }
                        continue;
                    }
                    catch (NotFoundException nfe) {
                        // empty catch block
                    }
                }
            }
            CtClass profileMBean = null;
            try {
                profileMBean = this.pool.get("javax.slee.profile.ProfileMBean");
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                return false;
            }
            CtMethod[] profileMBeanMethods = profileMBean.getDeclaredMethods();
            for (int j = 0; j < profileMBeanMethods.length; ++j) {
                if (!managementMethods[i].equals((Object)profileMBeanMethods[j])) continue;
                logger.error((Object)("Method " + methodName + " already defined in javax.slee.profile.ProfileMBean"));
                return false;
            }
            CtClass dynamicMBean = null;
            try {
                dynamicMBean = this.pool.get("javax.management.DynamicMBean");
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                return false;
            }
            CtMethod[] dynamicMBeanMethods = dynamicMBean.getDeclaredMethods();
            for (int j = 0; j < dynamicMBeanMethods.length; ++j) {
                if (!managementMethods[i].equals((Object)dynamicMBeanMethods[j])) continue;
                logger.error((Object)("Method " + methodName + " already defined in javax.management.DynamicMBean"));
                return false;
            }
            CtClass registrationMBean = null;
            try {
                registrationMBean = this.pool.get("javax.management.MBeanRegistration");
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                return false;
            }
            CtMethod[] registrationMBeanMethods = registrationMBean.getDeclaredMethods();
            for (int j = 0; j < registrationMBeanMethods.length; ++j) {
                if (!managementMethods[i].equals((Object)registrationMBeanMethods[j])) continue;
                logger.error((Object)("Method " + methodName + " already defined in javax.management.MBeanRegistration"));
                return false;
            }
        }
        return true;
    }

    private boolean verifyManagementAbstractClass() {
        int i;
        if (this.managementAbstractClassName == null) {
            logger.error((Object)"Profile Management Abstract class name is null");
            return false;
        }
        try {
            this.profileManagementAbstractClass = this.pool.get(this.managementAbstractClassName);
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return false;
        }
        if (!Modifier.isAbstract((int)this.profileManagementAbstractClass.getModifiers())) {
            logger.error((Object)(this.managementAbstractClassName + " is not an abstract class."));
            return false;
        }
        if (!Modifier.isPublic((int)this.profileManagementAbstractClass.getModifiers())) {
            logger.error((Object)(this.managementAbstractClassName + " is not public."));
            return false;
        }
        CtClass[] interfaces = null;
        try {
            interfaces = this.profileManagementAbstractClass.getInterfaces();
            boolean cmpProfileInterfaceFound = false;
            boolean managementInterfaceFound = false;
            boolean sleeManagementInterfaceFound = false;
            for (i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].getName().equals("javax.slee.profile.ProfileManagement")) {
                    sleeManagementInterfaceFound = true;
                }
                if (interfaces[i].getName().equals(this.cmpProfileInterfaceName)) {
                    cmpProfileInterfaceFound = true;
                }
                if (this.profileManagementInterfaceName == null || !interfaces[i].getName().equals(this.profileManagementInterfaceName)) continue;
                managementInterfaceFound = true;
            }
            if (!cmpProfileInterfaceFound || !sleeManagementInterfaceFound) {
                logger.error((Object)("A required interface is missing in the Profile management abstract class " + this.managementAbstractClassName));
                return false;
            }
            if (this.profileManagementInterfaceName != null && !managementInterfaceFound) {
                logger.error((Object)("The profileManagement Interface " + this.profileManagementInterfaceName + " defined in the descriptor muste be implemented by Profile " + "management abstract class " + this.managementAbstractClassName));
                return false;
            }
            if (managementInterfaceFound) {
                CtMethod[] managementMethods = this.profileManagementInterface.getDeclaredMethods();
                CtMethod[] methods = this.profileManagementAbstractClass.getDeclaredMethods();
                CtMethod[] cmpProfileMethods = this.cmpProfileInterface.getDeclaredMethods();
                for (int i2 = 0; i2 < managementMethods.length; ++i2) {
                    boolean methodFound = false;
                    int j = 0;
                    while (!methodFound && j < methods.length) {
                        if (ClassUtils.isValidOverride(managementMethods[i2], methods[j])) {
                            methodFound = true;
                            continue;
                        }
                        ++j;
                    }
                    if (!methodFound) {
                        boolean methodInCMPProfileFound = false;
                        int k = 0;
                        while (!methodInCMPProfileFound && k < cmpProfileMethods.length) {
                            if (ClassUtils.isValidOverride(cmpProfileMethods[k], managementMethods[i2])) {
                                methodInCMPProfileFound = true;
                                continue;
                            }
                            ++k;
                        }
                        if (methodInCMPProfileFound) continue;
                        logger.error((Object)("the profile management method " + managementMethods[i2].getName() + " defined in the management interface " + this.profileManagementInterfaceName + " is not implemented in the abstract class " + this.managementAbstractClassName));
                        return false;
                    }
                    int modifiers = methods[j].getModifiers();
                    if (Modifier.isAbstract((int)modifiers) || Modifier.isFinal((int)modifiers) || Modifier.isStatic((int)modifiers)) {
                        logger.error((Object)("the implementation management method " + methods[j] + " cannot be declared abstract, final or static"));
                        return false;
                    }
                    if (Modifier.isPublic((int)modifiers)) continue;
                    logger.error((Object)("the implementation management method " + methods[j] + " must be declared public"));
                    return false;
                }
            }
        }
        catch (NotFoundException nfe) {
            logger.error((Object)("The abstract class " + this.managementAbstractClassName + " does not implements an interface"));
            return false;
        }
        CtMethod[] implementationMethods = this.profileManagementAbstractClass.getDeclaredMethods();
        try {
            this.sleeProfileManagementInterface = this.pool.get("javax.slee.profile.ProfileManagement");
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            return false;
        }
        CtMethod[] sleeManagementMethods = this.sleeProfileManagementInterface.getDeclaredMethods();
        CtMethod[] methods = this.profileManagementAbstractClass.getDeclaredMethods();
        for (i = 0; i < sleeManagementMethods.length; ++i) {
            String methodName = sleeManagementMethods[i].getName();
            boolean methodFound = false;
            int j = 0;
            while (!methodFound && j < methods.length) {
                if (ClassUtils.isValidOverride(sleeManagementMethods[i], methods[j])) {
                    methodFound = true;
                    continue;
                }
                ++j;
            }
            if (!methodFound) {
                if (!methodName.equals("profileInitialize") && !methodName.equals("profileLoad") && !methodName.equals("profileStore") && !methodName.equals("profileVerify")) continue;
                logger.error((Object)(sleeManagementMethods[i].getName() + " not implemented in " + "profile management abstract class " + this.managementAbstractClassName));
                return false;
            }
            int modifiers = methods[j].getModifiers();
            if (methodName.equals("profileInitialize") || methodName.equals("profileLoad") || methodName.equals("profileStore") || methodName.equals("profileVerify")) {
                if (Modifier.isAbstract((int)modifiers) || Modifier.isFinal((int)modifiers) || Modifier.isStatic((int)modifiers)) {
                    logger.error((Object)("the implementation management method " + methods[j].getName() + " cannot be declared abstract, final or static"));
                    return false;
                }
                if (Modifier.isPublic((int)modifiers)) continue;
                logger.error((Object)("the implementation management method " + methods[j].getName() + " must be declared public"));
                return false;
            }
            if (!Modifier.isAbstract((int)modifiers)) {
                logger.error((Object)("the implementation management method " + methods[j].getName() + " must be declared abstract"));
                return false;
            }
            if (Modifier.isPublic((int)modifiers)) continue;
            logger.error((Object)("the implementation management method " + methods[j].getName() + " must be declared public"));
            return false;
        }
        CtMethod[] cmpProfileMethods = this.cmpProfileInterface.getDeclaredMethods();
        for (int i3 = 0; i3 < methods.length; ++i3) {
            String methodName = methods[i3].getName();
            boolean methodFound = false;
            int j = 0;
            while (!methodFound && j < cmpProfileMethods.length) {
                if (ClassUtils.isValidOverride(cmpProfileMethods[j], methods[i3])) {
                    methodFound = true;
                    continue;
                }
                ++j;
            }
            if (!methodFound) continue;
            int modifiers = cmpProfileMethods[j].getModifiers();
            if (!Modifier.isAbstract((int)modifiers)) {
                logger.error((Object)("the implementation management method " + cmpProfileMethods[j].getName() + " must be declared abstract"));
                return false;
            }
            if (Modifier.isPublic((int)modifiers)) continue;
            logger.error((Object)("the implementation management method " + cmpProfileMethods[j].getName() + " must be declared public"));
            return false;
        }
        return true;
    }

    public static int checkCombination(String profileCMPInterfaceName, String profileManagementInterfaceName, String profileManagementAbstractClassName) {
        if (profileCMPInterfaceName == null) {
            return -1;
        }
        if (profileManagementInterfaceName == null && profileManagementAbstractClassName == null) {
            logger.info((Object)"The Profile Specification provided by the Sbb Developer is the combination 1 of JSLEE 1.0 spec section 10.5.2");
            return 1;
        }
        if (profileManagementInterfaceName != null && profileManagementAbstractClassName == null) {
            logger.info((Object)"The Profile Specification provided by the Sbb Developper is the combination 2 of JSLEE 1.0 spec section 10.5.2");
            return 2;
        }
        if (profileManagementInterfaceName == null && profileManagementAbstractClassName != null) {
            logger.info((Object)"The Profile Specification provided by the Sbb Developper is the combination 3 of JSLEE 1.0 spec section 10.5.2");
            return 3;
        }
        if (profileManagementInterfaceName != null && profileManagementAbstractClassName != null) {
            logger.info((Object)"The Profile Specification provided by the Sbb Developper is the combination 4 of JSLEE 1.0 spec section 10.5.2");
            return 4;
        }
        return -1;
    }
}

