/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.profile;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.SLEEException;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.profile.AttributeNotIndexedException;
import javax.slee.profile.AttributeTypeMismatchException;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileMBean;
import javax.slee.profile.ProfileManagement;
import javax.slee.profile.ProfileSpecificationDescriptor;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileVerificationException;
import javax.slee.profile.UnrecognizedAttributeException;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import javax.transaction.SystemException;
import org.apache.log4j.Logger;
import org.jboss.cache.Node;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.deployment.interceptors.DefaultProfileManagementInterceptor;
import org.mobicents.slee.container.deployment.interceptors.ProfileManagementInterceptor;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.management.ProfileSpecificationIDImpl;
import org.mobicents.slee.container.management.jmx.ProfileProvisioningMBeanImpl;
import org.mobicents.slee.container.profile.SingleProfileException;
import org.mobicents.slee.container.profile.SleeProfileManagerMBean;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;
import org.mobicents.slee.runtime.DeferredEvent;
import org.mobicents.slee.runtime.cache.CacheableSet;
import org.mobicents.slee.runtime.facilities.ProfileRemovedEventImpl;
import org.mobicents.slee.runtime.facilities.ProfileTableActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.runtime.facilities.ProfileTableActivityImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;

public class SleeProfileManager
extends ServiceMBeanSupport
implements SleeProfileManagerMBean {
    private static final String PROFILE_INDEXES_SPEC_SUFFIX = "indexes";
    private static final String PROFILEID_LOOKUP_NAME = "profileID";
    public static final String JNDI_NAME = "SleeProfileManager";
    public static final String PROFILEID_LOOKUP_PREFIX = "profile:";
    public final String DEFAULT_PROFILE_LOOKUP_PREFIX = "defaultProfile:";
    public static final String INDEX_LOOKUP_PREFIX = "profileIndexes:";
    private static SleeProfileManager sleeProfileManager;
    private MBeanServer mbeanServer = null;
    private static Logger logger;
    private static boolean isDebugEnabled;
    private HashMap profileTableActivities;
    private static String tcache;
    private static final String PROFILE_TABLE_NAMES = "profileTableNames";
    private ProfileCacheManager profileCacheManager;

    String getRootFqn() {
        return TransactionManagerImpl.getRootFqn(tcache);
    }

    public SleeProfileManager() {
        super(SleeProfileManager.class);
    }

    protected void createService() {
        this.mbeanServer = this.server;
        this.profileTableActivities = new HashMap();
        this.setProfileCacheManager(new ProfileCacheManager());
        sleeProfileManager = this;
    }

    public static synchronized SleeProfileManager getInstance() {
        if (sleeProfileManager == null) {
            throw new SLEEException("Access attempted before initialization of " + SleeProfileManager.class.getName());
        }
        return sleeProfileManager;
    }

    protected void loadProfileTableNames() throws SystemException {
        this.getProfileCacheManager().loadFromCache();
    }

    protected synchronized ObjectName instantiateProfile(String cmpInterfaceName, String profileTableName, String profileName, boolean loadDataFromBackendStorage) throws Exception {
        boolean isDefaultProfile = false;
        if (profileName == null) {
            isDefaultProfile = true;
        }
        String key = null;
        key = isDefaultProfile ? this.generateDefaultProfileKey(profileTableName) : this.generateProfileKey(profileTableName, profileName);
        String cmpConcreteName = "" + cmpInterfaceName + "Impl";
        DefaultProfileManagementInterceptor profileManagementInterceptor = new DefaultProfileManagementInterceptor();
        profileManagementInterceptor.setProfileTableName(profileTableName);
        profileManagementInterceptor.setProfileName(profileName);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> concreteProfileClass = cl.loadClass(cmpConcreteName);
        Constructor<?> constructor = concreteProfileClass.getConstructor(ProfileManagementInterceptor.class, SleeProfileManager.class, String.class);
        ProfileManagement profileManagement = (ProfileManagement)constructor.newInstance(profileManagementInterceptor, this, key);
        if (loadDataFromBackendStorage) {
            profileManagementInterceptor.loadStateFromBackendStorage(cmpInterfaceName);
        } else if (isDefaultProfile) {
            profileManagement.profileInitialize();
            profileManagement.profileStore();
            profileManagement.profileVerify();
            profileManagementInterceptor.persistProfile();
        } else {
            String defaultProfileKey = this.generateDefaultProfileKey(profileTableName);
            profileManagementInterceptor.copyStateFromDefaultProfile(cmpInterfaceName, defaultProfileKey);
        }
        String mbeanConcreteName = "" + cmpInterfaceName + "MBeanImpl";
        Class<?> concreteProfileMBeanClass = Thread.currentThread().getContextClassLoader().loadClass(mbeanConcreteName);
        Constructor<?> profileMBeanConstructor = concreteProfileMBeanClass.getConstructor(ProfileManagementInterceptor.class, Object.class);
        ProfileMBean profileMBean = (ProfileMBean)profileMBeanConstructor.newInstance(profileManagementInterceptor, profileManagement);
        ObjectName objectName = null;
        objectName = isDefaultProfile ? ProfileProvisioningMBeanImpl.getDefaultProfileObjectName(profileTableName) : ProfileProvisioningMBeanImpl.getProfileObjectName(profileTableName, profileName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[instantiateProfile]Registering following profile MBean with object name " + objectName));
        }
        this.mbeanServer.registerMBean(profileMBean, objectName);
        return objectName;
    }

    public void addProfileTable(String profileTableName, ProfileSpecificationDescriptor profileSpecificationDescriptor) throws Exception {
        logger.debug((Object)("addProfileTable " + profileTableName));
        SleeTransactionManager transactionManager = this.getTransactionManager();
        boolean b = false;
        try {
            b = transactionManager.requireTransaction();
            logger.debug((Object)("singleprofile:" + new Boolean(((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getSingleProfile())));
            this.getProfileCacheManager().getProfileTableNames().add(profileTableName);
            this.getProfileCacheManager().addTransactionalAction();
            String key = this.generateProfileTableKey(profileTableName);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("profileSpecificationID", profileSpecificationDescriptor.getName() + "/" + profileSpecificationDescriptor.getVendor() + "/" + profileSpecificationDescriptor.getVersion());
            data.put("cmpInterfaceName", profileSpecificationDescriptor.getCMPInterfaceName());
            data.put("singleProfile", new Boolean(((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getSingleProfile()));
            data.put(PROFILE_INDEXES_SPEC_SUFFIX, ((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getProfileIndexes());
            transactionManager.createNode(tcache, key, data);
            Map indexes = ((ProfileSpecificationDescriptorImpl)profileSpecificationDescriptor).getProfileIndexes();
            if (indexes != null) {
                Iterator keys = indexes.keySet().iterator();
                while (keys.hasNext()) {
                    String attributeName = (String)keys.next();
                    String indexKey = this.generateIndexKey(profileTableName, attributeName);
                    Class<?> profileTransientClass = Thread.currentThread().getContextClassLoader().loadClass("" + profileSpecificationDescriptor.getCMPInterfaceName() + "TransientState");
                    Field profileIndexedField = profileTransientClass.getField(attributeName);
                    HashMap indexedAttributes = new HashMap();
                    data.put("indexedAttributes", indexedAttributes);
                    Class<?> classType = profileIndexedField.getType();
                    if (classType.isArray()) {
                        data.put("classType", classType.getComponentType().getName());
                        data.put("isArray", new Boolean(true));
                    } else {
                        data.put("classType", classType.getName());
                        data.put("isArray", new Boolean(false));
                    }
                    Object isUnique = indexes.get(attributeName);
                    data.put("isUnique", isUnique);
                    if (isDebugEnabled) {
                        logger.debug((Object)("createProfile: indexKey = " + indexKey));
                    }
                    logger.debug((Object)("createProfile: indexKey data = " + data));
                    transactionManager.createNode(tcache, indexKey, data);
                }
            }
            this.instantiateProfile(profileSpecificationDescriptor.getCMPInterfaceName(), profileTableName, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getProfileCacheManager().getProfileTableNames().remove(profileTableName);
            this.getProfileCacheManager().invalidate();
            transactionManager.setRollbackOnly();
            throw e;
        }
        finally {
            this.displayAllProfilePersistentInformation();
            if (b) {
                transactionManager.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeProfileTable(String profileTableName) throws TransactionRequiredLocalException, SystemException, UnrecognizedProfileTableNameException {
        SleeTransactionManager transactionManager = this.getTransactionManager();
        boolean b = false;
        try {
            Map childrens;
            b = transactionManager.requireTransaction();
            if (!this.getProfileCacheManager().getProfileTableNames().contains(profileTableName)) {
                throw new UnrecognizedProfileTableNameException("Could not find profile table " + profileTableName);
            }
            this.getProfileCacheManager().getProfileTableNames().remove(profileTableName);
            if (isDebugEnabled) {
                logger.debug((Object)("removeProfileTable: removing profileTable=" + profileTableName));
            }
            String key = this.generateProfileTableKey(profileTableName);
            String defaultProfileKey = this.generateDefaultProfileKey(profileTableName);
            transactionManager.removeNode(tcache, defaultProfileKey);
            ObjectName objectName = ProfileProvisioningMBeanImpl.getDefaultProfileObjectName(profileTableName);
            if (this.mbeanServer.isRegistered(objectName)) {
                logger.info((Object)("removeProfileTable: Unregistering following profile table MBean with object name " + objectName));
                this.mbeanServer.unregisterMBean(objectName);
            }
            if ((childrens = transactionManager.getChildren(tcache, key)) != null) {
                Iterator it = childrens.values().iterator();
                while (it.hasNext()) {
                    Node profileNode = (Node)it.next();
                    String profileName = profileNode.getFqn().toString().substring(("/" + key + "/").length());
                    objectName = ProfileProvisioningMBeanImpl.getProfileObjectName(profileTableName, profileName);
                    if (this.mbeanServer.isRegistered(objectName)) {
                        logger.info((Object)("removeProfileTable: Unregistering following profile MBean with object name " + objectName));
                        this.mbeanServer.unregisterMBean(objectName);
                        continue;
                    }
                    logger.debug((Object)("removeProfileTable: " + objectName + " is not registered! "));
                }
            }
            SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
            ProfileTableActivityImpl profileTableActivity = this.createProfileTableActivity(profileTableName);
            sleeContainer.getSleeEndpoint().scheduleActivityEndedEvent(profileTableActivity);
        }
        catch (JMException e) {
            logger.error((Object)("Failed to remove profile table: " + profileTableName), (Throwable)e);
            this.getProfileCacheManager().invalidate();
            transactionManager.setRollbackOnly();
        }
        finally {
            this.displayAllProfilePersistentInformation();
            if (b) {
                transactionManager.commit();
            }
        }
    }

    public ObjectName addProfileToProfileTable(String profileTableName, String newProfileName) throws SystemException, SingleProfileException {
        String profileTableKey = this.generateProfileTableKey(profileTableName);
        SleeTransactionManager transactionManager = this.getTransactionManager();
        ObjectName objectName = null;
        boolean b = false;
        try {
            Node profileTableNode;
            Map children;
            b = transactionManager.requireTransaction();
            boolean isSingleProfile = (Boolean)transactionManager.getObject(tcache, profileTableKey, "singleProfile");
            if (isSingleProfile && (children = (profileTableNode = transactionManager.getNode(tcache, profileTableKey)).getChildren()) != null && children.size() >= 1) {
                throw new SingleProfileException();
            }
            String cmpInterfaceName = (String)transactionManager.getObject(tcache, profileTableKey, "cmpInterfaceName");
            objectName = this.instantiateProfile(cmpInterfaceName, profileTableName, newProfileName, false);
        }
        catch (Exception e) {
            if (this.mbeanServer.isRegistered(objectName)) {
                logger.info((Object)("[addProfileToProfileTable]Unregistering following profile MBean with object name " + objectName));
                try {
                    this.mbeanServer.unregisterMBean(objectName);
                }
                catch (Exception e1) {
                    logger.error((Object)("Failed addProfileToProfileTable. Could not unregister " + objectName), (Throwable)e1);
                    throw new SystemException("Failed addProfileToProfileTable");
                }
            }
            logger.error((Object)"Failed addProfileToProfileTable", (Throwable)e);
            transactionManager.setRollbackOnly();
            if (e instanceof SingleProfileException) {
                throw (SingleProfileException)e;
            }
            throw new SystemException("Failed addProfileToProfileTable");
        }
        finally {
            this.displayAllProfilePersistentInformation();
            if (b) {
                transactionManager.commit();
            }
        }
        return objectName;
    }

    public ProfileManagement instantiateLastCommittedProfile(String profileTableName, String profileName) throws Exception {
        String profileKey = null;
        profileKey = profileName != null ? this.generateProfileKey(profileTableName, profileName) : this.generateDefaultProfileKey(profileTableName);
        String profileTableKey = this.generateProfileTableKey(profileTableName);
        logger.debug((Object)("instantiating Last Committed Profile to fire an eventprofileTableKey" + profileTableKey + ",profileKey=" + profileKey));
        String cmpInterfaceName = (String)sleeProfileManager.getTransactionManager().getObject(tcache, profileTableKey, "cmpInterfaceName");
        String cmpConcreteName = "" + cmpInterfaceName + "Impl";
        DefaultProfileManagementInterceptor profileManagementInterceptor = new DefaultProfileManagementInterceptor();
        Class<?> concreteProfileClass = Thread.currentThread().getContextClassLoader().loadClass(cmpConcreteName);
        Constructor<?> constructor = concreteProfileClass.getConstructor(ProfileManagementInterceptor.class, SleeProfileManager.class, String.class);
        ProfileManagement profileManagement = (ProfileManagement)constructor.newInstance(profileManagementInterceptor, this, profileKey);
        profileManagementInterceptor.loadStateFromBackendStorage(cmpInterfaceName);
        return profileManagement;
    }

    public synchronized void removeProfile(String profileTableName, String profileName) throws SystemException {
        SleeTransactionManager transactionManager = this.getTransactionManager();
        boolean b = false;
        try {
            b = transactionManager.requireTransaction();
            logger.info((Object)("removing profile=" + profileName));
            String key = this.generateProfileKey(profileTableName, profileName);
            ProfileManagement profileManagement = this.instantiateLastCommittedProfile(profileTableName, profileName);
            this.removeAllIndexedAttributesOfProfile(profileTableName, profileName);
            transactionManager.removeNode(tcache, key);
            ObjectName objectName = ProfileProvisioningMBeanImpl.getProfileObjectName(profileTableName, profileName);
            ProfileTableActivityContextInterfaceFactoryImpl profileTableActivityContextInterfaceFactory = SleeContainer.getProfileTableActivityContextInterfaceFactory();
            Address profileAddress = new Address(AddressPlan.SLEE_PROFILE, profileTableName + "/" + profileName);
            ProfileTableActivityImpl profileTableActivity = this.createProfileTableActivity(profileTableName);
            ActivityContextInterfaceImpl activityContextInterface = (ActivityContextInterfaceImpl)profileTableActivityContextInterfaceFactory.getActivityContextInterface(profileTableActivity);
            if (!this.mbeanServer.isRegistered(objectName)) {
                logger.info((Object)("removing impossible, MBean " + objectName + " not registered !!!"));
            } else {
                logger.info((Object)("[removeProfile]Unregistering following profile MBean with object name " + objectName));
                this.mbeanServer.unregisterMBean(objectName);
            }
            ProfileRemovedEventImpl profileRemovedEvent = new ProfileRemovedEventImpl(profileAddress, new ProfileID(profileAddress), profileManagement, activityContextInterface, profileTableActivityContextInterfaceFactory);
            SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
            int eventID = serviceContainer.getEventLookupFacility().getEventID(new ComponentKey("javax.slee.profile.ProfileRemovedEvent", "javax.slee", "1.0"));
            DeferredEvent deferredEvent = new DeferredEvent(serviceContainer, eventID, (Object)profileRemovedEvent, serviceContainer.getActivityContextFactory().getActivityFromKey(activityContextInterface.retrieveActivityContextID()), profileAddress);
            sleeProfileManager.getTransactionManager().addAfterCommitAction(deferredEvent);
            logger.debug((Object)("Queued following removed event:" + profileRemovedEvent.getEventTypeID() + ",:" + activityContextInterface.retrieveActivityContextID() + ",eventId=" + eventID));
        }
        catch (Exception e) {
            String err = "Failed removeProfile " + profileName + " from profile table " + profileTableName + " because of " + e.getMessage();
            logger.error((Object)err, (Throwable)e);
            this.getProfileCacheManager().invalidate();
            transactionManager.setRollbackOnly();
            throw new SystemException(err);
        }
        finally {
            this.displayAllProfilePersistentInformation();
            if (b) {
                transactionManager.commit();
            }
        }
    }

    public void removeAllIndexedAttributesOfProfile(String profileTableName, String profileName) throws SystemException {
        SleeTransactionManager transactionManager = this.getTransactionManager();
        Node profileTableIndexesAttribute = transactionManager.getNode(tcache, this.generateIndexKeyRoot(profileTableName));
        if (profileTableIndexesAttribute == null) {
            return;
        }
        Map indexedAttributeNames = profileTableIndexesAttribute.getChildren();
        if (indexedAttributeNames != null) {
            Iterator indexIt = indexedAttributeNames.keySet().iterator();
            while (indexIt.hasNext()) {
                String indexedAttributeName = (String)indexIt.next();
                String indexKey = this.generateIndexKey(profileTableName, indexedAttributeName);
                try {
                    Map indexedAttributes = (Map)transactionManager.getObject(tcache, indexKey, "indexedAttributes");
                    if (indexedAttributes == null) continue;
                    Iterator keys = indexedAttributes.keySet().iterator();
                    while (keys.hasNext()) {
                        String indexedProfileName = (String)keys.next();
                        if (!indexedProfileName.equals(profileName)) continue;
                        indexedAttributes.remove(profileName);
                        keys = indexedAttributes.keySet().iterator();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    String generateProfileTableKey(String profileTableName) {
        return this.getRootFqn() + PROFILEID_LOOKUP_PREFIX + profileTableName;
    }

    private String generateDefaultProfileKey(String profileTableName) {
        String key = this.getRootFqn() + "defaultProfile:" + profileTableName;
        return key;
    }

    private String generateProfileKey(String profileTableName, String profileName) {
        String key = this.generateProfileTableKey(profileTableName) + "/" + profileName;
        return key;
    }

    private String generateIndexKeyRoot(String profileTableName) {
        return this.getRootFqn() + INDEX_LOOKUP_PREFIX + profileTableName;
    }

    private String generateIndexKey(String profileTableName, String attributeName) {
        String key = this.generateIndexKeyRoot(profileTableName) + "/" + attributeName;
        return key;
    }

    public ProfileSpecificationID findProfileSpecId(String profileTableName) throws SystemException {
        ProfileSpecificationIDImpl profileSpecificationID = null;
        SleeTransactionManager transactionManager = this.getTransactionManager();
        boolean b = false;
        try {
            String profileSpecificationIDAsString;
            b = transactionManager.requireTransaction();
            String key = this.generateProfileTableKey(profileTableName);
            if (isDebugEnabled) {
                logger.debug((Object)("key = " + key));
            }
            if ((profileSpecificationIDAsString = (String)transactionManager.getObject(tcache, key, "profileSpecificationID")) == null) {
                ProfileSpecificationIDImpl profileSpecificationIDImpl = profileSpecificationID;
                return profileSpecificationIDImpl;
            }
            ComponentKey componentKey = new ComponentKey(profileSpecificationIDAsString);
            profileSpecificationID = new ProfileSpecificationIDImpl(componentKey);
        }
        catch (RuntimeException e) {
            this.getProfileCacheManager().invalidate();
            transactionManager.setRollbackOnly();
            throw e;
        }
        finally {
            if (b) {
                transactionManager.commit();
            }
        }
        return profileSpecificationID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findAllProfileTables() {
        Vector profileTables = new Vector();
        boolean b = this.getTransactionManager().requireTransaction();
        boolean rb = false;
        try {
            Set set = this.getProfileCacheManager().getProfileTableNames();
            return set;
        }
        catch (Exception e) {
            logger.error((Object)"error getting profile table names ", (Throwable)e);
            rb = true;
        }
        finally {
            this.displayAllProfilePersistentInformation();
            try {
                if (rb) {
                    this.getProfileCacheManager().invalidate();
                    this.getTransactionManager().setRollbackOnly();
                }
                if (b) {
                    this.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("Unexpected tx manager failure ");
            }
        }
        return profileTables;
    }

    public synchronized ObjectName findProfileMBean(String profileTableName, String profileName) {
        ObjectName objectName;
        if (isDebugEnabled) {
            logger.debug((Object)("findProfile: profileTableName = " + profileTableName + " profileName = " + profileName));
        }
        try {
            objectName = ProfileProvisioningMBeanImpl.getProfileObjectName(profileTableName, profileName);
        }
        catch (MalformedObjectNameException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        if (this.mbeanServer.isRegistered(objectName)) {
            return objectName;
        }
        return null;
    }

    public Object findCommittedProfile(String profileTableName, String profileName) throws SystemException {
        if (isDebugEnabled) {
            logger.debug((Object)("findProfile: profileTableName = " + profileTableName + " profileName = " + profileName));
        }
        Object profile = null;
        String key = this.generateProfileKey(profileTableName, profileName);
        profile = this.lookupProfileByKey(key);
        return profile;
    }

    public Object lookupProfileByKey(String key) throws SystemException {
        SleeTransactionManager transactionManager = this.getTransactionManager();
        transactionManager.assertIsInTx();
        if (isDebugEnabled) {
            logger.debug((Object)("key = " + key));
        }
        Node profile = transactionManager.getNode(tcache, key);
        return profile;
    }

    public boolean isProfileCommitted(String profileTableName, String profileName) throws SystemException {
        Object profile = null;
        SleeTransactionManager transactionManager = this.getTransactionManager();
        boolean b = false;
        try {
            b = transactionManager.requireTransaction();
            String key = this.generateProfileKey(profileTableName, profileName);
            if (isDebugEnabled) {
                logger.debug((Object)("key = " + key));
            }
            Node node = transactionManager.getNode(tcache, key);
            logger.debug((Object)("node = " + node));
            profile = this.lookupProfileByKey(key);
        }
        catch (SystemException e) {
            logger.error((Object)"Failed findProfile.", (Throwable)e);
            this.getProfileCacheManager().invalidate();
            transactionManager.setRollbackOnly();
            throw e;
        }
        finally {
            if (b) {
                transactionManager.commit();
            }
        }
        if (profile != null) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("isProfileCommitted: profileTableName " + profileTableName + " profileName " + profileName + " returning false"));
        }
        return false;
    }

    public Collection findAllProfilesByTableName(String profileTableName) {
        SleeTransactionManager transactionManager = this.getTransactionManager();
        Vector<String> profiles = new Vector<String>();
        String lookupKey = this.generateProfileTableKey(profileTableName);
        try {
            Map children = transactionManager.getChildren(tcache, lookupKey);
            if (children != null) {
                Iterator it = children.values().iterator();
                while (it.hasNext()) {
                    Node childNode = (Node)it.next();
                    Object obj = childNode.getData().get(PROFILEID_LOOKUP_NAME);
                    if (obj == null || !(obj instanceof ProfileID)) continue;
                    profiles.add(((ProfileID)obj).getProfileName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return profiles;
    }

    protected void displayAllProfilePersistentInformation() {
    }

    public Collection getProfilesByIndexedAttribute(String profileTableName, String attributeName, Object attributeValue, boolean stopAtFirstMatch) throws UnrecognizedAttributeException, AttributeNotIndexedException, AttributeTypeMismatchException, SystemException {
        SleeTransactionManager transactionManager = this.getTransactionManager();
        String cmpInterfaceName = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" getProfilesByIndexedAttribute ( profileTableName = " + profileTableName + " attributeName = " + attributeName + " attributeValue = " + attributeValue + " )"));
        }
        cmpInterfaceName = (String)transactionManager.getObject(tcache, this.generateProfileTableKey(profileTableName), "cmpInterfaceName");
        try {
            Class<?> profileTransientClass = Class.forName("" + cmpInterfaceName + "TransientState");
            profileTransientClass.getField(attributeName);
        }
        catch (NoSuchFieldException e2) {
            throw new UnrecognizedAttributeException();
        }
        catch (Exception e2) {
            throw new SystemException(e2.getMessage());
        }
        Vector<String> profiles = new Vector<String>();
        String indexKey = this.generateIndexKey(profileTableName, attributeName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getProfilesByIndexedAttribute: indexKey = " + indexKey));
        }
        try {
            Map indexedAttributes = (Map)transactionManager.getObject(tcache, indexKey, "indexedAttributes");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("indexedAttributes = " + indexedAttributes));
            }
            if (indexedAttributes == null) {
                throw new AttributeNotIndexedException();
            }
            String classType = (String)transactionManager.getObject(tcache, indexKey, "classType");
            if (!ClassUtils.getPrimitiveTypeFromClass(attributeValue.getClass().getName()).equals(ClassUtils.getPrimitiveTypeFromClass(classType))) {
                throw new AttributeTypeMismatchException("indexed attribute is of type " + classType + " and attribute value is of type " + attributeValue.getClass().getName());
            }
            Iterator keys = indexedAttributes.keySet().iterator();
            while (keys.hasNext()) {
                String indexedProfileName = (String)keys.next();
                Object profileIndexedAttributeValue = indexedAttributes.get(indexedProfileName);
                if (profileIndexedAttributeValue.getClass().isArray()) {
                    logger.debug((Object)"looking for indexed values in the array!!!!");
                    int length = Array.getLength(profileIndexedAttributeValue);
                    boolean found = false;
                    int i = 0;
                    while (i < length && !found) {
                        Object value;
                        if (!attributeValue.equals(value = Array.get(profileIndexedAttributeValue, i++))) continue;
                        profiles.add(indexedProfileName);
                        if (stopAtFirstMatch) {
                            return profiles;
                        }
                        found = true;
                    }
                    continue;
                }
                logger.debug((Object)("attributeValue = " + attributeValue));
                logger.debug((Object)("profileIndexedAttributeValue = " + profileIndexedAttributeValue));
                if (!attributeValue.equals(profileIndexedAttributeValue)) continue;
                profiles.add(indexedProfileName);
                if (!stopAtFirstMatch) continue;
                return profiles;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new AttributeNotIndexedException();
        }
        return profiles;
    }

    public Object getSbbCMPProfile(ProfileID profileID) throws SystemException {
        SleeTransactionManager transactionManager = this.getTransactionManager();
        String key = this.generateProfileKey(profileID.getProfileTableName(), profileID.getProfileName());
        String profileTableKey = this.generateProfileTableKey(profileID.getProfileTableName());
        String cmpInterfaceName = (String)transactionManager.getObject(tcache, profileTableKey, "cmpInterfaceName");
        String cmpConcreteName = "" + cmpInterfaceName + "Impl";
        DefaultProfileManagementInterceptor profileManagementInterceptor = new DefaultProfileManagementInterceptor(true);
        try {
            ClassLoader cl = SleeContainerUtils.getCurrentThreadClassLoader();
            Class<?> concreteProfileClass = cl.loadClass(cmpConcreteName);
            Constructor<?> constructor = concreteProfileClass.getConstructor(ProfileManagementInterceptor.class, SleeProfileManager.class, String.class);
            return constructor.newInstance(profileManagementInterceptor, this, key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SLEEException("Low-level failure");
        }
    }

    public void setProfileAttributeValue(String profileKey, String profileAttributeName, Object profileAttributeValue) throws TransactionRequiredLocalException, SystemException, ProfileVerificationException {
        SleeTransactionManager transactionManager = this.getTransactionManager();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setProfileAttributeValue ( profileKey = " + profileKey + " profileAttributeName = " + profileAttributeName + " profileAttributeValue = " + profileAttributeValue + " )"));
        }
        if (profileKey.startsWith(this.getRootFqn() + PROFILEID_LOOKUP_PREFIX)) {
            this.verifyProfileIndex(profileKey, profileAttributeName, profileAttributeValue, transactionManager);
        }
        transactionManager.putObject(tcache, profileKey, profileAttributeName, profileAttributeValue);
    }

    private void verifyProfileIndex(String profileKey, String profileAttributeName, Object profileAttributeValue, SleeTransactionManager transactionManager) throws SystemException, ProfileVerificationException {
        String intermediateKey = profileKey.substring((this.getRootFqn() + PROFILEID_LOOKUP_PREFIX).length());
        String profileTableName = intermediateKey.substring(0, intermediateKey.indexOf("/"));
        logger.debug((Object)("setProfileAttributeValue: profileTableName = " + profileTableName));
        String indexKey = this.generateIndexKey(profileTableName, profileAttributeName);
        logger.debug((Object)("setProfileAttributeValue: indexKey = " + indexKey));
        Map indexedAttributes = (Map)transactionManager.getObject(tcache, indexKey, "indexedAttributes");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setProfileAttributeValue: indexedAttributes : " + indexedAttributes));
        }
        if (indexedAttributes != null) {
            Object object = transactionManager.getObject(tcache, indexKey, "isUnique");
            String profileName = profileKey.substring(profileKey.lastIndexOf("/") + 1);
            boolean isUnique = (Boolean)object;
            logger.info((Object)(indexKey + " is unique " + isUnique));
            if (!isUnique) {
                indexedAttributes.put(profileName, profileAttributeValue);
            } else if (indexedAttributes.keySet().size() < 1) {
                logger.info((Object)(indexKey + " has never been indexed before"));
                indexedAttributes.put(profileName, profileAttributeValue);
            } else {
                Iterator keys = new HashSet(indexedAttributes.keySet()).iterator();
                while (keys.hasNext()) {
                    String indexedProfileName = (String)keys.next();
                    Object profileIndexedAttributeValue = indexedAttributes.get(indexedProfileName);
                    logger.info((Object)(indexedProfileName + " value " + profileIndexedAttributeValue));
                    if (profileAttributeValue == null) continue;
                    if (profileAttributeValue.getClass().isArray()) {
                        logger.info((Object)(indexKey + " is an array!!!!"));
                        boolean found = false;
                        int i = 0;
                        if (profileIndexedAttributeValue != null) {
                            int length = Array.getLength(profileIndexedAttributeValue);
                            int length2 = Array.getLength(profileAttributeValue);
                            while (i < length && !found) {
                                Object value = Array.get(profileIndexedAttributeValue, i++);
                                for (int j = 0; j < length2; ++j) {
                                    Object value2 = Array.get(profileAttributeValue, j);
                                    if (!value2.equals(value)) continue;
                                    found = true;
                                }
                            }
                        }
                        indexedAttributes.put(profileName, profileAttributeValue);
                        continue;
                    }
                    logger.info((Object)(indexKey + " is not an array!!!!"));
                    if (profileAttributeValue.equals(profileIndexedAttributeValue)) {
                        throw new ProfileVerificationException("the indexed attribute " + profileAttributeName + " with the value " + profileAttributeValue + " is already indexed.");
                    }
                    indexedAttributes.put(profileName, profileAttributeValue);
                }
            }
        }
    }

    public Object getProfileAttributeValue(String profileKey, String profileAttributeName) throws SystemException {
        return this.getTransactionManager().getObject(tcache, profileKey, profileAttributeName);
    }

    public Object getProfileAttributeValue(ProfileID profileID, String attributeName) throws SystemException {
        return this.getTransactionManager().getObject(tcache, this.generateProfileKey(profileID.getProfileName(), profileID.getProfileName()), attributeName);
    }

    public Map getProfileIndexesSpec(String profileTableName) throws SystemException {
        Map indexes = (Map)this.getTransactionManager().getObject(tcache, this.generateProfileTableKey(profileTableName), PROFILE_INDEXES_SPEC_SUFFIX);
        return indexes;
    }

    public boolean profileExist(ProfileID profileID) throws SystemException {
        ObjectName profileFound = this.findProfileMBean(profileID.getProfileTableName(), profileID.getProfileName());
        return profileFound != null;
    }

    public SleeTransactionManager getTransactionManager() {
        return SleeContainer.getTransactionManager();
    }

    public synchronized void unregisterProfileMBean(String profileKey) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("unregisterProfileMBean " + profileKey));
        }
        ObjectName objectName = null;
        if (profileKey.startsWith(PROFILEID_LOOKUP_PREFIX)) {
            String profileTableName = profileKey.substring(0, profileKey.indexOf("/"));
            String profileName = profileKey.substring(profileKey.indexOf("/") + 1);
            objectName = ProfileProvisioningMBeanImpl.getProfileObjectName(profileTableName, profileName);
        } else {
            String profileTableName = profileKey.substring("defaultProfiles/".length());
            SleeProfileManager.toValidJmxName(profileTableName);
            objectName = ProfileProvisioningMBeanImpl.getDefaultProfileObjectName(profileTableName);
        }
        logger.info((Object)("[unregisterProfile]Unregistering following profile MBean with object name " + objectName));
        this.mbeanServer.unregisterMBean(objectName);
    }

    public void renameProfileTable(String oldProfileTableName, String newProfileTableName, ProfileSpecificationDescriptor profileSpecificationDescriptor) throws Exception {
        SleeTransactionManager transactionManager = this.getTransactionManager();
        boolean b = false;
        try {
            b = transactionManager.requireTransaction();
            this.removeProfileTable(oldProfileTableName);
            this.addProfileTable(newProfileTableName, profileSpecificationDescriptor);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to rename profile table: " + oldProfileTableName), (Throwable)e);
            transactionManager.setRollbackOnly();
            throw e;
        }
        finally {
            this.displayAllProfilePersistentInformation();
            if (b) {
                transactionManager.commit();
            }
        }
    }

    public static String toValidJmxName(String jmxName) {
        String jmxObjectName = SleeProfileManager.replace(jmxName, "\\", "");
        jmxObjectName = SleeProfileManager.replace(jmxObjectName, "\"", "\\\"");
        jmxObjectName = SleeProfileManager.replace(jmxObjectName, "*", "\\*");
        jmxObjectName = SleeProfileManager.replace(jmxObjectName, "?", "\\?");
        char car = '\'';
        char car2 = '`';
        jmxObjectName = SleeProfileManager.replace(jmxObjectName, "" + car, "");
        jmxObjectName = SleeProfileManager.replace(jmxObjectName, "" + car2, "");
        jmxObjectName = ObjectName.quote(jmxObjectName);
        return jmxObjectName;
    }

    public static String replace(String str, String strToReplace, String newStr) {
        String string = "";
        StringTokenizer st = new StringTokenizer(str, strToReplace);
        while (st.hasMoreTokens()) {
            string = string.concat(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            string = string + newStr;
        }
        if (string.length() < 1) {
            return str;
        }
        return string;
    }

    public synchronized ProfileTableActivityImpl createProfileTableActivity(String profileTableName) {
        ProfileTableActivityImpl profileTableActivity = (ProfileTableActivityImpl)this.profileTableActivities.get(profileTableName);
        if (profileTableActivity == null) {
            profileTableActivity = new ProfileTableActivityImpl(profileTableName);
            this.profileTableActivities.put(profileTableName, profileTableActivity);
        }
        return profileTableActivity;
    }

    public void removeProfileAfterTableActivityEnd(String profileTableName) {
        try {
            this.profileTableActivities.remove(profileTableName);
            String indexesKey = this.generateIndexKeyRoot(profileTableName);
            SleeContainer.getTransactionManager().removeNode(tcache, indexesKey);
            String tableKey = this.generateProfileTableKey(profileTableName);
            SleeContainer.getTransactionManager().removeNode(tcache, tableKey);
            this.getProfileCacheManager().getProfileTableNames().remove(profileTableName);
            this.getProfileCacheManager().addTransactionalAction();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error accessing cache! ", ex);
        }
    }

    public boolean profileTableExists(String profileTableName) throws SystemException {
        return this.findProfileSpecId(profileTableName) != null;
    }

    public HashMap getProfileTableActivities() {
        return this.profileTableActivities;
    }

    public Object findDefaultProfile(String profileTableName) throws SystemException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("findDefaultProfile: profileTableName = " + profileTableName));
        }
        String key = this.generateDefaultProfileKey(profileTableName);
        Object profile = this.lookupProfileByKey(key);
        return profile;
    }

    void setProfileCacheManager(ProfileCacheManager profileCacheManager) {
        this.profileCacheManager = profileCacheManager;
    }

    ProfileCacheManager getProfileCacheManager() {
        return this.profileCacheManager;
    }

    public Object loadObjectFromCache(String fqn, String key) throws SystemException {
        return this.getTransactionManager().getObject(tcache, fqn, key);
    }

    public Object loadNodeFromCache(String fqn) throws SystemException {
        return this.getTransactionManager().getNode(tcache, fqn);
    }

    static {
        logger = Logger.getLogger((Class)SleeProfileManager.class);
        isDebugEnabled = logger.isDebugEnabled();
        tcache = TransactionManagerImpl.PROFILE_CACHE;
    }

    class ProfileCacheManager {
        private Set profileTableNames;

        private ProfileCacheManager() {
        }

        public void invalidate() {
        }

        public void loadFromCache() {
        }

        public synchronized Set getProfileTableNames() {
            if (this.profileTableNames == null) {
                this.profileTableNames = new CacheableSet(tcache + "-" + SleeProfileManager.PROFILE_TABLE_NAMES);
            }
            return this.profileTableNames;
        }

        public String getNodeName() {
            return "profileInfo";
        }

        public void addTransactionalAction() throws SystemException {
        }
    }
}

