/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mobicents.slee.container.xml.XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    public static Document parseDocument(String url, boolean validating, EntityResolver resolver) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (resolver != null) {
                builder.setEntityResolver(resolver);
            }
            return builder.parse(url);
        }
        catch (SAXParseException e) {
            throw new XMLException("A parse error occurred at " + e.getSystemId() + ":" + e.getLineNumber(), e);
        }
        catch (SAXException e) {
            throw new XMLException("An Error occurred while reading document", e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException("Conguration error.", e);
        }
    }

    public static String getElementTextValue(Element element) throws IllegalArgumentException, XMLException {
        if (element == null) {
            throw new IllegalArgumentException("The specified element is null");
        }
        NodeList nodelist = element.getChildNodes();
        if (nodelist.getLength() == 0) {
            return "";
        }
        if (nodelist.getLength() != 1 || nodelist.item(0).getNodeType() != 3) {
            throw new XMLException("Not a text node: " + element);
        }
        return nodelist.item(0).getNodeValue().trim();
    }

    public static String getElementTextValue(Element parent, String name) throws XMLException {
        return XMLUtils.getElementTextValue(XMLUtils.getChildElement(parent, name, true));
    }

    public static Element getChildElement(Element parent, String name, boolean assertUnique) throws IllegalArgumentException, XMLException {
        Iterator elements = XMLUtils.getAllChildElements(parent, name).iterator();
        if (elements.hasNext()) {
            Element element = (Element)elements.next();
            if (assertUnique && elements.hasNext()) {
                throw new XMLException("Multiple \"" + name + "\" occurrences of are not allowed");
            }
            return element;
        }
        throw new XMLException("No \"" + name + "\" element was found.");
    }

    public static List getAllChildElements(Element parent, String name) throws IllegalArgumentException {
        if (parent == null) {
            throw new IllegalArgumentException("The specified parent is null.");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Null or empty element name!");
        }
        NodeList nodelist = parent.getChildNodes();
        ArrayList<Element> children = new ArrayList<Element>(nodelist.getLength());
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            if (node.getNodeType() != 1 || !name.equals(((Element)node).getTagName())) continue;
            children.add((Element)node);
        }
        return children;
    }
}

