/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource;

import java.io.Serializable;
import java.util.HashSet;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.ResourceAdaptorIDImpl;
import org.mobicents.slee.resource.ActivityTypeEntry;
import org.mobicents.slee.resource.ResourceAdaptorDescriptorImpl;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorType;
import org.mobicents.slee.resource.ResourceAdaptorTypeClassEntry;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;

public class InstalledResourceAdaptor
implements Serializable {
    private static final String CTX_JAVA_SLEE_RESOURCES = "java:slee/resources";
    private ResourceAdaptorIDImpl resourceAdaptorId;
    private Class resourceAdaptorClass;
    private String raAciName;
    private String[] activityInterfaceNames;
    private String raInterfaceFactory;
    private HashSet resourceAdaptorEntities = new HashSet();
    private transient SleeContainer container;
    private ResourceAdaptorDescriptorImpl descriptor;
    private ResourceAdaptorType raType;
    private static transient Logger log = Logger.getLogger((Class)InstalledResourceAdaptor.class);

    public InstalledResourceAdaptor() {
    }

    public void addResourceAdaptorEntity(ResourceAdaptorEntity raEntity) {
        this.resourceAdaptorEntities.add(raEntity);
    }

    public void removeResourceAdaptorEntity(ResourceAdaptorEntity raEntity) {
        this.resourceAdaptorEntities.remove(raEntity);
    }

    public HashSet getResourceAdaptorEntities() {
        return this.resourceAdaptorEntities;
    }

    public ResourceAdaptorDescriptorImpl getDescriptor() {
        return this.descriptor;
    }

    public ResourceAdaptorIDImpl getKey() {
        return this.resourceAdaptorId;
    }

    public String getRaAciName() {
        return this.raAciName;
    }

    public String getRaInterfaceFactory() {
        return this.raInterfaceFactory;
    }

    public ResourceAdaptorType getRaType() {
        return this.raType;
    }

    public Class getResourceAdaptorClass() {
        return this.resourceAdaptorClass;
    }

    public void uninstall() {
        this.raType.getResourceAdaptorIDs().remove(this.descriptor.getID());
        this.unbindFromJndi();
    }

    public InstalledResourceAdaptor(SleeContainer container, ResourceAdaptorDescriptorImpl raDescr, ResourceAdaptorIDImpl resourceAdaptorId) throws ClassNotFoundException {
        this.container = container;
        this.resourceAdaptorId = resourceAdaptorId;
        this.resourceAdaptorClass = Thread.currentThread().getContextClassLoader().loadClass(raDescr.getResourceAdaptorClasses().getResourceAdaptorClass());
        this.descriptor = raDescr;
        ResourceAdaptorTypeIDImpl ratRef = (ResourceAdaptorTypeIDImpl)raDescr.getResourceAdaptorType();
        this.raType = container.getResourceAdaptorType(ratRef);
        if (log.isDebugEnabled()) {
            log.debug((Object)("RA TYPE >>>>>>>>>>>> " + this.raType));
        }
        ResourceAdaptorTypeClassEntry classEntry = this.raType.getRaTypeDescr().getRaClassEntry();
        this.raAciName = classEntry.getAcifInterfaceEntry().getInterfaceName();
        this.raInterfaceFactory = classEntry.getRaInterfaceFactoryEntry().getName();
        ActivityTypeEntry[] activityEntries = classEntry.getActivityTypeEntries();
        this.activityInterfaceNames = new String[activityEntries.length];
        for (int i = 0; i < activityEntries.length; ++i) {
            this.activityInterfaceNames[i] = activityEntries[i].getActivityTypeName();
        }
        this.bindInJndi();
    }

    private void bindInJndi() {
        try {
            InitialContext ctx = new InitialContext();
            ComponentKey key = this.resourceAdaptorId.getComponentKey();
            Util.createSubcontext((Context)ctx, (String)("java:slee/resources/" + key.getName() + "/" + key.getVendor() + "/" + key.getVersion()));
        }
        catch (NamingException e) {
            log.error((Object)("Failed binding RA in JNDI. RA ID: " + this.resourceAdaptorId), (Throwable)e);
        }
    }

    private void unbindFromJndi() {
        try {
            InitialContext ctx = new InitialContext();
            ComponentKey key = this.resourceAdaptorId.getComponentKey();
            Util.unbind((Context)ctx, (String)("java:slee/resources/" + key.getName() + "/" + key.getVendor() + "/" + key.getVersion()));
        }
        catch (NamingException e) {
            log.error((Object)("Failed binding RA in JNDI. RA ID: " + this.resourceAdaptorId), (Throwable)e);
        }
    }
}

