/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.slee.CreateException;
import javax.slee.InvalidStateException;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import org.apache.commons.jxpath.util.TypeUtils;
import org.jboss.logging.Logger;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.naming.Util;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ConfigPropertyDescriptor;
import org.mobicents.slee.resource.InstalledResourceAdaptor;
import org.mobicents.slee.resource.ResourceAdaptorDescriptorImpl;

public class ResourceAdaptorEntity
implements Serializable {
    private static final long serialVersionUID = 6314789586609488087L;
    private InstalledResourceAdaptor installedResourceAdaptor;
    private transient BootstrapContext raContext;
    private String raInterfaceJNDIName;
    private String raFactoryInterfaceJNDIName;
    private transient ResourceAdaptor resourceAdaptor;
    private ResourceAdaptorEntityState state;
    private String name;
    private SleeContainer serviceContainer;
    private static Logger log = Logger.getLogger((Class)ResourceAdaptorEntity.class);

    public ResourceAdaptorEntity(String name, InstalledResourceAdaptor ra, BootstrapContext context, SleeContainer serviceContainer) throws CreateException {
        this.name = name;
        this.installedResourceAdaptor = ra;
        this.raContext = context;
        this.state = ResourceAdaptorEntityState.INACTIVE;
        this.serviceContainer = serviceContainer;
        this.create();
    }

    public ResourceAdaptor getResourceAdaptor() {
        return this.resourceAdaptor;
    }

    public InstalledResourceAdaptor getInstalledResourceAdaptor() {
        return this.installedResourceAdaptor;
    }

    public String getInterfaceJNDIName() {
        return this.raInterfaceJNDIName;
    }

    public String getFactoryInterfaceJNDIName() {
        return this.raFactoryInterfaceJNDIName;
    }

    private void setupNamingContext() {
        try {
            String prefix = "slee/resources/" + this.installedResourceAdaptor.getDescriptor().getName() + "/" + this.installedResourceAdaptor.getDescriptor().getVendor() + "/" + this.installedResourceAdaptor.getDescriptor().getVersion();
            Object object = this.resourceAdaptor.getSBBResourceAdaptorInterface(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource Adaptor Object: " + object));
            }
            String GLOBAL_ENV = "java:";
            Context ctx = new InitialContext();
            ctx = (Context)ctx.lookup(GLOBAL_ENV + prefix);
            try {
                ctx = ctx.createSubcontext(this.name);
            }
            catch (NameAlreadyBoundException e) {
                log.warn((Object)("Context, " + this.name + " is already bounded"));
                log.warn((Object)e);
                ctx = (Context)ctx.lookup(this.name);
            }
            prefix = prefix + "/" + this.name;
            String factoryProvider = "factoryprovider";
            NonSerializableFactory.rebind((String)(GLOBAL_ENV + prefix + "/" + factoryProvider), (Object)object);
            StringRefAddr addr = new StringRefAddr("nns", GLOBAL_ENV + prefix + "/" + factoryProvider);
            log.debug((Object)("=============== object:" + object + " addr:" + addr + " ==================="));
            Reference ref = new Reference(object.getClass().getName(), addr, NonSerializableFactory.class.getName(), null);
            ctx.rebind(factoryProvider, (Object)ref);
            ctx.close();
            this.raInterfaceJNDIName = "java:slee/resources/" + this.installedResourceAdaptor.getDescriptor().getName() + "/" + this.installedResourceAdaptor.getDescriptor().getVendor() + "/" + this.installedResourceAdaptor.getDescriptor().getVersion() + "/" + this.name;
            this.raFactoryInterfaceJNDIName = this.raInterfaceJNDIName + "/" + factoryProvider;
        }
        catch (Exception e) {
            log.warn((Object)"Failed setting up Naming Context", (Throwable)e);
        }
    }

    private void cleanNamingContext() throws NamingException {
        InitialContext ctx = new InitialContext();
        Util.unbind((Context)ctx, (String)this.getFactoryInterfaceJNDIName());
        Util.unbind((Context)ctx, (String)this.getInterfaceJNDIName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Context " + this.getFactoryInterfaceJNDIName() + " unbound from Naming Service"));
        }
    }

    public void create() throws CreateException {
        try {
            Constructor cons = this.installedResourceAdaptor.getResourceAdaptorClass().getConstructor(null);
            this.resourceAdaptor = (ResourceAdaptor)cons.newInstance(null);
            this.resourceAdaptor.entityCreated(this.raContext);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CreateException("Could not create ", (Throwable)ex);
        }
        catch (Error er) {
            er.printStackTrace();
            throw er;
        }
    }

    public BootstrapContext getBootstrapContext() {
        return this.raContext;
    }

    public void activate() throws ResourceException, InvalidStateException {
        if (this.state != ResourceAdaptorEntityState.INACTIVE) {
            throw new InvalidStateException("Resource Adaptor Entity wrong state: " + this.state);
        }
        this.resourceAdaptor.entityActivated();
        this.setupNamingContext();
        this.state = ResourceAdaptorEntityState.ACTIVE;
    }

    public void deactivate() throws InvalidStateException {
        if (this.state != ResourceAdaptorEntityState.ACTIVE) {
            throw new InvalidStateException("Resource Adaptor Entity wrong state: " + this.state);
        }
        this.resourceAdaptor.entityDeactivating();
        this.resourceAdaptor.entityDeactivated();
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            log.debug((Object)e);
        }
        this.state = ResourceAdaptorEntityState.INACTIVE;
    }

    public void serviceInstalled(String serviceID, int[] eventIDs, String[] resourceOptions) {
        this.resourceAdaptor.serviceInstalled(serviceID, eventIDs, resourceOptions);
    }

    public void serviceUninstalled(String serviceID) {
        this.resourceAdaptor.serviceUninstalled(serviceID);
    }

    public void serviceActivated(String serviceID) {
        this.resourceAdaptor.serviceActivated(serviceID);
    }

    public void serviceDeactivated(String serviceID) {
        this.resourceAdaptor.serviceDeactivated(serviceID);
    }

    public void remove() throws InvalidStateException {
        if (this.state != ResourceAdaptorEntityState.INACTIVE) {
            throw new InvalidStateException("Resource Adaptor Entity wrong state: " + this.state);
        }
        this.resourceAdaptor.entityRemoved();
    }

    public String accessorName(String prefix, String name) {
        return prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public void setConfigProperty(ConfigPropertyDescriptor propertyDescriptor, Object value) throws InvalidStateException, ResourceException {
        Method method;
        if (this.state != ResourceAdaptorEntityState.INACTIVE) {
            throw new InvalidStateException("Resource Adaptor Entity wrong state: " + this.state);
        }
        String methodName = this.accessorName("set", propertyDescriptor.getName());
        Class[] signature = null;
        try {
            signature = new Class[]{Class.forName(propertyDescriptor.getType())};
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            method = this.resourceAdaptor.getClass().getMethod(methodName, signature);
        }
        catch (SecurityException ex) {
            throw new ResourceException(ex.getMessage());
        }
        catch (NoSuchMethodException ex) {
            throw new ResourceException(this.resourceAdaptor.getClass() + " should implement property accessor method " + methodName + "(" + propertyDescriptor.getType() + ")");
        }
        Object[] args = new Object[]{value};
        try {
            method.invoke((Object)this.resourceAdaptor, args);
        }
        catch (Exception ex) {
            throw new ResourceException("Failed to set " + value + " to " + this.name + ". Caused by " + ex.getMessage());
        }
    }

    public Object getConfigProperty(ConfigPropertyDescriptor propertyDescriptor) throws ResourceException {
        Method method;
        String methodName = this.accessorName("get", propertyDescriptor.getName());
        Class[] signature = new Class[]{};
        try {
            method = this.resourceAdaptor.getClass().getMethod(methodName, signature);
        }
        catch (SecurityException ex) {
            throw new ResourceException(ex.getMessage());
        }
        catch (NoSuchMethodException ex) {
            throw new ResourceException(this.resourceAdaptor.getClass() + " should implement property accessor method " + propertyDescriptor.getType() + " " + methodName + "()");
        }
        try {
            return method.invoke((Object)this.resourceAdaptor, new Object[0]);
        }
        catch (Exception ex) {
            throw new ResourceException("Failed to get value of " + this.name + ". Caused by " + ex.getMessage());
        }
    }

    public void configure(Properties properties) throws InvalidStateException, ResourceException {
        ResourceAdaptorDescriptorImpl raDescriptor = this.installedResourceAdaptor.getDescriptor();
        Collection configDescriptors = raDescriptor.getConfigPropertyDescriptors();
        Iterator list = configDescriptors.iterator();
        while (list.hasNext()) {
            ConfigPropertyDescriptor property = (ConfigPropertyDescriptor)list.next();
            Object value = null;
            if (properties != null && properties.containsKey(property.getName())) {
                String lexicalValue = properties.getProperty(property.getName());
                try {
                    Class<?> clazz = Class.forName(property.getType());
                    value = TypeUtils.convert((Object)lexicalValue, clazz);
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Failed reading property[" + property.getName() + "] while configuring RA Entity [" + this.name + "]. Because of: "), (Throwable)e);
                }
            } else {
                value = property.getValue();
            }
            this.setConfigProperty(property, value);
        }
    }

    public SleeContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceAdaptorEntity)) {
            return false;
        }
        ResourceAdaptorEntity rae = (ResourceAdaptorEntity)o;
        return rae.name.compareTo(this.name) == 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public ResourceAdaptorEntityState getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }
}

