/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceAdaptorInterface;
import com.opencloud.sleetck.lib.resource.adaptor.TCKResourceEventHandler;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEvent;
import java.rmi.RemoteException;
import javax.slee.Address;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.CouldNotStartActivityException;
import javax.slee.resource.SleeEndpoint;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.tck.TCKActivityHandle;

public class TCKResourceEventHandlerImpl
implements TCKResourceEventHandler {
    private SleeEndpoint sleeEndpoint;
    private EventLookupFacility eventLookup;
    private static Logger logger = Logger.getLogger((Class)SleeContainer.class);
    private TCKResourceAdaptorInterface raInterface;

    public TCKResourceEventHandlerImpl(BootstrapContext ctx, TCKResourceAdaptorInterface raInterface) {
        this.raInterface = raInterface;
        this.sleeEndpoint = ctx.getSleeEndpoint();
        this.eventLookup = ctx.getEventLookupFacility();
    }

    public void handleEvent(TCKResourceEvent eventObj, String eventType, TCKActivityID activityObj, Address address) throws TCKTestErrorException, RemoteException {
        int eventTypeId;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event Type :" + eventType));
        }
        String name = eventType;
        String vendor = "jain.slee.tck";
        String version = "1.0";
        try {
            eventTypeId = this.eventLookup.getEventID(name, vendor, version);
        }
        catch (FacilityException e1) {
            e1.printStackTrace();
            throw new RuntimeException("Failed to lookup Event!", e1);
        }
        catch (UnrecognizedEventException e1) {
            e1.printStackTrace();
            throw new RuntimeException("Failed to lookup Event!", e1);
        }
        try {
            this.sleeEndpoint.fireEvent((ActivityHandle)new TCKActivityHandle(activityObj), (Object)eventObj, eventTypeId, address);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException("unexpected exception ", e2);
        }
        logger.debug((Object)"fireEvent competed");
    }

    public void handleActivityEnd(TCKActivityID tckActivityID, boolean arg1) throws TCKTestErrorException, RemoteException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TCKActivity ID " + tckActivityID));
        }
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)new TCKActivityHandle(tckActivityID));
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
    }

    public void handleActivityCreatedBySbb(TCKActivityID activityID) throws TCKTestErrorException, RemoteException {
        try {
            this.sleeEndpoint.activityStarted((ActivityHandle)new TCKActivityHandle(activityID));
        }
        catch (ActivityAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (CouldNotStartActivityException e) {
            e.printStackTrace();
        }
    }
}

