/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.naming.NamingException;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.facilities.TimerID;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.ActivityContextState;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbEntityFactory;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.cache.CacheableSet;
import org.mobicents.slee.runtime.facilities.ActivityContextNamingFacilityImpl;
import org.mobicents.slee.runtime.facilities.NullActivityImpl;
import org.mobicents.slee.runtime.facilities.TimerFacilityImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;
import org.mobicents.slee.runtime.transaction.TransactionalAction;

public class ActivityContext {
    private static final long serialVersionUID = 487857681918072300L;
    private static final String tcache;
    private transient CacheableMap activityContextCacheMap;
    private transient CacheableSet attachedTimers;
    private transient Map acSbbAttachmentSet = null;
    private static final String SBB_ATTACHMENT_SET = "acSbbAttachmentSet";
    private static final String AC_STATE = "acState";
    private transient CacheableSet namingBinding;
    CacheableMap dataAttributes;
    private static final String DELIVERED_SBB_SET = "acDeliveredSbbSet";
    SleeTransactionManager txManager;
    private Object activity;
    private static transient Logger logger;
    private String activityContextId;
    private transient SleeContainer sleeContainer;
    private transient SbbEntityFactory sbbEntityFactory;
    private transient SbbEntityComparator sbbEntityComparator;
    private boolean isMarkedForRemoval = false;
    private static final String txLocalNullAciCheckKey = "tx-local-flag-NullActivityImplicitEndCheckAction";
    static final /* synthetic */ boolean $assertionsDisabled;

    private void printNode() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityContext.printNode() { \nactivityContextId = " + this.getActivityContextId() + "\nsbbAttachmentSet = " + this.getSbbAttachmentSetForDebug() + "\ngetDeliveredSet() = " + this.getDeliveredSetForDebug() + "\nnamingBinding  = " + this.getNamingBinding() + "\nattachedTimers = " + this.getAttachedTimers() + "\nstate = " + this.getState() + "\ndata. = " + this.getData() + "}"));
        }
    }

    private ActivityContext(String activityContextId, Object activity) throws SystemException {
        if (!$assertionsDisabled && activity == null) {
            throw new AssertionError((Object)("activity cannot be null, for activity context ID " + activityContextId));
        }
        if (!$assertionsDisabled && activityContextId == null) {
            throw new AssertionError((Object)"activity Id cannot be null");
        }
        this.activity = activity;
        this.activityContextId = activityContextId;
        this.txManager = SleeContainer.getTransactionManager();
        this.sleeContainer = SleeContainer.lookupFromJndi();
        this.sbbEntityFactory = this.sleeContainer.getSbbEntityFactory();
        this.sbbEntityComparator = new SbbEntityComparator(this.sbbEntityFactory);
        this.init();
    }

    public static ActivityContext createActivityContext(String activityId, Object activity) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityContext.createActivityContext(): Creating activity context for " + activity));
        }
        ActivityContext ac = new ActivityContext(activityId, activity);
        if (logger.isDebugEnabled()) {
            ac.printNode();
        }
        return ac;
    }

    private void init() {
        this.txManager.mandateTransaction();
        this.activityContextCacheMap = new CacheableMap(tcache + "-" + this.getNodeNameInCache());
        String ATTACHED_TIMERS = "acAttachedTimers";
        this.attachedTimers = new CacheableSet(tcache + "-" + this.getNodeNameInCache() + ":" + "acAttachedTimers");
        String DATA_ATTRIBUTES = "acDataAttributes";
        this.dataAttributes = new CacheableMap(tcache + "-" + this.getNodeNameInCache() + ":" + "acDataAttributes");
        String NAMING_BINDING = "acNamingBinding";
        this.namingBinding = new CacheableSet(tcache + "-" + this.getNodeNameInCache() + ":" + "acNamingBinding");
        this.acSbbAttachmentSet = new CacheableMap(tcache + "-" + SBB_ATTACHMENT_SET + ":" + this.activityContextId);
        Object o = this.activityContextCacheMap.get(AC_STATE);
        if (o == null) {
            this.activityContextCacheMap.put(AC_STATE, ActivityContextState.ACTIVE);
            this.activityContextCacheMap.put(DELIVERED_SBB_SET, new HashSet());
        }
    }

    public String getNodeNameInCache() {
        if (!$assertionsDisabled && this.activityContextId == null) {
            throw new AssertionError((Object)"activityContextId cannot be null!");
        }
        return "activitycontext:" + this.activityContextId;
    }

    private String makeSbbEntityKeyForAttachmentSet(SbbEntity sbbe) {
        String sbbEntityId = sbbe.getSbbEntityId();
        return sbbe.getPriority() + 150 + "_" + sbbEntityId;
    }

    public synchronized boolean attachSbbEntity(String sbbEntityId) throws TransactionRequiredLocalException {
        this.txManager.mandateTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityContext.attach() : " + sbbEntityId + " activityContextId = " + this.activityContextId));
        }
        SbbEntity sbbe = this.sbbEntityFactory.getSbbEntity(sbbEntityId);
        if (!this.getSbbAttachmentSet().containsKey(this.makeSbbEntityKeyForAttachmentSet(sbbe))) {
            this.getSbbAttachmentSet().put(this.makeSbbEntityKeyForAttachmentSet(sbbe), sbbEntityId);
            sbbe.afterACAttach(this.activityContextId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("After Attach to Activity Context : Attachment Set = " + this.getSbbAttachmentSet()));
            }
            return true;
        }
        return false;
    }

    private void updateCacheEntry(String attributeKey) {
        Object o = this.activityContextCacheMap.get(attributeKey);
        this.activityContextCacheMap.put(attributeKey, o);
    }

    public synchronized void detachSbbEntity(String sbbEntityId) {
        SbbEntity sbbE = this.sbbEntityFactory.getSbbEntity(sbbEntityId);
        Map sbbAttachmentSet = this.getSbbAttachmentSet();
        if (sbbAttachmentSet.containsKey(this.makeSbbEntityKeyForAttachmentSet(sbbE))) {
            sbbAttachmentSet.remove(this.makeSbbEntityKeyForAttachmentSet(sbbE));
            if (logger.isDebugEnabled()) {
                try {
                    logger.info((Object)("Detaching SbbEntity[ID:" + sbbEntityId + "] \n" + "  from ActivityContext[ID:" + this.activityContextId + "]\n" + "  Remaining SbbEntities: " + sbbAttachmentSet.keySet() + "\n" + "  Transaction[ID:" + this.txManager.getTransaction() + "]"));
                }
                catch (SystemException e) {
                    logger.warn((Object)"Failed to obtain transaction", (Throwable)e);
                }
            }
        }
        this.sleeContainer.getSbbEntityFactory().getSbbEntity(sbbEntityId).afterACDetach(this.activityContextId);
        this.scheduleCheckForNullActivityImplicitEnd();
    }

    public synchronized List getSortedCopyOfSbbAttachmentSet() {
        TreeMap sbbSet = new TreeMap(this.sbbEntityComparator);
        Map sbbAttachmentSet = this.getSbbAttachmentSet();
        if (logger.isDebugEnabled()) {
            try {
                logger.info((Object)("ActivityContext[ID:" + this.activityContextId + "],\n" + "  SbbAttachmentSet: " + sbbAttachmentSet.keySet() + ",\n  Transaction[ID:" + this.txManager.getTransaction() + "]"));
            }
            catch (SystemException e) {
                logger.warn((Object)"Failed to obtain transaction", (Throwable)e);
            }
        }
        sbbSet.putAll(sbbAttachmentSet);
        return new LinkedList(sbbSet.values());
    }

    public Object getActivity() {
        return this.activity;
    }

    public void setActivity(Object activity) {
        this.activity = activity;
    }

    public synchronized void setState(ActivityContextState activityContextState) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityContext.setState( " + activityContextState + " )"));
        }
        if (!this.getState().equals(activityContextState)) {
            this.setAcState(activityContextState);
        }
    }

    public synchronized boolean isEnding() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityContext.isEnding(): state = " + this.getState()));
        }
        this.getState();
        return this.getAcState().equals(ActivityContextState.ENDING);
    }

    public boolean isInvalid() {
        return this.isMarkedForRemoval || this.getState().equals(ActivityContextState.INVALID);
    }

    public synchronized ActivityContextState getState() {
        return this.getAcState();
    }

    public synchronized void setDataAttribute(String key, Object newValue) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityContext.setDataAttribute(): " + key + " value " + newValue));
        }
        this.dataAttributes.put(key, newValue);
    }

    public synchronized Object getDataAttribute(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityContext.getDataAttribute(): " + key));
        }
        return this.dataAttributes.get(key);
    }

    private Object getData() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ActivityContext.getData()");
        }
        return this.dataAttributes;
    }

    public synchronized boolean isRemovable() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("isRemovable(): attachmentSet = " + this.getSbbAttachmentSet() + " state = " + this.getState()));
        }
        return this.getSbbAttachmentSet().size() == 0 && this.getState().equals(ActivityContextState.INVALID);
    }

    public synchronized void removeNamingBindings() {
        Iterator iterator = this.getNamingBinding().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            try {
                ActivityContextNamingFacilityImpl acf = (ActivityContextNamingFacilityImpl)this.sleeContainer.getActivityContextNamingFacility();
                acf.unbindWithoutCheck(name);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to unbind name: " + name + " from activity context Id:" + this.activityContextId), (Throwable)e);
            }
        }
    }

    public synchronized void removeFromTimers() {
        TimerFacilityImpl timerFacility = null;
        try {
            timerFacility = (TimerFacilityImpl)SleeContainer.getTimerFacility();
        }
        catch (NamingException ex) {
            logger.error((Object)"cannot retieve timer facility", (Throwable)ex);
            return;
        }
        Iterator iter = new HashSet(this.getAttachedTimers()).iterator();
        while (iter.hasNext()) {
            TimerID timerID = (TimerID)iter.next();
            timerFacility.cancelTimer(timerID);
        }
    }

    public synchronized void addNameBinding(String aciName) {
        this.getNamingBinding().add(aciName);
    }

    private Set getNamingBinding() {
        return this.namingBinding;
    }

    private Set getDeliveredSet() {
        Set ds = (Set)this.activityContextCacheMap.get(DELIVERED_SBB_SET);
        return ds;
    }

    public synchronized void removeNameBinding(String aciName) {
        if (this.getNamingBinding().contains(aciName)) {
            this.getNamingBinding().remove(aciName);
            this.scheduleCheckForNullActivityImplicitEnd();
        }
    }

    public synchronized void attachTimer(TimerID timerID) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("attachTimer(" + timerID + ")"));
        }
        if (!this.getAttachedTimers().contains(timerID)) {
            this.getAttachedTimers().add(timerID);
        }
    }

    private void checkForNullActivityImplicitEnd() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Checking for implicit end");
        }
        this.activityContextCacheMap.remove(txLocalNullAciCheckKey);
        if (!this.isEnding() && !this.isInvalid()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"It's a nullactivity");
            }
            if (this.getSbbAttachmentSet().size() == 0 && this.getAttachedTimers().size() == 0 && this.getNamingBinding().size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"sending end event");
                }
                this.sleeContainer.getSleeEndpoint().scheduleActivityEndedEvent(this.getActivity());
            }
        }
    }

    private void scheduleCheckForNullActivityImplicitEnd() {
        if (!(this.getActivity() instanceof NullActivityImpl)) {
            return;
        }
        if (this.activityContextCacheMap.get(txLocalNullAciCheckKey) != null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Scheduling checking for implicit NullActivity end at the end of the ongoing transaction");
        }
        TransactionalAction implicitEndCheck = new TransactionalAction(){

            public void execute() {
                ActivityContext.this.checkForNullActivityImplicitEnd();
            }
        };
        this.activityContextCacheMap.put(txLocalNullAciCheckKey, Boolean.TRUE);
        this.txManager.addPrepareCommitAction(implicitEndCheck);
    }

    public synchronized void addToDeliveredSet(String sbbEid) {
        this.getDeliveredSet().add(sbbEid);
        this.updateCacheEntry(DELIVERED_SBB_SET);
    }

    public synchronized void refreshActivityContext(Object activity) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityContext.refreshActivityContext(): Loading activity context for " + activity));
        }
        this.activity = activity;
        if (logger.isDebugEnabled()) {
            this.printNode();
        }
    }

    public void markForRemove() {
        this.activityContextCacheMap.remove();
        this.attachedTimers.remove();
        this.namingBinding.remove();
        this.dataAttributes.remove();
        this.isMarkedForRemoval = true;
    }

    public synchronized boolean deliveredSetContains(String sbbEntityId) {
        return this.getDeliveredSet().contains(sbbEntityId);
    }

    public synchronized String getDeliveredSetForDebug() {
        return this.getDeliveredSet().toString();
    }

    public synchronized void clearDeliveredSet() {
        Set ds = (Set)this.activityContextCacheMap.get(DELIVERED_SBB_SET);
        ds.clear();
        this.activityContextCacheMap.put(DELIVERED_SBB_SET, ds);
    }

    public synchronized boolean removeFromDeliveredSet(String sbbEntityId) {
        Set ds = this.getDeliveredSet();
        boolean retval = ds.contains(sbbEntityId);
        if (retval) {
            ds.remove(sbbEntityId);
            this.updateCacheEntry(DELIVERED_SBB_SET);
        }
        return retval;
    }

    public synchronized String getSbbAttachmentSetForDebug() {
        return this.getSbbAttachmentSet().toString();
    }

    public String getActivityContextId() {
        return this.activityContextId;
    }

    public synchronized void detachTimer(TimerID timerID, boolean checkForActivityEnd) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("detachTimer ( timerID= " + timerID + ", checkForAcEnd =" + checkForActivityEnd + ")"));
        }
        if (this.getAttachedTimers().contains(timerID)) {
            this.getAttachedTimers().remove(timerID);
            if (checkForActivityEnd) {
                this.scheduleCheckForNullActivityImplicitEnd();
            }
        }
    }

    private Set getAttachedTimers() {
        return this.attachedTimers;
    }

    private Map getSbbAttachmentSet() {
        return this.acSbbAttachmentSet;
    }

    private void setAcState(ActivityContextState acState) {
        this.activityContextCacheMap.put(AC_STATE, acState);
    }

    private ActivityContextState getAcState() {
        ActivityContextState acState = (ActivityContextState)this.activityContextCacheMap.get(AC_STATE);
        return acState != null ? acState : ActivityContextState.ACTIVE;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.activityContextId + "]";
    }

    static {
        $assertionsDisabled = !ActivityContext.class.desiredAssertionStatus();
        tcache = TransactionManagerImpl.RUNTIME_CACHE;
        logger = Logger.getLogger((Class)ActivityContext.class);
    }

    private class SbbEntityComparator
    implements Comparator {
        SbbEntityFactory sbbEntityFactory;

        SbbEntityComparator(SbbEntityFactory sbbEntityFactory) {
            this.sbbEntityFactory = sbbEntityFactory;
        }

        private Stack priorityOfSbb(SbbEntity sbbe) {
            Stack<SbbEntity> stack = new Stack<SbbEntity>();
            String sbbeId = null;
            do {
                sbbeId = sbbe.getSbbEntityId();
                stack.push(sbbe);
            } while (!sbbeId.equals((sbbe = this.sbbEntityFactory.getSbbEntity(sbbe.getParentSbbId())).getRootSbbId()));
            return stack;
        }

        public int compare(Object priority1_sbbeId1, Object priority2_sbbeId2) {
            if (priority1_sbbeId1.equals(priority2_sbbeId2)) {
                return 0;
            }
            String[] split = null;
            split = ((String)priority1_sbbeId1).split("_");
            String sbbeId1 = split[1];
            split = ((String)priority2_sbbeId2).split("_");
            String sbbeId2 = split[1];
            SbbEntity sbbe1 = this.sbbEntityFactory.getSbbEntity(sbbeId1);
            SbbEntity sbbe2 = this.sbbEntityFactory.getSbbEntity(sbbeId2);
            return this.higherPrioritySbb(sbbe1, sbbe2);
        }

        private int higherPrioritySbb(SbbEntity sbbe1, SbbEntity sbbe2) {
            SbbEntity sbb2a;
            SbbEntity sbb1a;
            logger.debug((Object)("higherPrioritySbb " + sbbe1.getSbbId() + " " + sbbe2.getSbbId()));
            Stack stack1 = this.priorityOfSbb(sbbe1);
            Stack stack2 = this.priorityOfSbb(sbbe2);
            while ((sbb1a = (SbbEntity)stack1.pop()) == (sbb2a = (SbbEntity)stack2.pop())) {
                if (stack1.isEmpty()) {
                    return -1;
                }
                if (!stack2.isEmpty()) continue;
                return 1;
            }
            if (sbb1a.getPriority() > sbb2a.getPriority()) {
                return -1;
            }
            if (sbb1a.getPriority() < sbb2a.getPriority()) {
                return 1;
            }
            return sbb1a.getSbbEntityId().compareTo(sbb2a.getSbbEntityId());
        }
    }
}

