/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.rmi.dgc.VMID;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class ActivityContextFactoryImpl
implements ActivityContextFactory {
    private static Logger log = Logger.getLogger((Class)ActivityContextFactoryImpl.class);
    private Map activityToActivityContextIdMap = new ConcurrentReaderHashMap(500);
    private Map activityContextIdToActivityMap = new ConcurrentReaderHashMap(500);
    private static String ACID_AC_MAP = "ActivityContextIdToActivityContextMap";
    private SleeTransactionManager tm = SleeContainer.getTransactionManager();

    public ActivityContextFactoryImpl(SleeContainer container) {
    }

    private Map getActivityContextIdToActivityContextMap() {
        SleeTransactionManager stm = SleeContainer.getTransactionManager();
        HashMap hmap = (HashMap)stm.getTxLocalData(ACID_AC_MAP);
        if (hmap == null) {
            hmap = new HashMap(20);
            stm.putTxLocalData(ACID_AC_MAP, hmap);
        }
        return hmap;
    }

    private ActivityContext getActivityContext(String ac_id, Object activity) throws Exception {
        ActivityContext ac = (ActivityContext)this.getActivityContextIdToActivityContextMap().get(ac_id);
        if (ac == null) {
            ac = ActivityContext.createActivityContext(ac_id, activity);
            this.getActivityContextIdToActivityContextMap().put(ac_id, ac);
        }
        ac.refreshActivityContext(activity);
        return ac;
    }

    public ActivityContext getActivityContext(Object activity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActivityContext(): for Object " + activity));
        }
        String ac_id = null;
        ActivityContext ac = null;
        if (activity == null) {
            throw new RuntimeException("an activity is null");
        }
        ac_id = (String)this.activityToActivityContextIdMap.get(activity);
        if (ac_id == null) {
            VMID vmid = new VMID();
            ac_id = vmid.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("getActivityContext(): Putting in the hashmap " + ac_id + " " + activity));
            }
            this.activityToActivityContextIdMap.put(activity, ac_id);
            this.activityContextIdToActivityMap.put(ac_id, activity);
            boolean tran2 = this.tm.requireTransaction();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating AC for key " + ac_id));
                }
                ac = ActivityContext.createActivityContext(ac_id, activity);
                this.getActivityContextIdToActivityContextMap().put(ac_id, ac);
                ActivityContext activityContext = ac;
                return activityContext;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Tree Cache Failure.", e);
            }
            finally {
                if (tran2) {
                    try {
                        this.tm.commit();
                    }
                    catch (SystemException e) {
                        log.error((Object)"Transaction is failed to commit!");
                        throw new RuntimeException("Transaction is failed to commit", e);
                    }
                }
            }
        }
        boolean tran = this.tm.requireTransaction();
        try {
            ActivityContext tran2 = ac = this.getActivityContext(ac_id, activity);
            return tran2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Tree Cache Failure.", e);
        }
        finally {
            if (tran) {
                try {
                    this.tm.commit();
                }
                catch (SystemException e) {
                    log.error((Object)"Transaction is failed to commit!");
                    throw new RuntimeException("Transaction is failed to commit", e);
                }
            }
        }
    }

    public ActivityContext restoreActivityContext(Object activity, String ac_id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActivityContext(): for Object " + activity));
        }
        if (ac_id == null) {
            throw new NullPointerException("Null Activity ID ");
        }
        ActivityContext ac = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActivityContext(): Putting in the hashmap " + ac_id + " " + activity));
        }
        this.activityToActivityContextIdMap.put(activity, ac_id);
        this.activityContextIdToActivityMap.put(ac_id, activity);
        boolean tran = this.tm.requireTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating AC for key " + ac_id));
            }
            ac = ActivityContext.createActivityContext(ac_id, activity);
            this.getActivityContextIdToActivityContextMap().put(ac_id, ac);
            ActivityContext activityContext = ac;
            return activityContext;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Tree Cache Failure.", e);
        }
        finally {
            if (tran) {
                try {
                    this.tm.commit();
                }
                catch (SystemException e) {
                    log.error((Object)"Transaction is failed to commit!");
                    throw new RuntimeException("Transaction is failed to commit", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllActivityContexts() {
        HashSet<ActivityContext> retval = new HashSet<ActivityContext>();
        Map map = this.activityContextIdToActivityMap;
        synchronized (map) {
            Iterator it = this.activityContextIdToActivityMap.keySet().iterator();
            while (it.hasNext()) {
                String acid = (String)it.next();
                ActivityContext activityContext = this.getActivityContextById(acid);
                retval.add(activityContext);
            }
        }
        return retval;
    }

    public ActivityContext getActivityContextById(String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActivityContextByKey(): key  = " + key));
        }
        Object activity = null;
        activity = this.activityContextIdToActivityMap.get(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActivityContextByKey(): Activity for key is " + activity));
        }
        if (activity == null) {
            return null;
        }
        ActivityContext ac = (ActivityContext)this.getActivityContextIdToActivityContextMap().get(key);
        boolean tran = this.tm.requireTransaction();
        try {
            if (ac != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getActivityContextByKey():  getting ac from map " + ac));
                    log.debug((Object)("getActivityContextByKey(): MAP AC: key to AC " + this.getActivityContextIdToActivityContextMap()));
                }
                try {
                    ac.refreshActivityContext(activity);
                }
                catch (Exception e1) {
                    throw new RuntimeException("TreeCache failure!");
                }
                ActivityContext e1 = ac;
                return e1;
            }
            ac = ActivityContext.createActivityContext(key, activity);
            this.getActivityContextIdToActivityContextMap().put(key, ac);
            if (log.isDebugEnabled()) {
                log.debug((Object)("MAP AC: key to AC " + this.getActivityContextIdToActivityContextMap()));
                log.debug((Object)("getActivityContextbyKey: getting ac from cache " + ac));
            }
            ActivityContext e1 = ac;
            return e1;
        }
        catch (Exception e) {
            throw new RuntimeException("Tree Cache Failure.", e);
        }
        finally {
            if (tran) {
                try {
                    this.tm.commit();
                }
                catch (SystemException e) {
                    log.error((Object)"Transaction is failed to commit!");
                    throw new RuntimeException("Transaction is failed to commit", e);
                }
            }
        }
    }

    public void removeActivityContext(String acId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeActiviytContext() : " + acId));
        }
        if (acId != null) {
            boolean tran = this.tm.requireTransaction();
            try {
                ActivityContext activityContext = (ActivityContext)this.getActivityContextIdToActivityContextMap().get(acId);
                if (activityContext != null) {
                    activityContext.markForRemove();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Tree Cache Failure.", e);
            }
            finally {
                if (tran) {
                    try {
                        this.tm.commit();
                    }
                    catch (SystemException e) {
                        log.error((Object)"Transaction is failed to commit!");
                        throw new RuntimeException("Transaction is failed to commit", e);
                    }
                }
            }
            Object activity = this.activityContextIdToActivityMap.remove(acId);
            this.activityToActivityContextIdMap.remove(activity);
            this.getActivityContextIdToActivityContextMap().remove(acId);
        }
    }

    public int getActivityContextCount() {
        return this.activityToActivityContextIdMap.size();
    }

    public boolean isAnyACActive() {
        Iterator iter = this.getAllActivityContexts().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            ActivityContext ac = (ActivityContext)o;
            if (ac.isRemovable()) continue;
            return true;
        }
        return false;
    }

    public String getActivityContextId(Object activity) {
        return (String)this.activityToActivityContextIdMap.get(activity);
    }

    public Object getActivityFromKey(String key) {
        Object retval = this.activityContextIdToActivityMap.get(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getActivityFromKey () : " + key + " returning " + retval));
        }
        return retval;
    }

    public ActivityContext createActivityContext(Object activity, String acId) {
        this.activityContextIdToActivityMap.put(acId, activity);
        return this.getActivityContextById(acId);
    }

    public void removeFromCache(String activityContextId) {
        block2: {
            try {
                SleeContainer.getTransactionManager().removeTxLocalData("ac" + activityContextId);
            }
            catch (SystemException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Failed to remove activity context, " + activityContextId + "from tx cache"));
            }
        }
    }
}

