/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import javax.slee.ActivityContextInterface;
import javax.slee.SLEEException;
import javax.slee.SbbLocalObject;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.TransactionRolledbackLocalException;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.SleeActivityHandle;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.ActivityContextIDInterface;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbLocalObjectImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class ActivityContextInterfaceImpl
implements ActivityContextIDInterface,
ActivityContextInterface {
    private SleeContainer serviceContainer;
    private ActivityContextFactory acif;
    private String acId;
    private static Logger logger = Logger.getLogger((Class)ActivityContextInterfaceImpl.class);

    public ActivityContextInterfaceImpl(SleeContainer serviceContainer, String activityContextId) {
        if (activityContextId == null) {
            throw new NullPointerException("Null activityContextId Crap!");
        }
        this.serviceContainer = serviceContainer;
        this.acif = serviceContainer.getActivityContextFactory();
        this.acId = activityContextId;
    }

    public ActivityContext getActivityContext() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Getting activity context");
        }
        return this.acif.getActivityContextById(this.acId);
    }

    public Object getActivity() throws TransactionRequiredLocalException, SLEEException {
        SleeContainer.getTransactionManager().mandateTransaction();
        Object activity = this.acif.getActivityFromKey(this.acId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getActivity() : activity = " + activity));
        }
        if (activity instanceof SleeActivityHandle) {
            SleeActivityHandle sleeHandle = (SleeActivityHandle)activity;
            Object ret = sleeHandle.getActivity();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getActivity(): returning " + ret));
            }
            return ret;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getActivity(): returning " + activity));
        }
        return activity;
    }

    public void attach(SbbLocalObject sbbLocalObject) throws NullPointerException, TransactionRequiredLocalException, TransactionRolledbackLocalException, SLEEException {
        ActivityContext localAc;
        if (sbbLocalObject == null) {
            throw new NullPointerException("null SbbLocalObject !");
        }
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        txMgr.mandateTransaction();
        SbbLocalObjectImpl sbbLocalObjectImpl = (SbbLocalObjectImpl)sbbLocalObject;
        String sbbeId = sbbLocalObjectImpl.getSbbEntityId();
        this.assertValidSbbEntity(txMgr, sbbeId);
        boolean attached = this.getActivityContext().attachSbbEntity(sbbeId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityContextInterface.attach(): ACI attach Called for " + sbbLocalObject + " ACID = " + this.acId + "SbbEntityId " + sbbeId));
        }
        if (attached && (localAc = this.acif.getActivityContextById(this.acId)).removeFromDeliveredSet(sbbeId) && logger.isDebugEnabled()) {
            logger.debug((Object)("Removed the SBB Entity [" + sbbeId + "] from the delivered set of activity context [" + localAc.getActivityContextId() + "]. Seems to be a reattachment after detachment in the same event delivery transaction. See JSLEE 1.0 Spec, Section 8.5.8."));
        }
    }

    private void assertValidSbbEntity(SleeTransactionManager txMgr, String sbbeId) throws TransactionRolledbackLocalException {
        try {
            SbbEntity sbbEntity = this.serviceContainer.getSbbEntityFactory().getSbbEntity(sbbeId);
            if (sbbEntity == null || sbbEntity.isRemoved()) {
                txMgr.setRollbackOnly();
                throw new TransactionRolledbackLocalException("Failed to attach invalid sbb entity. SbbID " + sbbeId);
            }
        }
        catch (Exception e) {
            if (e instanceof TransactionRolledbackLocalException) {
                throw (TransactionRolledbackLocalException)e;
            }
            try {
                txMgr.setRollbackOnly();
            }
            catch (SystemException e1) {
                logger.error((Object)"Failed to setRollbackOnly()", (Throwable)e1);
            }
            throw new TransactionRolledbackLocalException("Failed to attach invalid sbb entity. SbbID " + sbbeId);
        }
    }

    public void detach(SbbLocalObject sbbLocalObject) throws NullPointerException, TransactionRequiredLocalException, TransactionRolledbackLocalException, SLEEException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ACI detach called for : " + sbbLocalObject + " ACID = " + this.acId));
        }
        if (sbbLocalObject == null) {
            throw new NullPointerException("null SbbLocalObject !");
        }
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        txMgr.mandateTransaction();
        SbbLocalObjectImpl sbbLocalObjectImpl = (SbbLocalObjectImpl)sbbLocalObject;
        String sbbeId = sbbLocalObjectImpl.getSbbEntityId();
        this.assertValidSbbEntity(txMgr, sbbeId);
        ActivityContext localAc = this.acif.getActivityContextById(this.acId);
        localAc.detachSbbEntity(sbbeId);
    }

    public boolean isEnding() throws TransactionRequiredLocalException, SLEEException {
        SleeContainer.getTransactionManager().mandateTransaction();
        ActivityContext localAc = this.acif.getActivityContextById(this.acId);
        return localAc.isEnding();
    }

    public String retrieveActivityContextID() {
        return this.acId;
    }

    public ActivityContext retrieveActivityContext() {
        return this.getActivityContext();
    }
}

