/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import javax.slee.ActivityContextInterface;
import javax.slee.NotAttachedException;
import javax.slee.SLEEException;
import javax.slee.SbbContext;
import javax.slee.SbbID;
import javax.slee.SbbLocalObject;
import javax.slee.ServiceID;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.Tracer;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.ActivityContextIDInterface;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbLocalObjectImpl;
import org.mobicents.slee.runtime.SbbObject;
import org.mobicents.slee.runtime.SbbObjectState;

public class SbbContextImpl
implements SbbContext,
Serializable {
    private static final long serialVersionUID = -7746746092548069113L;
    private static volatile Logger logger = Logger.getLogger((Class)SbbContextImpl.class);
    private SbbObject sbbObject;
    protected volatile SleeContainer serviceContainer;

    public SbbContextImpl(SbbObject sbbObject, SleeContainer serviceContainer) {
        this.sbbObject = sbbObject;
        this.serviceContainer = serviceContainer;
    }

    public ActivityContextInterface[] getActivities() throws TransactionRequiredLocalException, IllegalStateException, SLEEException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getActivities() " + this.sbbObject.getState()));
        }
        if (SbbObjectState.READY != this.sbbObject.getState()) {
            throw new IllegalStateException("Cannot call SbbContext getActivities in " + this.sbbObject.getState());
        }
        Set activities = this.sbbObject.getSbbEntity().getActivityContexts();
        ActivityContextInterface[] aci = new ActivityContextInterface[activities.size()];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The Sbb is attached to " + activities.size() + "activities"));
        }
        Iterator it = activities.iterator();
        int i = 0;
        while (it.hasNext()) {
            String acId = (String)it.next();
            aci[i++] = new ActivityContextInterfaceImpl(this.serviceContainer, acId);
        }
        return aci;
    }

    public String[] getEventMask(ActivityContextInterface aci) throws NullPointerException, TransactionRequiredLocalException, IllegalStateException, NotAttachedException, SLEEException {
        if (aci == null) {
            throw new NullPointerException("Activity Context Interface cannot be null.");
        }
        if (this.sbbObject == null || this.sbbObject.getState() != SbbObjectState.READY) {
            throw new IllegalStateException("Wrong state! " + (this.sbbObject == null ? null : this.sbbObject.getState()));
        }
        SleeContainer.getTransactionManager().mandateTransaction();
        String acId = ((ActivityContextIDInterface)aci).retrieveActivityContextID();
        if (!this.sbbObject.getSbbEntity().checkAttached(acId)) {
            throw new NotAttachedException("ACI not attached to SBB");
        }
        return this.sbbObject.getSbbEntity().getEventMask(acId);
    }

    public boolean getRollbackOnly() throws TransactionRequiredLocalException, SLEEException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("in getRollbackOnly on " + this));
        }
        try {
            return SleeContainer.getTransactionManager().getRollbackOnly();
        }
        catch (SystemException e) {
            throw new SLEEException("Problem with the tx manager!");
        }
    }

    public SbbID getSbb() throws SLEEException {
        return (SbbID)this.sbbObject.getSbbDescriptor().getID();
    }

    public SbbLocalObject getSbbLocalObject() throws TransactionRequiredLocalException, IllegalStateException, SLEEException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (this.sbbObject == null || this.sbbObject.getSbbEntity() == null || !this.sbbObject.getState().equals(SbbObjectState.READY)) {
            throw new IllegalStateException("Bad state : " + this.sbbObject.getState());
        }
        Class sbbLocalClass = this.sbbObject.getSbbDescriptor().getLocalInterfaceConcreteClass();
        if (sbbLocalClass != null) {
            Object[] objs = new Object[]{this.sbbObject.getSbbEntity()};
            Class[] types = new Class[]{SbbEntity.class};
            try {
                return (SbbLocalObject)sbbLocalClass.getConstructor(types).newInstance(objs);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to create Sbb Local Interface.", e);
            }
        }
        return new SbbLocalObjectImpl(this.sbbObject.getSbbEntity());
    }

    public ServiceID getService() throws SLEEException {
        return this.sbbObject.getSbbEntity().getService().getServiceID();
    }

    public void maskEvent(String[] eventNames, ActivityContextInterface aci) throws NullPointerException, TransactionRequiredLocalException, IllegalStateException, UnrecognizedEventException, NotAttachedException, SLEEException {
        if (SbbObjectState.READY != this.sbbObject.getState()) {
            throw new IllegalStateException("Cannot call SbbContext maskEvent in " + this.sbbObject.getState());
        }
        SleeContainer.getTransactionManager().mandateTransaction();
        String acId = ((ActivityContextIDInterface)aci).retrieveActivityContextID();
        if (!this.sbbObject.getSbbEntity().checkAttached(acId)) {
            throw new NotAttachedException("ACI is not attached to SBB ");
        }
        this.sbbObject.getSbbEntity().setEventMask(acId, eventNames);
    }

    public void setRollbackOnly() throws TransactionRequiredLocalException, SLEEException {
        SleeContainer.getTransactionManager().mandateTransaction();
        logger.debug((Object)("in setRollbackOnly on " + this));
        try {
            SleeContainer.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException e) {
            throw new SLEEException("tx manager failure!");
        }
    }

    public Tracer getTracer(String arg0) throws NullPointerException, IllegalArgumentException, SLEEException {
        return null;
    }
}

