/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.EventTypeID;
import javax.slee.RolledBackContext;
import javax.slee.SLEEException;
import javax.slee.SbbID;
import javax.slee.SbbLocalObject;
import javax.slee.ServiceID;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedEventException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRequiredException;
import org.apache.commons.pool.ObjectPool;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.ChildRelationImpl;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.management.CMPField;
import org.mobicents.slee.container.management.EventTypeDescriptorImpl;
import org.mobicents.slee.container.management.EventTypeIDImpl;
import org.mobicents.slee.container.management.GetChildRelationMethod;
import org.mobicents.slee.container.management.SbbDescriptorImpl;
import org.mobicents.slee.container.management.SbbEventEntry;
import org.mobicents.slee.container.management.SbbIDImpl;
import org.mobicents.slee.container.management.SbbRef;
import org.mobicents.slee.container.management.ServiceIDImpl;
import org.mobicents.slee.container.service.Service;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;
import org.mobicents.slee.runtime.EventRouterImpl;
import org.mobicents.slee.runtime.RolledBackContextImpl;
import org.mobicents.slee.runtime.SbbConcrete;
import org.mobicents.slee.runtime.SbbEntityFactory;
import org.mobicents.slee.runtime.SbbLocalObjectImpl;
import org.mobicents.slee.runtime.SbbObject;
import org.mobicents.slee.runtime.SbbObjectState;
import org.mobicents.slee.runtime.SleeEvent;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.cache.CacheableSet;
import org.mobicents.slee.runtime.serviceactivity.ServiceActivityFactoryImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;
import org.mobicents.slee.runtime.transaction.TransactionalAction;

public class SbbEntity {
    private transient SbbEntityFactory sbbEntityFactory;
    private static transient Logger log;
    private transient Transaction transaction;
    transient SleeEvent currentEvent;
    private transient SbbDescriptorImpl sbbComponent;
    private String sbbeId;
    static final String tcache;
    private final String ATTACHMENT_COUNT = "attachmentCount";
    private static final String ROOT_SBB_ID = "rootSbbId";
    private static final String PARENT_SBB_ID = "parentSbbId";
    private static final String SERVICE_CONVERGENCE_NAME = "serviceConvergenceName";
    private static final String SBB_ID_CACHE;
    private static final String SBB_ID = "sbbID";
    private SbbObject sbbObject;
    private static final String ACTIVITY_CONTEXTS_CACHE;
    private static final String ACTIVITY_CONTEXTS = "activityContexts";
    private static final String PRIORITY = "priority";
    private static final String EVENT_MASK_CACHE;
    private CacheableMap eventMask;
    private static final String EVENT_MASK = "eventMask";
    private transient SleeContainer serviceContainer;
    private static final String SBB_LOCAL_OBJECT_CMP_FIELDS = "sbbLocalObjectCmpFields";
    private CacheableSet sbbLocalObjectCmpFields;
    private CacheableMap childRelations;
    private static final String CHILD_RELATIONS_CACHE;
    public static final String CHILD_RELATIONS = "childRelations";
    private TransactionManagerImpl tm;
    private static final String SERVICE_ID = "serviceId";
    private ObjectPool pool;
    private static final String CMP_FIELDS_CACHE;
    private static final String CMP_FIELDS = "cmpFields";
    private CacheableMap cmpFields;
    private CacheableMap cachedSbbEntityAttributes;
    private boolean isBeingRemoved = false;
    private static final String CACHED_SBBE_ATTRS = "cached-sbb-entitiy-attributes";

    public SbbEntity(String sbbeId, SbbID sbbID, String convergenceName, ServiceID svcId) throws Exception {
        if (sbbID == null) {
            throw new NullPointerException("Null sbbID");
        }
        this.serviceContainer = SleeContainer.lookupFromJndi();
        this.sbbEntityFactory = this.serviceContainer.getSbbEntityFactory();
        this.tm = (TransactionManagerImpl)SleeContainer.getTransactionManager();
        this.sbbeId = sbbeId;
        this.init();
        this.setSbbId(sbbID);
        this.setServiceId(svcId);
        this.setServiceConvergenceName(convergenceName);
        this.pool = this.serviceContainer.getObjectPool(this.getSbbId());
        this.sbbComponent = (SbbDescriptorImpl)SleeContainer.lookupFromJndi().getSbbComponent(this.getSbbId());
        if (this.sbbComponent == null) {
            String s = "Sbb component/descriptor not found for sbbID[" + this.getSbbId() + "],\n" + "  sbbEntityID[" + sbbeId + "],\n" + "  Transaction[ID:" + this.tm.getTransaction() + "]";
            log.warn((Object)s);
            throw new RuntimeException(s);
        }
        this.createChildRelations();
    }

    private void init() {
        this.sbbLocalObjectCmpFields = new CacheableSet(CMP_FIELDS_CACHE + "-" + SBB_LOCAL_OBJECT_CMP_FIELDS + ":" + this.getNodeName());
        this.eventMask = new CacheableMap(EVENT_MASK_CACHE + "-" + EVENT_MASK + ":" + this.getNodeName());
        this.cmpFields = new CacheableMap(CMP_FIELDS_CACHE + "-" + CMP_FIELDS + ":" + this.getNodeName());
        this.cachedSbbEntityAttributes = new CacheableMap(SBB_ID_CACHE + "-" + CACHED_SBBE_ATTRS + ":" + this.getNodeName());
        this.childRelations = new CacheableMap(CHILD_RELATIONS_CACHE + "-" + CHILD_RELATIONS + ":" + this.getNodeName());
        this.setActivityContexts(new CacheableSet(ACTIVITY_CONTEXTS_CACHE + "-" + ACTIVITY_CONTEXTS + "_" + this.sbbeId));
        this.setAttachmentCount(0);
        this.sbbObject = null;
    }

    public ServiceID getServiceId() {
        ServiceID svcId = (ServiceID)this.getObjectFromCache(SERVICE_ID);
        return svcId;
    }

    private void setServiceId(ServiceID svcId) {
        this.putObjectInCache(SERVICE_ID, svcId);
    }

    private void setServiceConvergenceName(String convergenceName) {
        this.putObjectInCache(SERVICE_CONVERGENCE_NAME, convergenceName);
    }

    public String getServiceConvergenceName() {
        String convergenceName = (String)this.getObjectFromCache(SERVICE_CONVERGENCE_NAME);
        return convergenceName;
    }

    public SbbEntity(String sbbeId) {
        if (sbbeId == null) {
            throw new NullPointerException("SbbEntity cannot be instantiated for sbbeId == null");
        }
        this.serviceContainer = SleeContainer.lookupFromJndi();
        this.sbbEntityFactory = this.serviceContainer.getSbbEntityFactory();
        this.tm = (TransactionManagerImpl)SleeContainer.getTransactionManager();
        this.sbbeId = sbbeId;
        this.eventMask = new CacheableMap(EVENT_MASK_CACHE + "-" + EVENT_MASK + ":" + this.getNodeName());
        this.childRelations = new CacheableMap(CHILD_RELATIONS_CACHE + "-" + CHILD_RELATIONS + ":" + this.getNodeName());
        this.sbbLocalObjectCmpFields = new CacheableSet(CMP_FIELDS_CACHE + "-" + SBB_LOCAL_OBJECT_CMP_FIELDS + ":" + this.getNodeName());
        this.cmpFields = new CacheableMap(CMP_FIELDS_CACHE + "-" + CMP_FIELDS + ":" + this.getNodeName());
        this.cachedSbbEntityAttributes = new CacheableMap(SBB_ID_CACHE + "-" + CACHED_SBBE_ATTRS + ":" + this.getNodeName());
        this.setActivityContexts(new CacheableSet(ACTIVITY_CONTEXTS_CACHE + "-" + ACTIVITY_CONTEXTS + "_" + sbbeId));
        SbbID sbbId = this.getSbbId();
        this.pool = this.serviceContainer.getObjectPool(sbbId);
        this.sbbComponent = (SbbDescriptorImpl)SleeContainer.lookupFromJndi().getSbbComponent(sbbId);
        if (this.sbbComponent == null) {
            String s = "Sbb component/descriptor not found for sbbID[" + this.getSbbId() + "],\n" + "  sbbEntityID[" + sbbeId + "]" + "Transaction[ID:" + this.tm.getTransaction() + "]";
            log.warn((Object)s);
            throw new RuntimeException(s);
        }
    }

    public void printNode() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\n SbbEntity.printNode() { \nsbbEntityID  = " + this.sbbeId + "\nsbbID  = " + this.getSbbId() + "\nattachmentCount = " + this.getAttachmentCount() + "\nrootSbbId = " + this.getRootSbbId() + "\nparentSbbID = " + this.getParentSbbId() + "\nserviceID = " + this.getServiceId() + "\nactivityContexts = " + this.getActivityContexts() + "\neventMask = " + this.eventMask + "\nchildRelation = " + this.childRelations + "\nconvergenceName = " + this.getServiceConvergenceName() + "\nsbbLocalObjectCmpFields = " + this.sbbLocalObjectCmpFields + "\ncmpFields = " + this.cmpFields + "\n}"));
        }
    }

    private Object getObjectFromCache(Object key) {
        Object result = this.cachedSbbEntityAttributes.get(key);
        return result;
    }

    private Object putObjectInCache(Object key, Object value) {
        Object result = this.cachedSbbEntityAttributes.put(key, value);
        return result;
    }

    public void storeToCache() throws SystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SbbEntity.storeToCache for SbbEntity: ");
            this.printNode();
        }
        if (log.isDebugEnabled()) {
            this.printNode();
        }
    }

    public String getNodeName() {
        return "sbbentity:" + this.sbbeId;
    }

    private void addEventMaskEntry(String acID, Set evMask, boolean replace) {
        Set oldEvMask;
        if (log.isDebugEnabled()) {
            log.debug((Object)("addEventMaskEntry : " + acID + " eventMask = " + evMask));
        }
        if ((oldEvMask = (Set)this.eventMask.get(acID)) == null) {
            this.eventMask.put(acID, evMask);
        } else if (!replace) {
            oldEvMask.addAll(evMask);
        } else {
            this.eventMask.put(acID, evMask);
        }
    }

    private void removeEventMaskEntry(String acID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeEventMaskEntry : " + acID));
        }
        this.eventMask.remove(acID);
    }

    private void addAcToActivityContexts(String acId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addAcToActivityContexts : sbbEid " + this.getNodeName() + " acId " + acId));
        }
        this.getActivityContexts().add(acId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("attached ACs " + this.getNodeName() + " " + this.getActivityContexts()));
        }
    }

    private void removeAcFromActivityContexts(String acId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeAcFromActivityContexts : sbbEid " + this.getNodeName() + " acId " + acId));
        }
        this.getActivityContexts().remove(acId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("attached ACs " + this.getNodeName() + " " + this.getActivityContexts()));
        }
    }

    public Object getCMPField(CMPField cmpField) throws TransactionRequiredLocalException, SystemException {
        SleeTransactionManager sleeTm = SleeContainer.getTransactionManager();
        sleeTm.mandateTransaction();
        String key = this.genCMPFieldKey(cmpField);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCMPField() " + cmpField.getFieldName()));
        }
        if (this.sbbLocalObjectCmpFields.contains(key)) {
            String eid = (String)this.cmpFields.get(key);
            SbbEntity sbbe = null;
            try {
                sbbe = this.sbbEntityFactory.getSbbEntity(eid);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (sbbe == null) {
                return null;
            }
            if (sbbe.isRemoved()) {
                return null;
            }
            return sbbe.createSbbLocalObject();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCMPField() value = " + this.cmpFields.get(key)));
        }
        return this.cmpFields.get(key);
    }

    public void setCMPField(CMPField field, Object object) throws TransactionRequiredLocalException, SystemException {
        SleeContainer.getTransactionManager().mandateTransaction();
        String key = this.genCMPFieldKey(field);
        if (log.isDebugEnabled()) {
            log.debug((Object)("putCMPField(): putting cmp field : " + this.getCMPFieldsNodeName() + "/" + " object = " + object));
        }
        if (object instanceof SbbLocalObjectImpl) {
            this.sbbLocalObjectCmpFields.add(key);
            SbbLocalObjectImpl sbbLocal = (SbbLocalObjectImpl)object;
            String eid = sbbLocal.getSbbEntityId();
            this.cmpFields.put(key, eid);
        } else {
            this.cmpFields.put(key, object);
        }
    }

    private String getCMPFieldsNodeName() {
        return this.getNodeName() + "/CMP";
    }

    private String genCMPFieldKey(CMPField cmpField) {
        return cmpField.getFieldName();
    }

    protected void afterACAttach(String acId) {
        SbbDescriptorImpl sbbComponent;
        EventTypeID[] eventTypeIDs;
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterACAttach " + acId + " sbbID = " + this.getSbbId()));
        }
        if ((eventTypeIDs = (sbbComponent = this.getSbbDescriptor()).getEventTypes()) != null) {
            HashSet<EventTypeID> maskedEvents = new HashSet<EventTypeID>();
            for (int i = 0; i < eventTypeIDs.length; ++i) {
                SbbEventEntry sbbEventEntry = sbbComponent.getEventType(sbbComponent.getEventName(eventTypeIDs[i]));
                if (!sbbEventEntry.isMasked()) continue;
                maskedEvents.add(eventTypeIDs[i]);
            }
            this.addEventMaskEntry(acId, maskedEvents, false);
        } else {
            this.addEventMaskEntry(acId, new HashSet(), false);
        }
        this.addAcToActivityContexts(acId);
        this.incrementAttachmentCount();
    }

    protected void afterACDetach(String acId) {
        try {
            this.removeAcFromActivityContexts(acId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("AFTERDETACH Called. AC=" + acId + " SET=" + this.getActivityContexts() + " attachmentCount before decrement = " + this.getAttachmentCount()));
            }
            this.decrementAttachmentCount();
            this.removeEventMaskEntry(acId);
        }
        catch (Exception ex) {
            throw new RuntimeException("unexpected error", ex);
        }
    }

    public void incrementAttachmentCount() {
        int count = this.getAttachmentCount();
        this.setAttachmentCount(++count);
        if (log.isDebugEnabled()) {
            log.debug((Object)("incrementing attachment count current count = " + count));
        }
        if (!this.getParentSbbId().equals(this.sbbeId)) {
            this.serviceContainer.getSbbEntityFactory().getSbbEntity(this.getParentSbbId()).incrementAttachmentCount();
        }
    }

    public void decrementAttachmentCount() {
        int count = this.getAttachmentCount();
        this.setAttachmentCount(count - 1);
        if (!this.getParentSbbId().equals(this.sbbeId)) {
            this.serviceContainer.getSbbEntityFactory().getSbbEntity(this.getParentSbbId()).decrementAttachmentCount();
        }
    }

    public Set getMaskedEventTypes(String acId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMaskedEventTypes: " + acId));
        }
        return this.eventMask.get(acId) != null ? (Set)this.eventMask.get(acId) : new HashSet();
    }

    public void setEventMask(String acId, String[] eventMask) throws UnrecognizedEventException {
        HashSet<EventTypeIDImpl> maskedEvents = new HashSet<EventTypeIDImpl>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("setEventMask " + acId + " eventMask = " + eventMask));
        }
        SbbDescriptorImpl sbbComponent = this.getSbbDescriptor();
        if (eventMask != null && eventMask.length != 0) {
            for (int i = 0; i < eventMask.length; ++i) {
                SbbEventEntry sbbEventEntry = sbbComponent.getEventType(eventMask[i]);
                if (sbbEventEntry == null) {
                    throw new UnrecognizedEventException("Event is not known by this SBB.");
                }
                if (!sbbEventEntry.isReceived()) {
                    throw new UnrecognizedEventException("Event " + eventMask[i] + " has no receive direction for this SBB.");
                }
                maskedEvents.add(this.serviceContainer.getEventType(sbbEventEntry.getEventTypeRefKey()));
            }
        }
        this.addEventMaskEntry(acId, maskedEvents, true);
    }

    public Set getActivityContexts() {
        Set acs = (Set)this.getObjectFromCache(ACTIVITY_CONTEXTS);
        return acs;
    }

    private void setActivityContexts(Set activityContexts) {
        this.putObjectInCache(ACTIVITY_CONTEXTS, activityContexts);
    }

    public String[] getEventMask(String acId) {
        Set evMask = (Set)this.eventMask.get(acId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getEventMask: returning  event mask for" + acId));
        }
        if (evMask == null) {
            log.debug((Object)("getEventMask: returning null event mask for" + acId));
            return null;
        }
        String[] events = new String[evMask.size()];
        if (evMask.isEmpty() && log.isDebugEnabled()) {
            log.debug((Object)("eventMask = " + this.eventMask));
        }
        Iterator evMaskIt = evMask.iterator();
        SbbDescriptorImpl sbbComponent = this.getSbbDescriptor();
        int i = 0;
        while (evMaskIt.hasNext()) {
            EventTypeID eventTypeId = (EventTypeID)evMaskIt.next();
            events[i] = sbbComponent.getEventName(eventTypeId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getEventMask:eventName = " + events[i]));
            }
            ++i;
        }
        return events;
    }

    public void setParentSbbEntity(String parentSbbEntityId) {
        this.setParentSbbId(parentSbbEntityId);
    }

    public String getRootSbbId() {
        String rootSbbId = (String)this.getObjectFromCache(ROOT_SBB_ID);
        return rootSbbId;
    }

    public void setRootSbbId(String rsbbId) {
        this.putObjectInCache(ROOT_SBB_ID, rsbbId);
    }

    public int getAttachmentCount() {
        Integer count = (Integer)this.getObjectFromCache("attachmentCount");
        return count;
    }

    public void setAttachmentCount(int count) {
        this.putObjectInCache("attachmentCount", new Integer(count));
    }

    private void addChildRelation(String name, HashSet childRelation) {
        this.childRelations.put(name, childRelation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("addChildRelation " + name + " childRelation " + childRelation));
        }
    }

    private Map getChildRelations() {
        return this.childRelations;
    }

    private void createChildRelations() {
        SbbDescriptorImpl sbbComponent = this.getSbbDescriptor();
        if (sbbComponent == null) {
            return;
        }
        HashSet refs = sbbComponent.getSbbRef();
        Iterator i = refs.iterator();
        GetChildRelationMethod[] crm = sbbComponent.getChildRelationMethods();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SbbId = " + this.getSbbId()));
        }
        while (i.hasNext()) {
            SbbRef ref = (SbbRef)i.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("sbbRefs = " + ref.getComponentKey()));
            }
            GetChildRelationMethod getChildRelationMethod = null;
            for (int k = 0; k < crm.length; ++k) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ChildRelationMethod method key" + crm[k].getChildPKey()));
                    log.debug((Object)("Ref Component:" + ref.getComponentKey()));
                }
                if (!crm[k].getChildPKey().equals(ref.getComponentKey())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ChildRelationMethod method key" + crm[k].getChildPKey()));
                    log.debug((Object)("ChildRelationMethod method name" + crm[k].getMethodName()));
                    log.debug((Object)ref.getComponentKey());
                }
                if ((getChildRelationMethod = crm[k]) == null) {
                    log.error((Object)"Cannot find referenced child relation.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding to child relation " + crm[k].getMethodName()));
                }
                this.addChildRelation(crm[k].getMethodName(), new HashSet());
            }
        }
    }

    public byte getPriority() {
        Byte p = (Byte)this.getObjectFromCache(PRIORITY);
        return p;
    }

    public void setPriority(byte priority) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SbbEntity.setPriority() " + priority));
        }
        this.putObjectInCache(PRIORITY, new Byte(priority));
    }

    public void remove() throws TransactionRequiredException, SystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SbbEntity.remove(): Removing entity with id:" + this.getSbbEntityId()));
            log.debug((Object)this.getSbbDescriptor().getName());
        }
        this.removeRecursive();
        this.removeFromParent();
        this.removeEntity();
        this.isBeingRemoved = true;
    }

    private void removeRecursive() throws TransactionRequiredException, SystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"In removerecursive");
        }
        this.detachMe();
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove: Sbb Entity " + this.sbbeId + " detached from AC"));
        }
        try {
            if (this.sbbObject == null) {
                this.assignSbbObject(false);
            }
        }
        catch (Exception e) {
            String s = "Failed to initialise sbb entity";
            log.error((Object)s, (Throwable)e);
            throw new RuntimeException(s, e);
        }
        try {
            this.sbbObject.sbbStore();
            this.releaseObject(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.tm.setRollbackOnly();
                this.trashObject();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new RuntimeException("Transaction Failure.", e2);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding prepareaction to remove entity:" + this.getSbbEntityId()));
        }
        Iterator it1 = this.getChildRelations().values().iterator();
        while (it1.hasNext()) {
            Set childRelation = (Set)it1.next();
            Iterator it2 = childRelation.iterator();
            while (it2.hasNext()) {
                Object nextobj = it2.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("child is " + nextobj.getClass()));
                }
                String sbbeId = (String)nextobj;
                it2.remove();
                if (childRelation.isEmpty()) {
                    it1.remove();
                }
                SbbEntity sbbe = this.serviceContainer.getSbbEntityFactory().getSbbEntity(sbbeId);
                try {
                    if (!this.sbbeId.equals(sbbeId)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("acquiring lock for SbbEntity [ SbbEntity  = " + sbbe.getSbbEntityId() + "]"));
                        }
                        EventRouterImpl.getSbbEntityLock(sbbe.getSbbEntityId()).acquire();
                    }
                    sbbe.removeRecursive();
                }
                catch (InterruptedException e) {
                    String s = "failed to obtain lock for sbb entity = " + sbbeId;
                    log.error((Object)s, (Throwable)e);
                    throw new RuntimeException(s, e);
                }
                finally {
                    if (this.sbbeId.equals(sbbeId)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("releasing lock for SbbEntity [ SbbEntity  = " + sbbe.getSbbEntityId() + "]"));
                    }
                    EventRouterImpl.getSbbEntityLock(sbbe.getSbbEntityId()).release();
                }
            }
        }
    }

    private void removeFromParent() throws TransactionRequiredException, SystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"In removeFromParent");
        }
        if (this.getParentSbbId() != null && !this.getParentSbbId().equals(this.sbbeId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Here we go...");
            }
            SbbEntity parentSbbEntity = this.serviceContainer.getSbbEntityFactory().getSbbEntity(this.getParentSbbId());
            Map childRelations = parentSbbEntity.getChildRelations();
            if (log.isDebugEnabled()) {
                log.debug((Object)("child relations size:" + childRelations.size()));
            }
            Iterator it1 = childRelations.values().iterator();
            while (it1.hasNext()) {
                Set childRelation = (Set)it1.next();
                Iterator it2 = childRelation.iterator();
                while (it2.hasNext()) {
                    String sbbeId;
                    Object nextobj = it2.next();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("child is " + nextobj.getClass()));
                    }
                    if (!(sbbeId = (String)nextobj).equals(this.sbbeId)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Found the sbb in a child relation");
                    }
                    it2.remove();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("child relations size2:" + childRelations.size()));
            }
        }
    }

    public void nonSleeInitiatedCascadingRemoval() throws TransactionRequiredLocalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("nonSleeInitiatedCascadingRemoval : " + this.getSbbId() + " entityID = " + this.getSbbEntityId()));
        }
        try {
            if (this.sbbObject == null) {
                this.assignSbbObject(false);
            }
        }
        catch (Exception e) {
            String s = "Failed to initialise sbb entity";
            log.error((Object)s, (Throwable)e);
            throw new RuntimeException(s, e);
        }
        try {
            this.remove();
        }
        catch (TransactionRequiredException e1) {
            throw new TransactionRequiredLocalException("Remove failed", (Throwable)e1);
        }
        catch (SystemException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        try {
            if (this.tm.getRollbackOnly()) {
                RolledBackContextImpl sbbRolledBackContext = new RolledBackContextImpl(this.currentEvent.getEventObject(), new ActivityContextInterfaceImpl(this.serviceContainer, this.currentEvent.getActivityContextID()), true);
                this.getParentSbbId();
                this.tm.addAfterRollbackAction(new RolledBackAction(this.getParentSbbId(), this.serviceContainer.getSbbEntityFactory(), sbbRolledBackContext));
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private void detachMe() {
        Service service = this.getService();
        if (service != null && this.sbbeId.equals(this.getRootSbbId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("rootSbbEntityId = " + this.getRootSbbId() + "; serviceConvergenceName = " + this.getServiceConvergenceName()));
            }
            service.removeConvergenceName(this.getServiceConvergenceName());
        }
        Iterator it = this.getActivityContexts().iterator();
        if (log.isDebugEnabled()) {
            log.debug((Object)("detachMe(): activityContexts = " + this.getActivityContexts()));
        }
        while (it.hasNext()) {
            ActivityContext ac;
            String key = (String)it.next();
            it.remove();
            if (log.isDebugEnabled()) {
                log.debug((Object)("detachMe(): Activity context key is:" + key));
            }
            if ((ac = this.serviceContainer.getActivityContextFactory().getActivityContextById(key)) != null) {
                ac.detachSbbEntity(this.sbbeId);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(" detached " + this.sbbeId + " from activity context id " + key));
        }
    }

    public void trashObject() {
        try {
            this.pool.invalidateObject((Object)this.sbbObject);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception ", e);
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
        if (this.sbbObject != null) {
            this.sbbObject.sbbRolledBack(context);
            this.sbbObject.sbbStore();
            this.sbbObject.sbbPassivate();
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Unexpected case. Check it!");
        }
    }

    public Service getService() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting service " + this.getServiceId()));
        }
        ServiceID serviceId = null;
        try {
            serviceId = this.getServiceId();
            return SleeContainer.lookupFromJndi().getService(serviceId);
        }
        catch (Exception ex) {
            log.warn((Object)("Cannot get service[" + serviceId + "] for SbbEntity[ID:" + this.sbbeId + "]"), (Throwable)ex);
            throw new RuntimeException("Cannot get service ", ex);
        }
    }

    public void setSbbObject(SbbObject sbbObject) throws RuntimeException {
        this.sbbObject = sbbObject;
    }

    public String getSbbEntityId() {
        return this.sbbeId;
    }

    public Set getReceivedEventTypes() {
        SbbDescriptorImpl sbbComponent = this.getSbbDescriptor();
        if (log.isDebugEnabled()) {
            log.debug((Object)"getReceivedEventTypes()");
            log.debug((Object)("sbbComponent is:" + sbbComponent));
        }
        return sbbComponent.getReceivedEvents();
    }

    public SbbID getSbbId() {
        SbbID sbbId = (SbbID)this.getObjectFromCache(SBB_ID);
        return sbbId;
    }

    public void setSbbId(SbbID sbbId) {
        this.putObjectInCache(SBB_ID, sbbId);
    }

    public String getUsageParameterPathName(String name) {
        return Service.getUsageParametersPathName(this.getServiceId(), this.getSbbId(), name);
    }

    public String getUsageParameterPathName() {
        return Service.getUsageParametersPathName(this.getServiceId(), this.getSbbId());
    }

    public String getIdentity() {
        return this.sbbeId;
    }

    public SleeEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public void setCurrentEvent(SleeEvent sleeEvent) {
        this.currentEvent = sleeEvent;
    }

    private Method getEventHandlerMethod(SleeEvent sleeEvent) {
        String s;
        boolean isCustomAciMethod;
        Method method;
        Class[] args;
        Class concreteClass;
        String methodName;
        block13: {
            EventTypeID eventType = sleeEvent.getEventTypeID();
            SbbDescriptorImpl sbbDescriptor = this.getSbbDescriptor();
            methodName = "on" + sbbDescriptor.getEventName(eventType);
            concreteClass = sbbDescriptor.getConcreteSbbClass();
            if (log.isDebugEnabled()) {
                log.debug((Object)("invoking event handler " + methodName + " on " + concreteClass.getName() + " ID " + sbbDescriptor.getID() + " sbbEntity " + this + " currentEvent " + sleeEvent));
            }
            args = new Class[2];
            EventTypeDescriptorImpl eventDescriptor = this.serviceContainer.getEventDescriptor(sleeEvent.getEventTypeID());
            if (log.isDebugEnabled()) {
                log.debug((Object)("EventType ID" + sleeEvent.getEventTypeID()));
                log.debug((Object)("EventDescriptor ID" + this.serviceContainer.getEventDescriptor(sleeEvent.getEventTypeID())));
            }
            ClassLoader ccl = SleeContainerUtils.getCurrentThreadClassLoader();
            try {
                args[0] = ccl.loadClass(eventDescriptor.getEventClassName());
            }
            catch (ClassNotFoundException e) {
                String s2 = "Caught ClassNotFoundException in loading class";
                log.error((Object)s2, (Throwable)e);
                throw new RuntimeException(s2, e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("event className is " + eventDescriptor.getEventClassName()));
                log.debug((Object)("event class is ARGS[0] of the event handler: args[0] == " + args[0]));
            }
            method = null;
            isCustomAciMethod = false;
            String customAciName = sbbDescriptor.getActivityContextInterfaceClassName();
            if (customAciName != null) {
                try {
                    args[1] = ccl.loadClass(customAciName);
                }
                catch (ClassNotFoundException e) {
                    String s3 = "Caught ClassNotFoundException while attempting to check for event handler signature with custom SBB ACI.";
                    log.error((Object)s3, (Throwable)e);
                    throw new RuntimeException(s3, e);
                }
                try {
                    method = concreteClass.getMethod(methodName, args);
                    isCustomAciMethod = true;
                }
                catch (NoSuchMethodException e) {
                    s = "Caught NoSuchMethodException in loading class. There is no event handler with custom SBB ACI argument";
                    if (!log.isDebugEnabled()) break block13;
                    log.debug((Object)s, (Throwable)e);
                }
            }
        }
        if (!isCustomAciMethod) {
            try {
                args[1] = ActivityContextInterface.class;
                method = concreteClass.getMethod(methodName, args);
            }
            catch (NoSuchMethodException e) {
                s = "Caught NoSuchMethodException while loading event handler method.";
                log.error((Object)s, (Throwable)e);
                throw new RuntimeException(s, e);
            }
        }
        return method;
    }

    private Object[] getEventHandlerParameters(SleeEvent sleeEvent) {
        Object[] parameters = new Object[2];
        if (log.isDebugEnabled()) {
            log.debug((Object)("parameter [0] " + sleeEvent.getEventObject().getClass().getName()));
        }
        parameters[0] = sleeEvent.getEventObject();
        if (log.isDebugEnabled()) {
            log.debug((Object)("**PARAMETER 0 IS:" + parameters[0]));
            log.debug((Object)("**PARAM 0 class is:" + parameters[0].getClass().getName()));
        }
        ActivityContextInterfaceImpl activityContextInterface = null;
        if (this.getSbbDescriptor().getActivityContextInterface() != null) {
            ActivityContextInterfaceImpl aciImpl = new ActivityContextInterfaceImpl(this.serviceContainer, sleeEvent.getActivityContextID());
            Class aciClass = this.getSbbDescriptor().getActivityContextInterfaceConcreteClass();
            try {
                activityContextInterface = (ActivityContextInterface)aciClass.getConstructor(aciImpl.getClass(), this.getSbbDescriptor().getClass()).newInstance(aciImpl, this.getSbbDescriptor());
            }
            catch (Exception e) {
                String s = "Could Not create ACI!";
                log.error((Object)s, (Throwable)e);
                throw new RuntimeException(s, e);
            }
        } else {
            activityContextInterface = new ActivityContextInterfaceImpl(this.serviceContainer, sleeEvent.getActivityContextID());
        }
        sleeEvent.setActivityContextInterface(activityContextInterface);
        parameters[1] = activityContextInterface;
        if (log.isDebugEnabled()) {
            log.debug((Object)("**PARAMETER 1 IS:" + parameters[1]));
            log.debug((Object)("**PARAM 1 class is:" + parameters[1].getClass().getName()));
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServiceActivityFactory() throws Exception {
        Context ctx = (Context)new InitialContext().lookup("java:comp");
        Context envCtx = null;
        try {
            envCtx = ctx.createSubcontext("env");
        }
        catch (NameAlreadyBoundException ex) {
            envCtx = (Context)ctx.lookup("env");
        }
        Context sleeCtx = null;
        try {
            sleeCtx = envCtx.createSubcontext("slee");
        }
        catch (NameAlreadyBoundException ex) {
            sleeCtx = (Context)envCtx.lookup("slee");
        }
        Context newCtx = null;
        try {
            newCtx = sleeCtx.createSubcontext("serviceactivity");
        }
        catch (NameAlreadyBoundException ex) {
        }
        finally {
            newCtx = (Context)sleeCtx.lookup("serviceactivity");
        }
        try {
            newCtx.bind("factory", (Object)new ServiceActivityFactoryImpl((ServiceIDImpl)this.getServiceId()));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeEventHandler(SleeEvent sleeEvent) throws Exception {
        Method method = this.getEventHandlerMethod(sleeEvent);
        this.setServiceActivityFactory();
        Object[] parameters = this.getEventHandlerParameters(sleeEvent);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking event handler:" + method));
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = this.getSbbDescriptor().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            this.transaction = SleeContainer.getTransactionManager().getTransaction();
            method.invoke((Object)this.sbbObject.getSbbConcrete(), parameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getCause();
            if (realException instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)realException;
                throw re;
            }
            if (realException instanceof Error) {
                Error re = (Error)realException;
                throw re;
            }
            if (realException instanceof Exception) {
                Exception re = (Exception)realException;
                throw re;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invoked event handler");
        }
    }

    public void assignSbbObject(boolean invokeSbbCreate) throws Exception {
        block7: {
            try {
                this.sbbObject = (SbbObject)this.pool.borrowObject();
                if (!invokeSbbCreate) {
                    this.sbbObject.sbbActivate();
                    this.sbbObject.setSbbEntity(this);
                    this.sbbObject.setState(SbbObjectState.READY);
                    break block7;
                }
                try {
                    this.sbbObject.setSbbEntity(this);
                    this.sbbObject.sbbCreate();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Ran sbbCreate");
                    }
                    this.sbbObject.setState(SbbObjectState.READY);
                    this.sbbObject.sbbPostCreate();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Ran sbbPostCreate");
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Exception trhown ", (Throwable)ex);
                    this.removeEntity();
                    throw ex;
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to borrow object", (Throwable)e);
                throw e;
            }
        }
    }

    public void assignAndActivateSbbObject() throws Exception {
        try {
            this.sbbObject = (SbbObject)this.pool.borrowObject();
            this.sbbObject.sbbActivate();
            this.sbbObject.setSbbEntity(this);
            this.sbbObject.setState(SbbObjectState.READY);
        }
        catch (Exception e) {
            log.error((Object)"Failed to borrow object", (Throwable)e);
            throw e;
        }
    }

    public void releaseObject(boolean remove) throws Exception {
        if (remove) {
            this.sbbObject.sbbRemove();
            this.sbbObject.setState(SbbObjectState.POOLED);
            this.pool.returnObject((Object)this.sbbObject);
            this.sbbObject = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"releaseObject: Removing Entity Returned SbbObject to the Pool!");
            }
        } else {
            this.sbbObject.sbbPassivate();
            this.sbbObject.setState(SbbObjectState.POOLED);
            this.pool.returnObject((Object)this.sbbObject);
            this.sbbObject = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"releaseObject: Returned SbbObject to the Pool!");
            }
        }
    }

    public ObjectPool getObjectPool() {
        return this.pool;
    }

    public SleeContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public SbbObject getSbbObject() {
        return this.sbbObject;
    }

    public boolean checkAttached(String acId) {
        return this.getActivityContexts().contains(acId);
    }

    public Object getDefaultSbbUsageParameterSet() {
        return Service.getDefaultUsageParameterSet(this.getServiceId(), this.getSbbId());
    }

    public Object getSbbUsageParameterSet(String name) {
        return Service.getNamedUsageParameter(this.getServiceId(), this.getSbbId(), name);
    }

    public SbbDescriptorImpl getSbbDescriptor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"In getSbbDescriptor");
        }
        return this.sbbComponent;
    }

    public ChildRelation getChildRelation(String accessorName) {
        SbbDescriptorImpl sbbComponent = this.getSbbDescriptor();
        HashSet refs = sbbComponent.getSbbRef();
        Iterator i = refs.iterator();
        GetChildRelationMethod[] crm = sbbComponent.getChildRelationMethods();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildRelation() : SbbId = " + this.getSbbId()));
        }
        this.getChildRelations();
        while (i.hasNext()) {
            SbbRef ref = (SbbRef)i.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("getChildRelation(): sbbRefs = " + ref.getComponentKey()));
            }
            GetChildRelationMethod getChildRelationMethod = null;
            this.getChildRelations();
            for (int k = 0; k < crm.length; ++k) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getChildRelation() : ChildRelationMethod method key" + crm[k].getChildPKey()));
                    log.debug((Object)("getChildRelation() : Ref Component:" + ref.getComponentKey()));
                }
                if (!crm[k].getChildPKey().equals(ref.getComponentKey())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getChildRelation() : ChildRelationMethod method key" + crm[k].getChildPKey()));
                    log.debug((Object)("getChildRelation() : ChildRelationMethod method name" + crm[k].getMethodName()));
                    log.debug((Object)ref.getComponentKey());
                }
                if ((getChildRelationMethod = crm[k]) == null) {
                    log.error((Object)"Cannot find referenced child relation.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("REF ALIAS: " + crm[k].getMethodName()));
                }
                if (!accessorName.equals(crm[k].getMethodName())) continue;
                return new ChildRelationImpl(new SbbIDImpl(ref.getComponentKey()), getChildRelationMethod.getDefaultPriority(), this, (HashSet)this.childRelations.get(crm[k].getMethodName()));
            }
        }
        log.error((Object)"Child Relation Not Found.");
        return null;
    }

    public void asSbbActivityContextInterface(ActivityContextInterface aci) {
        try {
            ActivityContextInterfaceImpl aciImpl = (ActivityContextInterfaceImpl)aci;
            Class aciclass = this.getSbbDescriptor().getActivityContextInterfaceConcreteClass();
            if (aciclass != null) {
                Class[] argTypes = new Class[]{aciImpl.getClass(), SbbDescriptorImpl.class};
                Constructor cons = aciclass.getConstructor(argTypes);
                Object retval = cons.newInstance(aciImpl, this.getSbbDescriptor());
                SbbConcrete sbbConcrete = (SbbConcrete)this.getSbbObject().getSbbConcrete();
                sbbConcrete.sbbSetActivityContextInterface(retval);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean equals(Object other) {
        return other.getClass().equals(SbbEntity.class) && ((SbbEntity)other).getSbbEntityId().equals(this.sbbeId);
    }

    public void checkReEntrant() throws SLEEException {
        try {
            if (!this.getSbbDescriptor().isReentrant() && this.transaction == SleeContainer.getTransactionManager().getTransaction()) {
                throw new SLEEException(" re-entrancy not allowed ");
            }
        }
        catch (SystemException ex) {
            log.error((Object)"Unexepcted system exception ", (Throwable)ex);
            throw new RuntimeException("Unexpected Exception ! ");
        }
    }

    public SbbLocalObject createSbbLocalObject() {
        Class sbbLocalClass;
        SbbDescriptorImpl sbbDescriptor = this.getSbbDescriptor();
        if (log.isDebugEnabled()) {
            log.debug((Object)("createSbbLocalObject " + this.getSbbDescriptor().getID()));
        }
        if ((sbbLocalClass = sbbDescriptor.getLocalInterfaceConcreteClass()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("creatingCustom local class " + sbbLocalClass.getName()));
            }
            Object[] objs = new Object[]{this};
            Class[] types = new Class[]{SbbEntity.class};
            try {
                return (SbbLocalObject)sbbLocalClass.getConstructor(types).newInstance(objs);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to create Sbb Local Interface.", e);
            }
        }
        return new SbbLocalObjectImpl(this.serviceContainer, this.sbbeId);
    }

    public boolean isRemoved() {
        return this.isBeingRemoved;
    }

    private void removeEntity() {
        this.serviceContainer.getSbbEntityFactory().removeFromCache(this.getSbbEntityId());
        this.cmpFields.remove();
        this.eventMask.remove();
        this.childRelations.remove();
        this.cachedSbbEntityAttributes.remove();
        this.isBeingRemoved = true;
    }

    private void setParentSbbId(String parentSbbId) {
        this.putObjectInCache(PARENT_SBB_ID, parentSbbId);
    }

    public String getParentSbbId() {
        String sbbId = (String)this.getObjectFromCache(PARENT_SBB_ID);
        return sbbId;
    }

    static {
        tcache = TransactionManagerImpl.TCACHE;
        SBB_ID_CACHE = TransactionManagerImpl.TCACHE;
        ACTIVITY_CONTEXTS_CACHE = TransactionManagerImpl.TCACHE;
        EVENT_MASK_CACHE = TransactionManagerImpl.TCACHE;
        CHILD_RELATIONS_CACHE = TransactionManagerImpl.TCACHE;
        CMP_FIELDS_CACHE = TransactionManagerImpl.TCACHE;
        log = Logger.getLogger((Class)SbbEntity.class);
    }

    private class RolledBackAction
    implements TransactionalAction {
        String sbbeId;
        SbbEntityFactory factory;
        RolledBackContext rollbackContext;

        public RolledBackAction(String sbbeId, SbbEntityFactory factory, RolledBackContext context) {
            this.sbbeId = sbbeId;
            this.factory = factory;
            this.rollbackContext = context;
        }

        public void execute() {
            SbbEntity sbbe = null;
            try {
                SbbEntity.this.tm.begin();
                sbbe = this.factory.getSbbEntity(this.sbbeId);
                sbbe.sbbRolledBack(this.rollbackContext);
                SbbEntity.this.sbbObject.sbbStore();
                SbbEntity.this.tm.commit();
            }
            catch (RuntimeException e) {
                sbbe.trashObject();
                sbbe.setSbbObject(null);
                e.printStackTrace();
                try {
                    if (SbbEntity.this.tm.isInTx()) {
                        SbbEntity.this.tm.rollback();
                    }
                }
                catch (SystemException e1) {
                    log.error((Object)e1);
                }
            }
            catch (Exception e) {
                sbbe.trashObject();
                sbbe.setSbbObject(null);
                e.printStackTrace();
                try {
                    if (SbbEntity.this.tm.isInTx()) {
                        SbbEntity.this.tm.rollback();
                    }
                }
                catch (SystemException e1) {
                    log.error((Object)e1);
                }
            }
        }
    }
}

