/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import java.rmi.dgc.VMID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.SbbEntity;

public class SbbEntityFactory {
    private SleeContainer serviceContainer;
    private static Logger log = Logger.getLogger((Class)SbbEntityFactory.class);

    public SbbEntityFactory(SleeContainer container) {
        this.serviceContainer = container;
    }

    private String genId() {
        VMID vmid = new VMID();
        return vmid.toString();
    }

    public SbbEntity createSbbEntity(SbbID sbbId, ServiceID svcId, String parentSbbEntityId, String convergenceName) {
        try {
            String sbbeId = this.genId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("createSbbEntity: Creating non-root sbb entity with id:" + sbbeId));
            }
            SbbEntity sbbe = new SbbEntity(sbbeId, sbbId, convergenceName, svcId);
            sbbe.setParentSbbEntity(parentSbbEntityId);
            sbbe.setRootSbbId(this.serviceContainer.getService(svcId).getRootSbbEntityId(convergenceName));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Putting it in the map");
            }
            this.putInTxCache(sbbeId, sbbe);
            return sbbe;
        }
        catch (Exception ex) {
            String s = "unexpected error in creating sbbEntity!";
            log.error((Object)s, (Throwable)ex);
            throw new RuntimeException(s, ex);
        }
    }

    public SbbEntity createRootSbbEnity(SbbID sbbId, ServiceID svcId, String convergenceName) {
        try {
            String sbbeId = this.genId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating root sbb entity with id:" + sbbeId));
            }
            SbbEntity sbbe = new SbbEntity(sbbeId, sbbId, convergenceName, svcId);
            sbbe.setParentSbbEntity(sbbeId);
            sbbe.setRootSbbId(sbbeId);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Putting it in the map");
            }
            this.putInTxCache(sbbeId, sbbe);
            return sbbe;
        }
        catch (Exception ex) {
            String s = "unexpected exception in createSbbEntity";
            log.error((Object)s, (Throwable)ex);
            throw new RuntimeException(s, ex);
        }
    }

    private void putInTxCache(String sbbeID, SbbEntity sbb) {
        SleeContainer.getTransactionManager().putTxLocalData("sbb" + sbbeID, sbb);
    }

    public void removeFromCache(String sbbeId) {
        block2: {
            try {
                SleeContainer.getTransactionManager().removeTxLocalData("sbb" + sbbeId);
            }
            catch (SystemException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("Failed to remove sbbentity, " + sbbeId + "from tx cache"));
            }
        }
    }

    public SbbEntity getSbbEntity(String sbbeId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSbbEntity : " + sbbeId));
        }
        if (sbbeId == null) {
            throw new NullPointerException("Null Sbbeid");
        }
        SbbEntity sbb = (SbbEntity)SleeContainer.getTransactionManager().getTxLocalData("sbb" + sbbeId);
        if (sbb == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot find sbb in per tx cache - loading from treecache");
            }
            sbb = new SbbEntity(sbbeId);
            SleeContainer.getTransactionManager().putTxLocalData("sbb" + sbbeId, sbb);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Found sbb in per tx cache");
        }
        return sbb;
    }
}

