/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime;

import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.InvalidStateException;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.EventTypeIDImpl;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactory;
import org.mobicents.slee.runtime.ActivityContextState;
import org.mobicents.slee.runtime.ActivityEndEventImpl;
import org.mobicents.slee.runtime.DeferredEvent;
import org.mobicents.slee.runtime.EventRouter;
import org.mobicents.slee.runtime.SleeInternalEndpoint;

public class SleeInternalEndpointImpl
implements SleeInternalEndpoint {
    private ActivityContextFactory acf;
    private SleeContainer container;
    private EventRouter router;
    private boolean active;
    private static Logger logger = Logger.getLogger((Class)SleeInternalEndpointImpl.class);
    private int activityEndEventID;
    private EventTypeID activityEndEventTypeID;

    public void enqueueEvent(EventTypeID eventTypeId, Object event, Object activity, Address address) throws IllegalStateException, InvalidStateException {
        this.router.routeEvent(eventTypeId, event, activity, address);
    }

    public void enqueueEvent(int eventID, Object event, Object activity, Address address) throws IllegalStateException, InvalidStateException {
        EventTypeIDImpl eventTypeId = this.container.getEventTypeID(eventID);
        this.enqueueEvent(eventTypeId, event, activity, address);
    }

    public void activityCreatedBySbb(Object activity) {
        ActivityContext ac = this.acf.getActivityContext(activity);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Activity Created by Sbb is: " + ac.getActivityContextId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleActivityEndedEvent(Object activity) throws IllegalStateException {
        boolean txStarted = SleeContainer.getTransactionManager().requireTransaction();
        try {
            ActivityContext ac;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Notifying that activity has ended:" + activity));
            }
            if (!(ac = this.acf.getActivityContext(activity)).getState().equals(ActivityContextState.ACTIVE)) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set state to ending for act " + ac.getActivity() + " ac_id=" + ac.getActivityContextId()));
            }
            ActivityEndEventImpl eventObj = new ActivityEndEventImpl();
            DeferredEvent ev = new DeferredEvent(this.container, this.activityEndEventID, (Object)eventObj, activity, null);
            SleeContainer.getTransactionManager().addAfterCommitAction(ev);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Added deferred event");
            }
        }
        catch (Exception e) {
            logger.error((Object)"caught exception while ending activity ", (Throwable)e);
            try {
                SleeContainer.getTransactionManager().setRollbackOnly();
            }
            catch (SystemException ex) {
                throw new RuntimeException("Tx manager failed ! ", ex);
            }
        }
        finally {
            try {
                if (txStarted) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("tx manager failed ");
            }
        }
    }

    public SleeInternalEndpointImpl(ActivityContextFactory activityContextFactory, EventRouter router, SleeContainer container) {
        this.acf = activityContextFactory;
        this.router = router;
        this.container = container;
        this.active = true;
        ComponentKey key = new ComponentKey("javax.slee.ActivityEndEvent", "javax.slee", "1.0");
        this.activityEndEventID = this.container.getEventLookupFacility().getEventID(key);
        this.activityEndEventTypeID = this.container.getEventType(key);
    }
}

