/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mobicents.slee.runtime.cache.TxLocalMap;
import org.mobicents.slee.runtime.cache.VersionedEntry;
import org.mobicents.slee.runtime.cache.XACache;

public class CacheableMap
implements Map {
    Object mapKey = null;
    protected static final Object NULL_VALUE = new NullCMapValue();

    public CacheableMap(Object mapKey) {
        if (mapKey == null) {
            throw new NullPointerException("map key cannot be null");
        }
        this.mapKey = mapKey;
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (this.isRemoved()) {
            throw new IllegalStateException("The map has been marked for removal");
        }
        this.snapshot();
        VersionedEntry ventry = this.innerGet(key);
        return ventry != null && !ventry.isRemoved();
    }

    public Object put(Object key, Object newValue) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (newValue == null) {
            newValue = NULL_VALUE;
        }
        if (this.isRemoved()) {
            this.getTxLocalMap().revive();
        }
        this.snapshot();
        VersionedEntry ventry = this.innerGet(key);
        if (ventry != null) {
            Object oldValue = null;
            oldValue = ventry.isRemoved() ? null : ventry.getValue();
            ventry.setValue(newValue);
            if (oldValue != null && oldValue.equals(NULL_VALUE)) {
                oldValue = null;
            }
            return oldValue;
        }
        VersionedEntry newEntry = new VersionedEntry(key, newValue);
        this.getTxLocalMap().put(key, newEntry);
        return null;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (this.isRemoved()) {
            throw new IllegalStateException("The map has been marked for removal");
        }
        this.snapshot();
        VersionedEntry ventry = this.innerGet(key);
        if (ventry == null || ventry.isRemoved()) {
            return null;
        }
        Object value = ventry.getValue();
        if (NULL_VALUE.equals(value)) {
            value = null;
        }
        return value;
    }

    private void snapshot() {
        if (this.getTxLocalMap().isAllowPhantomReads() || this.getTxLocalMap().isSnapshotTaken()) {
            return;
        }
        this.getTxLocalMap().setSnapshotTaken(true);
        Set actualKeys = this.getActualMap().keySet();
        Iterator iter = actualKeys.iterator();
        while (iter.hasNext()) {
            Object nextKey = iter.next();
            VersionedEntry actualEntry = (VersionedEntry)this.getActualMap().get(nextKey);
            if (actualEntry == null) continue;
            VersionedEntry txLocalEntry = new VersionedEntry(actualEntry);
            this.getTxLocalMap().put(nextKey, txLocalEntry);
        }
    }

    private VersionedEntry innerGet(Object key) {
        VersionedEntry entry = (VersionedEntry)this.getTxLocalMap().get(key);
        if (entry != null) {
            return entry;
        }
        if (this.getTxLocalMap().isAllowPhantomReads()) {
            VersionedEntry actualEntry = (VersionedEntry)this.getActualMap().get(key);
            if (actualEntry == null) {
                return null;
            }
            VersionedEntry txLocalEntry = new VersionedEntry(actualEntry);
            this.getTxLocalMap().put(key, txLocalEntry);
            return txLocalEntry;
        }
        return null;
    }

    public Object remove(Object key) {
        if (this.isRemoved()) {
            return null;
        }
        this.snapshot();
        VersionedEntry oldValue = this.innerGet(key);
        if (oldValue == null) {
            return null;
        }
        VersionedEntry ventry = oldValue;
        if (ventry.isRemoved()) {
            return null;
        }
        Object result = ventry.getValue();
        ventry.markRemoved();
        return result;
    }

    public int size() {
        if (this.isRemoved()) {
            throw new IllegalStateException("The map has been marked for removal");
        }
        return this.keySet().size();
    }

    public boolean isEmpty() {
        boolean isEmpty = this.size() == 0;
        return isEmpty;
    }

    public Set keySet() {
        if (this.isRemoved()) {
            throw new IllegalStateException("The map has been marked for removal");
        }
        HashSet result = new HashSet();
        if (this.getTxLocalMap().isAllowPhantomReads()) {
            result.addAll(this.getActualMap().keySet());
        } else {
            this.snapshot();
        }
        Iterator newEntries = this.getTxLocalMap().entrySet().iterator();
        while (newEntries.hasNext()) {
            Map.Entry nextEntry = (Map.Entry)newEntries.next();
            VersionedEntry ventry = (VersionedEntry)nextEntry.getValue();
            if (ventry.isRemoved()) {
                result.remove(nextEntry.getKey());
                continue;
            }
            result.add(nextEntry.getKey());
        }
        return result;
    }

    public void clear() {
        if (this.isRemoved()) {
            return;
        }
        if (this.getTxLocalMap().isAllowPhantomReads()) {
            Set actualKeys = this.getActualMap().keySet();
            Iterator iter = actualKeys.iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                this.innerGet(key);
            }
        } else {
            this.snapshot();
        }
        Iterator localIter = this.getTxLocalMap().keySet().iterator();
        while (localIter.hasNext()) {
            this.remove(localIter.next());
        }
    }

    public void putAll(Map map) {
        if (map == null) {
            throw new NullPointerException("map to be merged cannot be null");
        }
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        if (this.isRemoved()) {
            throw new IllegalStateException("The map has been marked for removal");
        }
        Set keys = this.keySet();
        HashMap rawEntries = new HashMap();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Object nextKey = iter.next();
            rawEntries.put(nextKey, this.get(nextKey));
        }
        Set entries = rawEntries.entrySet();
        return entries;
    }

    public Collection values() {
        if (this.isRemoved()) {
            throw new IllegalStateException("The map has been marked for removal");
        }
        Set keys = this.keySet();
        ArrayList<Object> rawValues = new ArrayList<Object>();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Object nextKey = iter.next();
            rawValues.add(this.get(nextKey));
        }
        return rawValues;
    }

    public void remove() {
        this.getTxLocalMap().remove();
    }

    boolean isRemoved() {
        return this.getTxLocalMap().isRemoved();
    }

    private TxLocalMap getTxLocalMap() {
        return XACache.getInstance().getTxLocalMap(this.mapKey);
    }

    private Map getActualMap() {
        return XACache.getInstance().getActualMap(this.mapKey);
    }

    public void setAllowPhantomReads(boolean allowPhantoms) {
        this.getTxLocalMap().setAllowPhantomReads(allowPhantoms);
    }

    static class NullCMapValue
    implements Serializable {
        private static final long serialVersionUID = 1814658447351397636L;

        NullCMapValue() {
        }
    }
}

