/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.mobicents.slee.runtime.cache.CacheableMap;

public class CacheableSet
implements Set,
Serializable {
    private static final long serialVersionUID = -4925272152876951668L;
    private CacheableMap cmap;

    public CacheableSet(Object setKey) {
        this.cmap = new CacheableMap(setKey);
    }

    public String toString() {
        return this.cmap.keySet().toString();
    }

    public int size() {
        return this.cmap.size();
    }

    public void clear() {
        this.cmap.clear();
    }

    public boolean isEmpty() {
        return this.cmap.isEmpty();
    }

    public Object[] toArray() {
        return this.cmap.keySet().toArray();
    }

    public boolean add(Object obj) {
        if (this.cmap.containsKey(obj)) {
            return false;
        }
        this.cmap.put(obj, CacheableMap.NULL_VALUE);
        return true;
    }

    public boolean contains(Object obj) {
        return this.cmap.containsKey(obj);
    }

    public boolean remove(Object obj) {
        boolean retval = this.cmap.containsKey(obj);
        if (retval) {
            this.cmap.remove(obj);
        }
        return retval;
    }

    public boolean addAll(Collection c) {
        boolean retval = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (this.cmap.containsKey(obj)) continue;
            retval = true;
            this.cmap.put(obj, (Object)null);
        }
        return retval;
    }

    public boolean containsAll(Collection c) {
        return this.cmap.keySet().containsAll(c);
    }

    public boolean removeAll(Collection c) {
        boolean retval = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!this.cmap.containsKey(obj)) continue;
            retval = true;
            this.cmap.remove(obj);
        }
        return retval;
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public Iterator iterator() {
        return this.cmap.keySet().iterator();
    }

    public Object[] toArray(Object[] obj) {
        return this.cmap.keySet().toArray(obj);
    }

    public void remove() {
        this.cmap.remove();
    }
}

