/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.cache.TxLocalMap;
import org.mobicents.slee.runtime.cache.XACacheXAManager;

public class XACache {
    private static XACache tmem = null;
    private Map actualMaps = new ConcurrentHashMap();
    private WeakHashMap txLocalViews = new WeakHashMap();
    private static TransactionManager transactionManager = null;

    public static void setTransactionManager(TransactionManager txm) {
        if (txm == null) {
            throw new NullPointerException("TransactionManager cannot be null");
        }
        transactionManager = txm;
    }

    static synchronized XACache getInstance() {
        if (tmem == null) {
            if (transactionManager == null) {
                transactionManager = SleeContainer.getTransactionManager();
            }
            tmem = new XACache();
        }
        return tmem;
    }

    synchronized TxLocalMap getTxLocalMap(Object key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        Transaction tx = this.getTransaction();
        Map txLocalView = this.getTxLocalView(tx);
        TxLocalMap txlmap = (TxLocalMap)((Object)txLocalView.get(key));
        if (txlmap != null) {
            return txlmap;
        }
        txlmap = new TxLocalMap();
        txLocalView.put(key, txlmap);
        return txlmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getActualMap(Object key) {
        Map map = this.actualMaps;
        synchronized (map) {
            Map actualMap = (Map)this.actualMaps.get(key);
            if (actualMap == null) {
                actualMap = new ConcurrentHashMap();
                this.actualMaps.put(key, actualMap);
            }
            return actualMap;
        }
    }

    private Transaction getTransaction() {
        Transaction tx = null;
        try {
            tx = transactionManager.getTransaction();
            if (tx == null) {
                throw new IllegalStateException("Failed to obtain transaction. tx is null.");
            }
        }
        catch (SystemException e) {
            throw new IllegalStateException("Failed to obtain transaction due to SystemException.[" + (Object)((Object)e) + "]");
        }
        try {
            if (tx.getStatus() != 0 && tx.getStatus() != 1) {
                throw new IllegalStateException("There is no active tx, tx[" + tx + "] is in state: " + tx.getStatus());
            }
        }
        catch (SystemException e) {
            throw new IllegalStateException("Failed to check transaction status for tx[ " + tx + " ] due to SystemException.[" + (Object)((Object)e) + "]");
        }
        return tx;
    }

    Map getTxLocalView(Transaction tx) {
        Map txLocalView = (Map)this.txLocalViews.get(tx);
        if (txLocalView == null) {
            txLocalView = new ConcurrentHashMap();
            this.txLocalViews.put(tx, txLocalView);
            XACacheXAManager xares = new XACacheXAManager(tx, this);
            try {
                tx.enlistResource((XAResource)xares);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to enlist XAMapResource in tx: [ " + tx + " ][" + e + "]");
            }
        }
        return txLocalView;
    }

    void removeTxLocalView(Transaction tx) {
        this.txLocalViews.remove(tx);
    }

    Map getActualMaps() {
        return this.actualMaps;
    }
}

