/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.mobicents.slee.runtime.cache.AbstractXAResource;
import org.mobicents.slee.runtime.cache.TxLocalMap;
import org.mobicents.slee.runtime.cache.VersionedEntry;
import org.mobicents.slee.runtime.cache.XACache;

public class XACacheXAManager
extends AbstractXAResource {
    Transaction tx = null;
    XACache xaCache = null;
    private Logger logger = Logger.getLogger(XACacheXAManager.class.getName());
    static final /* synthetic */ boolean $assertionsDisabled;

    XACacheXAManager(Transaction tx, XACache xacache) {
        if (!$assertionsDisabled && tx == null) {
            throw new AssertionError((Object)"transaction cannot be null");
        }
        if (!$assertionsDisabled && xacache == null) {
            throw new AssertionError((Object)"xacache cannot be null");
        }
        this.logger.fine("Registering as XAResource for tx[" + tx + "]");
        this.tx = tx;
        this.xaCache = xacache;
    }

    public void end(Xid xid, int flags) throws XAException {
        this.logger.fine("Transaction end. tx[" + this.tx + "], xid[" + xid + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        Map actualMaps;
        Map txLocalView = this.xaCache.getTxLocalView(this.tx);
        this.logger.fine("Transaction commit. tx[" + this.tx + "], xid[" + xid + "]");
        if (txLocalView == null) {
            this.logger.log(Level.WARNING, "txLocalView is null for tx[" + this.tx + "], xid[" + xid + "]\n" + "This should never happen. \n" + "If a CacheXAManager was registered with a tx, \n" + "that is only because there was access to a map strucure in the tx context.");
            return;
        }
        this.xaCache.removeTxLocalView(this.tx);
        Map map = actualMaps = this.xaCache.getActualMaps();
        synchronized (map) {
            Map actualMap;
            TxLocalMap nextLocalMap;
            Map.Entry entry;
            boolean verificationFailed = false;
            Iterator mapsIter = txLocalView.entrySet().iterator();
            while (mapsIter.hasNext() && !verificationFailed) {
                entry = mapsIter.next();
                nextLocalMap = (TxLocalMap)((Object)entry.getValue());
                actualMap = (Map)actualMaps.get(entry.getKey());
                verificationFailed = !this.verifyMap(entry.getKey(), nextLocalMap, actualMap);
            }
            if (verificationFailed) {
                throw new XAException(6);
            }
            mapsIter = txLocalView.entrySet().iterator();
            while (mapsIter.hasNext()) {
                entry = mapsIter.next();
                nextLocalMap = (TxLocalMap)((Object)entry.getValue());
                actualMap = (Map)actualMaps.get(entry.getKey());
                if (nextLocalMap.isRemoved()) {
                    actualMaps.remove(entry.getKey());
                    continue;
                }
                this.commitMapChanges(entry.getKey(), nextLocalMap, actualMap);
            }
        }
    }

    private boolean verifyMap(Object mapKey, TxLocalMap localMap, Map actualMap) {
        if (localMap.isRemoved()) {
            return true;
        }
        boolean actualMapRemoved = false;
        if (actualMap == null) {
            actualMapRemoved = true;
        }
        Set txLocalEntries = localMap.entrySet();
        Iterator iter = txLocalEntries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            VersionedEntry txLocalEntry = (VersionedEntry)entry.getValue();
            if (!txLocalEntry.isDirty()) {
                iter.remove();
                continue;
            }
            if (actualMapRemoved) {
                this.xaCache.getActualMap(mapKey);
                return true;
            }
            VersionedEntry actualEntry = (VersionedEntry)actualMap.get(entry.getKey());
            if (actualEntry == null || txLocalEntry.isNewerVersion(actualEntry) || txLocalEntry.getValue().equals(actualEntry.getValue())) continue;
            this.logger.warning("Failed to commit XACache writes in tx[" + this.tx + ".\n" + "Reason: Entry version verification failed for Map[" + mapKey + "].\n" + "Reason: Committing entry is not newer version than the actual entry's version.\n" + " entry key[" + entry.getKey() + "]\n" + " committing entry version[" + txLocalEntry.getVersion() + "]\n" + " committing entry value[" + txLocalEntry.getValue() + "]\n" + " actual entry version[" + actualEntry.getVersion() + "].\n" + " actual entry value[" + actualEntry.getValue() + "]");
            return false;
        }
        return true;
    }

    private void commitMapChanges(Object mapKey, TxLocalMap txLocalMap, Map actualMap) {
        Set txLocalEntries = txLocalMap.entrySet();
        Iterator iter = txLocalEntries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            VersionedEntry txLocalEntry = (VersionedEntry)entry.getValue();
            VersionedEntry actualEntry = (VersionedEntry)actualMap.get(entry.getKey());
            if (actualEntry == null) {
                if (txLocalEntry.isRemoved()) continue;
                actualMap.put(entry.getKey(), txLocalEntry);
                continue;
            }
            if (txLocalEntry.isRemoved()) {
                actualMap.remove(entry.getKey());
                continue;
            }
            if (txLocalEntry.getValue().equals(actualEntry.getValue())) continue;
            actualMap.put(entry.getKey(), txLocalEntry);
        }
    }

    public void rollback(Xid xid) throws XAException {
        this.logger.info("Transaction rollback. tx[" + this.tx + "], xid[" + xid + "]");
        this.xaCache.removeTxLocalView(this.tx);
    }

    static {
        $assertionsDisabled = !XACacheXAManager.class.desiredAssertionStatus();
    }
}

