/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache.tests;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mobicents.slee.runtime.cache.tests.XidMockup;

public class TransactionMockup
implements Transaction {
    private int status = 0;
    private Set resources = new HashSet();

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        if (this.getStatus() != 0) {
            throw new IllegalStateException("Tx status is not ACTIVE. Instead status is: " + this.getStatus());
        }
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            XAResource res = (XAResource)iter.next();
            try {
                res.commit(this.getXid(), false);
            }
            catch (XAException e) {
                throw new RuntimeException("failed to commmit", e);
            }
        }
        this.status = 3;
    }

    public boolean delistResource(XAResource arg0, int arg1) throws IllegalStateException, SystemException {
        return false;
    }

    public boolean enlistResource(XAResource newResource) throws RollbackException, IllegalStateException, SystemException {
        if (this.getStatus() != 0) {
            throw new IllegalStateException("Tx status is not ACTIVE. Instead status is: " + this.getStatus());
        }
        this.resources.add(newResource);
        return true;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization arg0) throws RollbackException, IllegalStateException, SystemException {
    }

    public void rollback() throws IllegalStateException, SystemException {
        if (this.getStatus() != 0) {
            throw new IllegalStateException("Tx status is not ACTIVE. Instead status is: " + this.getStatus());
        }
        this.status = 1;
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            XAResource res = (XAResource)iter.next();
            try {
                res.rollback(this.getXid());
            }
            catch (XAException e) {
                throw new RuntimeException("failed to rollback cleanly", e);
            }
        }
        this.status = 4;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
    }

    private Xid getXid() {
        return new XidMockup();
    }
}

