/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.cache.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.cache.XACache;
import org.mobicents.slee.runtime.cache.tests.TransactionManagerMockup;
import org.mobicents.slee.runtime.cache.tests.TransactionMockup;

public class ZBasicCacheableMapTest
extends TestCase {
    private TransactionManagerMockup txm = null;
    private CacheableMap cmap = null;

    public ZBasicCacheableMapTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ZBasicCacheableMapTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.txm = new TransactionManagerMockup();
        TransactionMockup tx = new TransactionMockup();
        this.txm.pushCurrentTransaction(tx);
        XACache.setTransactionManager(this.txm);
        this.cmap = new CacheableMap("testMap");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testContainsUnexistentKey() {
        boolean b = this.cmap.containsKey("unsetKey");
        ZBasicCacheableMapTest.assertFalse((String)"should return false", (boolean)b);
    }

    public void testContainsExistingKey() {
        this.cmap.put("key1", new Object());
        boolean b = this.cmap.containsKey("key1");
        ZBasicCacheableMapTest.assertTrue((String)"should return true", (boolean)b);
    }

    public void testGetExistingEntry() {
        Object someObj = new Object();
        this.cmap.put("key1", someObj);
        Object o = this.cmap.get("key1");
        ZBasicCacheableMapTest.assertEquals((String)"should return the object that was put in", (Object)someObj, (Object)o);
    }

    public void testGetUnsetEntry() {
        Object o = this.cmap.get("unsetKey");
        ZBasicCacheableMapTest.assertNull((String)"CacheableMap.get('unsetKey') should return null", (Object)o);
    }

    public void testPutNullKey() {
        try {
            this.cmap.put((Object)null, "something");
            ZBasicCacheableMapTest.fail((String)"null keys should not be allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPutNullValue() {
        this.cmap.put("key1", (Object)null);
    }

    public void testGetAfterRemove() {
        try {
            this.cmap.remove();
            this.cmap.get("key1");
            ZBasicCacheableMapTest.fail((String)"get() after remove is illegal.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPutAfterRemove() {
        this.cmap.put("key1", "v1");
        this.cmap.remove();
        this.cmap.put("key2", "v2");
        Object oldEntry = this.cmap.get("key1");
        ZBasicCacheableMapTest.assertNull((String)"no gargbage should be found in a cmap after revival.", (Object)oldEntry);
        Object newEntry = this.cmap.get("key2");
        ZBasicCacheableMapTest.assertEquals((String)"the new entry should be there.", (Object)"v2", (Object)newEntry);
    }
}

